/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.client.configuration;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.cxf.Bus;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transport.http.HTTPConduitFactory;
import org.apache.cxf.transport.http.HTTPTransportFactory;
import org.apache.cxf.transport.http.URLConnectionHTTPConduit;
import org.apache.cxf.transports.http.configuration.ConnectionType;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.jboss.wsf.stack.cxf.client.configuration.AbstractHTTPConduitFactoryWrapper;
import org.jboss.wsf.stack.cxf.client.configuration.SecurityActions;

public final class DefaultHTTPConduitFactoryWrapper
extends AbstractHTTPConduitFactoryWrapper {
    private static final Map<String, Object> defaultConfiguration;
    private final Map<String, Object> configuration;

    public DefaultHTTPConduitFactoryWrapper(HTTPConduitFactory delegate) {
        super(delegate);
        this.configuration = defaultConfiguration;
    }

    public DefaultHTTPConduitFactoryWrapper(Map<String, Object> configuration, boolean useSystemDefault, HTTPConduitFactory delegate) {
        super(delegate);
        if (configuration == null) {
            throw new IllegalArgumentException();
        }
        if (useSystemDefault) {
            this.configuration = new HashMap<String, Object>();
            for (Map.Entry<String, Object> e : defaultConfiguration.entrySet()) {
                String key = e.getKey();
                this.configuration.put(key, e.getValue());
                Object providedValue = configuration.get(key);
                if (providedValue == null) continue;
                this.configuration.put(key, providedValue);
            }
        } else {
            this.configuration = configuration;
        }
    }

    @Override
    protected HTTPConduit createNewConduit(HTTPTransportFactory f, Bus b, EndpointInfo localInfo, EndpointReferenceType target) throws IOException {
        return new URLConnectionHTTPConduit(b, localInfo, target);
    }

    @Override
    protected void configureConduit(HTTPConduit conduit) {
        this.configureTLSClient(conduit);
        this.configureHTTPClientPolicy(conduit);
    }

    private void configureTLSClient(HTTPConduit conduit) {
        TLSClientParameters parameters = conduit.getTlsClientParameters();
        if (parameters == null) {
            parameters = new TLSClientParameters();
            parameters.setUseHttpsURLConnectionDefaultSslSocketFactory(true);
            if (Boolean.TRUE.equals((Boolean)this.configuration.get("cxf.tls-client.disableCNCheck"))) {
                parameters.setDisableCNCheck(true);
            }
            conduit.setTlsClientParameters(parameters);
        }
    }

    private void configureHTTPClientPolicy(HTTPConduit conduit) {
        boolean set = false;
        Boolean allowChunking = (Boolean)this.configuration.get("cxf.client.allowChunking");
        set = set || allowChunking != null;
        Integer chunkingThreshold = (Integer)this.configuration.get("cxf.client.chunkingThreshold");
        set = set || chunkingThreshold != null;
        Long connectionTimeout = (Long)this.configuration.get("cxf.client.connectionTimeout");
        set = set || connectionTimeout != null;
        Long receiveTimeout = (Long)this.configuration.get("cxf.client.receiveTimeout");
        set = set || receiveTimeout != null;
        String connection = (String)this.configuration.get("cxf.client.connection");
        boolean bl = set = set || connection != null;
        if (set) {
            HTTPClientPolicy httpClientPolicy = conduit.getClient();
            if (httpClientPolicy == null) {
                httpClientPolicy = new HTTPClientPolicy();
                conduit.setClient(httpClientPolicy);
            }
            if (allowChunking != null) {
                httpClientPolicy.setAllowChunking(allowChunking.booleanValue());
            }
            if (chunkingThreshold != null) {
                httpClientPolicy.setChunkingThreshold(chunkingThreshold.intValue());
            }
            if (connectionTimeout != null) {
                httpClientPolicy.setConnectionTimeout(connectionTimeout.longValue());
            }
            if (receiveTimeout != null) {
                httpClientPolicy.setReceiveTimeout(receiveTimeout.longValue());
            }
            if (connection != null) {
                httpClientPolicy.setConnection(ConnectionType.fromValue((String)connection));
            }
        }
    }

    public static void install(Bus bus) {
        HTTPConduitFactory delegate = (HTTPConduitFactory)bus.getExtension(HTTPConduitFactory.class);
        bus.setExtension((Object)new DefaultHTTPConduitFactoryWrapper(delegate), HTTPConduitFactory.class);
    }

    static {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cxf.client.allowChunking", SecurityActions.getBoolean("cxf.client.allowChunking", null));
        map.put("cxf.client.chunkingThreshold", SecurityActions.getInteger("cxf.client.chunkingThreshold", null));
        map.put("cxf.tls-client.disableCNCheck", SecurityActions.getBoolean("cxf.tls-client.disableCNCheck"));
        map.put("cxf.client.connectionTimeout", SecurityActions.getLong("cxf.client.connectionTimeout", null));
        map.put("cxf.client.receiveTimeout", SecurityActions.getLong("cxf.client.receiveTimeout", null));
        map.put("cxf.client.connection", SecurityActions.getSystemProperty("cxf.client.connection", null));
        defaultConfiguration = Collections.unmodifiableMap(map);
    }
}

