/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.infinispan.marshalling.protostream;

import java.io.IOException;
import java.io.StreamCorruptedException;
import java.util.OptionalInt;
import org.infinispan.commons.io.ByteBufferImpl;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.RawProtoStreamReader;
import org.infinispan.protostream.RawProtoStreamWriter;
import org.wildfly.clustering.marshalling.protostream.Predictable;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;

public enum ByteBufferMarshaller implements ProtoStreamMarshaller<ByteBufferImpl>
{
    INSTANCE;


    public ByteBufferImpl readFrom(ImmutableSerializationContext context, RawProtoStreamReader reader) throws IOException {
        byte[] bytes = reader.readByteArray();
        if (reader.readTag() != 0) {
            throw new StreamCorruptedException();
        }
        return ByteBufferImpl.create((byte[])bytes);
    }

    public void writeTo(ImmutableSerializationContext context, RawProtoStreamWriter writer, ByteBufferImpl buffer) throws IOException {
        writer.writeUInt32NoTag(buffer.getLength());
        writer.writeRawBytes(buffer.getBuf(), buffer.getOffset(), buffer.getLength());
    }

    public OptionalInt size(ImmutableSerializationContext context, ByteBufferImpl buffer) {
        return OptionalInt.of(Predictable.byteArraySize((int)buffer.getLength()));
    }

    public Class<? extends ByteBufferImpl> getJavaClass() {
        return ByteBufferImpl.class;
    }
}

