/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.reactive.publisher.impl.commands.batch;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.Util;
import org.infinispan.reactive.publisher.impl.commands.batch.KeyPublisherResponse;
import org.infinispan.reactive.publisher.impl.commands.batch.PublisherResponse;

public class PublisherResponseExternalizer
extends AbstractExternalizer<PublisherResponse> {
    public Integer getId() {
        return 149;
    }

    public Set<Class<? extends PublisherResponse>> getTypeClasses() {
        return Util.asSet((Object[])new Class[]{PublisherResponse.class, KeyPublisherResponse.class});
    }

    public void writeObject(ObjectOutput output, PublisherResponse object) throws IOException {
        output.writeObject(object.completedSegments);
        output.writeObject(object.lostSegments);
        output.writeBoolean(object.complete);
        if (object instanceof KeyPublisherResponse) {
            int i;
            KeyPublisherResponse keyResponse = (KeyPublisherResponse)object;
            UnsignedNumeric.writeUnsignedInt((ObjectOutput)output, (int)(keyResponse.size + keyResponse.segmentOffset));
            for (i = 0; i < keyResponse.size; ++i) {
                output.writeObject(keyResponse.results[i]);
            }
            for (i = 0; i < keyResponse.segmentOffset; ++i) {
                output.writeObject(keyResponse.extraObjects[i]);
            }
            output.writeBoolean(true);
            UnsignedNumeric.writeUnsignedInt((ObjectOutput)output, (int)keyResponse.keySize);
            for (i = 0; i < keyResponse.keySize; ++i) {
                output.writeObject(keyResponse.keys[i]);
            }
        } else {
            UnsignedNumeric.writeUnsignedInt((ObjectOutput)output, (int)object.size);
            for (int i = 0; i < object.size; ++i) {
                output.writeObject(object.results[i]);
            }
            output.writeBoolean(false);
            UnsignedNumeric.writeUnsignedInt((ObjectOutput)output, (int)object.segmentOffset);
        }
    }

    public PublisherResponse readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        IntSet completedSegments = (IntSet)input.readObject();
        IntSet lostSegments = (IntSet)input.readObject();
        boolean complete = input.readBoolean();
        int size = UnsignedNumeric.readUnsignedInt((ObjectInput)input);
        Object[] values = new Object[size];
        for (int i = 0; i < size; ++i) {
            values[i] = input.readObject();
        }
        boolean keyResponse = input.readBoolean();
        if (keyResponse) {
            int keySize = UnsignedNumeric.readUnsignedInt((ObjectInput)input);
            Object[] keys = new Object[keySize];
            for (int i = 0; i < keySize; ++i) {
                keys[i] = input.readObject();
            }
            return new KeyPublisherResponse(values, completedSegments, lostSegments, size, complete, null, 0, keys, keySize);
        }
        int segmentOffset = UnsignedNumeric.readUnsignedInt((ObjectInput)input);
        return new PublisherResponse(values, completedSegments, lostSegments, size, complete, segmentOffset);
    }
}

