/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.authz;

import java.util.Iterator;
import org.wildfly.security.authz.Roles;

class AddSuffixRoles
implements Roles {
    private final Roles delegate;
    private final String suffix;

    AddSuffixRoles(Roles delegate, String suffix) {
        this.delegate = delegate;
        this.suffix = suffix;
    }

    @Override
    public boolean contains(String roleName) {
        String suffix = this.suffix;
        return roleName.endsWith(suffix) && this.delegate.contains(roleName.substring(0, roleName.length() - suffix.length()));
    }

    @Override
    public Iterator<String> iterator() {
        final Iterator iterator = this.delegate.iterator();
        return new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public String next() {
                return (String)iterator.next() + AddSuffixRoles.this.suffix;
            }
        };
    }
}

