/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.password.impl;

import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Arrays;
import javax.security.auth.DestroyFailedException;
import org.wildfly.security.password.impl.AbstractPasswordImpl;
import org.wildfly.security.password.interfaces.ClearPassword;
import org.wildfly.security.password.spec.ClearPasswordSpec;

final class ClearPasswordImpl
extends AbstractPasswordImpl
implements ClearPassword {
    private static final long serialVersionUID = -3949572193624333918L;
    private char[] password;

    ClearPasswordImpl(char[] password) {
        this.password = password;
    }

    ClearPasswordImpl(ClearPassword clearPassword) {
        this.password = (char[])clearPassword.getPassword().clone();
    }

    @Override
    public String getAlgorithm() {
        return "clear";
    }

    @Override
    public char[] getPassword() throws IllegalStateException {
        try {
            return (char[])this.password.clone();
        }
        catch (NullPointerException ignored) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void destroy() throws DestroyFailedException {
        char[] password = this.password;
        this.password = null;
        if (password != null) {
            Arrays.fill(password, '\u0000');
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.password == null;
    }

    @Override
    <S extends KeySpec> S getKeySpec(Class<S> keySpecType) throws InvalidKeySpecException {
        if (keySpecType.isAssignableFrom(ClearPasswordSpec.class)) {
            char[] password = this.getPassword();
            return (S)((KeySpec)keySpecType.cast(new ClearPasswordSpec((char[])password.clone())));
        }
        throw new InvalidKeySpecException();
    }

    @Override
    boolean verify(char[] guess) {
        return Arrays.equals(this.getPassword(), guess);
    }

    @Override
    <T extends KeySpec> boolean convertibleTo(Class<T> keySpecType) {
        return keySpecType.isAssignableFrom(ClearPasswordSpec.class);
    }

    private void readObject(ObjectInputStream ignored) throws NotSerializableException {
        throw new NotSerializableException();
    }

    Object writeReplace() {
        return ClearPassword.createRaw(this.getAlgorithm(), this.password);
    }

    @Override
    public ClearPasswordImpl clone() {
        char[] password = this.password;
        if (password == null) {
            return this;
        }
        return new ClearPasswordImpl((char[])password.clone());
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.password);
    }

    @Override
    public boolean equals(Object obj) {
        char[] password = this.password;
        return obj instanceof ClearPasswordImpl && password != null && Arrays.equals(password, ((ClearPasswordImpl)obj).password);
    }
}

