/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.StreamCorruptedException;
import java.util.OptionalInt;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.RawProtoStreamReader;
import org.infinispan.protostream.RawProtoStreamWriter;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamObjectInput;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamObjectOutput;

public class ExternalizerMarshaller<T>
implements ProtoStreamMarshaller<T> {
    private final Externalizer<T> externalizer;

    public ExternalizerMarshaller(Externalizer<T> externalizer) {
        this.externalizer = externalizer;
    }

    public Class<? extends T> getJavaClass() {
        return this.externalizer.getTargetClass();
    }

    public T readFrom(ImmutableSerializationContext context, RawProtoStreamReader reader) throws IOException {
        try {
            Object result = this.externalizer.readObject((ObjectInput)new ProtoStreamObjectInput(context, reader));
            if (reader.readTag() != 0) {
                throw new StreamCorruptedException();
            }
            return (T)result;
        }
        catch (ClassNotFoundException e) {
            InvalidClassException exception = new InvalidClassException(e.getMessage());
            exception.initCause(e);
            throw exception;
        }
    }

    public void writeTo(ImmutableSerializationContext context, RawProtoStreamWriter writer, T object) throws IOException {
        this.externalizer.writeObject((ObjectOutput)new ProtoStreamObjectOutput(context, writer), object);
    }

    @Override
    public OptionalInt size(ImmutableSerializationContext context, T value) {
        return this.externalizer.size(value);
    }
}

