/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.impl;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.infinispan.protostream.EnumMarshaller;
import org.infinispan.protostream.RawProtoStreamReader;
import org.infinispan.protostream.RawProtoStreamWriter;
import org.infinispan.protostream.UnknownFieldSet;
import org.infinispan.protostream.descriptors.EnumDescriptor;
import org.infinispan.protostream.descriptors.EnumValueDescriptor;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.protostream.impl.BaseMarshallerDelegate;
import org.infinispan.protostream.impl.ProtoStreamReaderImpl;
import org.infinispan.protostream.impl.ProtoStreamWriterImpl;

public final class EnumMarshallerDelegate<T extends Enum<T>>
implements BaseMarshallerDelegate<T> {
    private final EnumMarshaller<T> enumMarshaller;
    private final Set<Integer> definedValues;

    EnumMarshallerDelegate(EnumMarshaller<T> enumMarshaller, EnumDescriptor enumDescriptor) {
        this.enumMarshaller = enumMarshaller;
        this.definedValues = new HashSet<Integer>(enumDescriptor.getValues().size());
        for (EnumValueDescriptor evd : enumDescriptor.getValues()) {
            this.definedValues.add(evd.getNumber());
        }
    }

    @Override
    public EnumMarshaller<T> getMarshaller() {
        return this.enumMarshaller;
    }

    @Override
    public void marshall(FieldDescriptor fd, T value, ProtoStreamWriterImpl writer, RawProtoStreamWriter out) throws IOException {
        this.writeEnum(fd.getNumber(), value, out);
    }

    public void writeEnum(int fieldNumber, T value, RawProtoStreamWriter out) throws IOException {
        int enumValue = this.enumMarshaller.encode(value);
        if (!this.definedValues.contains(enumValue)) {
            throw new IllegalArgumentException("Undefined enum value : " + enumValue);
        }
        out.writeEnum(fieldNumber, enumValue);
    }

    @Override
    public T unmarshall(FieldDescriptor fd, ProtoStreamReaderImpl reader, RawProtoStreamReader in) throws IOException {
        int enumValue;
        int expectedTag = fd.getWireTag();
        UnknownFieldSet unknownFieldSet = reader.getUnknownFieldSet();
        Object o = unknownFieldSet.consumeTag(expectedTag);
        if (o != null) {
            enumValue = ((Long)o).intValue();
        } else {
            while (true) {
                int tag;
                if ((tag = in.readTag()) == 0) {
                    return null;
                }
                if (tag == expectedTag) {
                    enumValue = in.readEnum();
                    break;
                }
                unknownFieldSet.readSingleField(tag, in);
            }
        }
        return this.readEnum(expectedTag, enumValue, unknownFieldSet);
    }

    public T readEnum(int expectedTag, int enumValue, UnknownFieldSet unknownFieldSet) {
        T decoded = this.enumMarshaller.decode(enumValue);
        if (decoded == null) {
            unknownFieldSet.putVarintField(expectedTag, enumValue);
        }
        return decoded;
    }
}

