/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.controller.git;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.persistence.AbstractConfigurationPersister;
import org.jboss.as.controller.persistence.AbstractFilePersistenceResource;
import org.jboss.as.controller.persistence.ConfigurationPersistenceException;
import org.jboss.as.server.controller.git.GitRepository;
import org.jboss.dmr.ModelNode;

public class GitConfigurationPersistenceResource
extends AbstractFilePersistenceResource {
    protected final File file;
    private final GitRepository repository;

    public GitConfigurationPersistenceResource(ModelNode model, File fileName, GitRepository repository, AbstractConfigurationPersister persister) throws ConfigurationPersistenceException {
        super(model, persister);
        this.file = fileName;
        this.repository = repository;
    }

    public void rollback() {
        super.rollback();
        try (Git git = this.repository.getGit();){
            git.reset().setMode(ResetCommand.ResetType.HARD).setRef("HEAD").call();
        }
        catch (GitAPIException ex) {
            ControllerLogger.MGMT_OP_LOGGER.failedToStoreConfiguration((Throwable)ex, this.file.getName());
        }
    }

    protected void gitCommit(String msg) {
        try (Git git = this.repository.getGit();){
            if (!git.status().call().isClean()) {
                git.commit().setMessage(msg).setAll(true).setNoVerify(true).call();
            }
        }
        catch (GitAPIException e) {
            ControllerLogger.MGMT_OP_LOGGER.failedToStoreConfiguration((Throwable)e, this.file.getName());
        }
    }

    protected void doCommit(InputStream in) {
        try {
            Files.copy(in, this.file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            this.gitCommit("Storing configuration");
        }
        catch (IOException ex) {
            ControllerLogger.MGMT_OP_LOGGER.failedToStoreConfiguration((Throwable)ex, this.file.getName());
        }
    }
}

