/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.security.smime;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.Providers;
import org.jboss.resteasy.security.BouncyIntegration;
import org.jboss.resteasy.security.smime.EnvelopedInput;
import org.jboss.resteasy.security.smime.EnvelopedInputImpl;
import org.jboss.resteasy.spi.ReaderException;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.Types;

@Provider
@Consumes(value={"*/*"})
public class EnvelopedReader
implements MessageBodyReader<EnvelopedInput> {
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return EnvelopedInput.class.isAssignableFrom(type);
    }

    public EnvelopedInput readFrom(Class<EnvelopedInput> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> headers, InputStream entityStream) throws IOException, WebApplicationException {
        Class baseType = null;
        Type baseGenericType = null;
        if (genericType != null && genericType instanceof ParameterizedType) {
            ParameterizedType param = (ParameterizedType)genericType;
            baseGenericType = param.getActualTypeArguments()[0];
            baseType = Types.getRawType((Type)baseGenericType);
        }
        EnvelopedInputImpl input = new EnvelopedInputImpl();
        input.setType(baseType);
        input.setGenericType(baseGenericType);
        StringBuilder headerString = new StringBuilder();
        if (headers.containsKey((Object)"Content-Disposition")) {
            headerString.append("Content-Disposition: ").append((String)headers.getFirst((Object)"Content-Disposition")).append("\r\n");
        }
        if (headers.containsKey((Object)"Content-Type")) {
            headerString.append("Content-Type: ").append((String)headers.getFirst((Object)"Content-Type")).append("\r\n");
        }
        if (headers.containsKey((Object)"Content-Transfer-Encoding")) {
            headerString.append("Content-Transfer-Encoding: ").append((String)headers.getFirst((Object)"Content-Transfer-Encoding")).append("\r\n");
        }
        headerString.append("\r\n");
        ByteArrayInputStream is = new ByteArrayInputStream(headerString.toString().getBytes(StandardCharsets.UTF_8));
        MimeBodyPart body = null;
        try {
            body = new MimeBodyPart((InputStream)new SequenceInputStream(is, entityStream));
        }
        catch (MessagingException e) {
            throw new ReaderException((Throwable)e);
        }
        Providers providers = (Providers)ResteasyProviderFactory.getContextData(Providers.class);
        input.setProviders(providers);
        input.setAnnotations(annotations);
        input.setBody(body);
        return input;
    }

    static {
        BouncyIntegration.init();
    }
}

