/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config.source.file;

import io.smallrye.config.common.MapBackedConfigSource;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;

public class FileSystemConfigSource
extends MapBackedConfigSource {
    private static final long serialVersionUID = 654034634846856045L;
    private static final Logger LOG = Logger.getLogger((String)"io.smallrye.config");

    FileSystemConfigSource(File dir) {
        this(dir, 100);
    }

    public FileSystemConfigSource(File dir, int ordinal) {
        super("DirConfigSource[dir=" + dir.getAbsolutePath() + "]", FileSystemConfigSource.scan(dir), ordinal);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map<String, String> scan(File directory) {
        if (directory == null) return Collections.emptyMap();
        if (!directory.isDirectory()) return Collections.emptyMap();
        try (Stream<Path> stream = Files.walk(directory.toPath(), 1, new FileVisitOption[0]);){
            Map<String, String> map = stream.filter(p -> p.toFile().isFile()).collect(Collectors.toMap(it -> it.getFileName().toString(), FileSystemConfigSource::readContent));
            return map;
        }
        catch (Exception e) {
            LOG.warnf("Unable to read content from file %s. Exception: %s", (Object)directory.getAbsolutePath(), (Object)e.getLocalizedMessage());
        }
        return Collections.emptyMap();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readContent(Path file) {
        try (Stream<String> stream = Files.lines(file);){
            String string = stream.collect(Collectors.joining());
            return string;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

