/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.util;

import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.security.auth.callback.CallbackHandler;
import org.wildfly.common.Assert;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;
import org.wildfly.security.http.HttpServerAuthenticationMechanismFactory;
import org.wildfly.security.http.util.ElytronMessages;
import org.wildfly.security.provider.util.ProviderUtil;

public final class SecurityProviderServerMechanismFactory
implements HttpServerAuthenticationMechanismFactory {
    private static final String SERVICE_TYPE = HttpServerAuthenticationMechanismFactory.class.getSimpleName();
    private final Supplier<Provider[]> providerSupplier;
    private volatile Provider[] providers;
    private volatile Map<String, List<Provider.Service>> services;

    public SecurityProviderServerMechanismFactory() {
        this(ProviderUtil.INSTALLED_PROVIDERS);
    }

    public SecurityProviderServerMechanismFactory(Supplier<Provider[]> providerSupplier) {
        this.providerSupplier = Assert.checkNotNullParam("providerSupplier", providerSupplier);
    }

    public SecurityProviderServerMechanismFactory(Provider[] providers) {
        this.providerSupplier = null;
        this.providers = Assert.checkNotNullParam("providers", providers);
    }

    public SecurityProviderServerMechanismFactory(Provider provider) {
        this(new Provider[]{Assert.checkNotNullParam("provider", provider)});
    }

    @Override
    public String[] getMechanismNames(Map<String, ?> properties) {
        Set<String> names;
        Map<String, List<Provider.Service>> services = this.getServices();
        if (properties.isEmpty()) {
            names = services.keySet();
        } else {
            names = new LinkedHashSet<String>();
            for (List<Provider.Service> currentServices : services.values()) {
                for (Provider.Service currentService : currentServices) {
                    try {
                        String[] serviceMechNames = ((HttpServerAuthenticationMechanismFactory)currentService.newInstance(null)).getMechanismNames(properties);
                        Collections.addAll(names, serviceMechNames);
                    }
                    catch (NoSuchAlgorithmException e) {
                        ElytronMessages.log.debug("Unable to create instance", e);
                    }
                }
            }
        }
        if (names.size() == 0 && ElytronMessages.log.isTraceEnabled()) {
            ElytronMessages.log.tracef("No %s provided by provider loader in %s: %s", (Object)SERVICE_TYPE, (Object)this.getClass().getSimpleName(), (Object)Arrays.toString(this.providerSupplier.get()));
        }
        return names.toArray(new String[names.size()]);
    }

    @Override
    public HttpServerAuthenticationMechanism createAuthenticationMechanism(String mechanismName, Map<String, ?> properties, CallbackHandler callbackHandler) throws HttpAuthenticationException {
        List<Provider.Service> services = this.getServices().get(mechanismName);
        if (services != null) {
            for (Provider.Service currentService : services) {
                try {
                    HttpServerAuthenticationMechanismFactory factory = (HttpServerAuthenticationMechanismFactory)currentService.newInstance(null);
                    HttpServerAuthenticationMechanism mechanism = factory.createAuthenticationMechanism(mechanismName, properties, callbackHandler);
                    if (mechanism == null) continue;
                    return mechanism;
                }
                catch (NoSuchAlgorithmException e) {
                    ElytronMessages.log.debug("Unable to create instance", e);
                }
            }
        }
        if (ElytronMessages.log.isTraceEnabled()) {
            ElytronMessages.log.tracef("No %s provided by provider loader in %s", (Object)SERVICE_TYPE, (Object)this.getClass().getSimpleName());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, List<Provider.Service>> getServices() {
        if (this.services == null) {
            SecurityProviderServerMechanismFactory securityProviderServerMechanismFactory = this;
            synchronized (securityProviderServerMechanismFactory) {
                if (this.services == null) {
                    if (this.providers == null) {
                        this.providers = this.providerSupplier.get();
                    }
                    HashMap<String, List<Provider.Service>> services = new HashMap<String, List<Provider.Service>>();
                    for (Provider provider : this.providers) {
                        Set<Provider.Service> providerServices = provider.getServices();
                        for (Provider.Service currentService : providerServices) {
                            if (!SERVICE_TYPE.equals(currentService.getType())) continue;
                            String algorithm = currentService.getAlgorithm();
                            if (services.containsKey(algorithm)) {
                                ((List)services.get(algorithm)).add(currentService);
                                continue;
                            }
                            ArrayList<Provider.Service> serviceList = new ArrayList<Provider.Service>();
                            serviceList.add(currentService);
                            services.put(algorithm, serviceList);
                        }
                    }
                    this.services = services;
                }
            }
        }
        return this.services;
    }
}

