/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.reactive.publisher.impl.commands.batch;

import java.util.function.ObjIntConsumer;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.Util;

public class PublisherResponse {
    final Object[] results;
    final IntSet completedSegments;
    final IntSet lostSegments;
    final int size;
    final boolean complete;
    final int segmentOffset;

    public PublisherResponse(Object[] results, IntSet completedSegments, IntSet lostSegments, int size, boolean complete, int segmentOffset) {
        this.results = results;
        this.completedSegments = completedSegments;
        this.lostSegments = lostSegments;
        this.size = size;
        this.complete = complete;
        this.segmentOffset = segmentOffset;
    }

    public static PublisherResponse emptyResponse(IntSet completedSegments, IntSet lostSegments) {
        return new PublisherResponse(Util.EMPTY_OBJECT_ARRAY, completedSegments, lostSegments, 0, true, 0);
    }

    public Object[] getResults() {
        return this.results;
    }

    public IntSet getCompletedSegments() {
        return this.completedSegments;
    }

    public IntSet getLostSegments() {
        return this.lostSegments;
    }

    public int getSize() {
        return this.size;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void forEachSegmentValue(ObjIntConsumer consumer, int segment) {
        for (int i = this.segmentOffset; i < this.results.length; ++i) {
            consumer.accept(this.results[i], segment);
        }
    }

    public String toString() {
        return "PublisherResponse{size=" + this.size + ", completedSegments=" + this.completedSegments + ", lostSegments=" + this.lostSegments + ", complete=" + this.complete + ", segmentOffset=" + this.segmentOffset + '}';
    }
}

