/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.util.Util;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.transaction.impl.AbstractCacheTransaction;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.InvalidTransactionException;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class RemoteTransaction
extends AbstractCacheTransaction
implements Cloneable {
    private static final Log log = LogFactory.getLog(RemoteTransaction.class);
    private static final boolean trace = log.isTraceEnabled();
    private static final CompletableFuture<Void> INITIAL_FUTURE = CompletableFutures.completedNull();
    private volatile int lookedUpEntriesTopology = Integer.MAX_VALUE;
    private final AtomicReference<CompletableFuture<Void>> synchronization = new AtomicReference<CompletableFuture<Void>>(INITIAL_FUTURE);

    public RemoteTransaction(WriteCommand[] modifications, GlobalTransaction tx, int topologyId, long txCreationTime) {
        super(tx, topologyId, txCreationTime);
        this.modifications = modifications == null || modifications.length == 0 ? Collections.emptyList() : Arrays.asList(modifications);
        this.lookedUpEntries = new HashMap(this.modifications.size());
    }

    public RemoteTransaction(GlobalTransaction tx, int topologyId, long txCreationTime) {
        super(tx, topologyId, txCreationTime);
        this.modifications = new LinkedList();
        this.lookedUpEntries = new HashMap(4);
    }

    @Override
    public void setStateTransferFlag(Flag stateTransferFlag) {
        if (this.getStateTransferFlag() == null && stateTransferFlag == Flag.PUT_FOR_X_SITE_STATE_TRANSFER) {
            this.internalSetStateTransferFlag(stateTransferFlag);
        }
    }

    @Override
    public void putLookedUpEntry(Object key, CacheEntry e) {
        this.checkIfRolledBack();
        if (trace) {
            log.tracef("Adding key %s to tx %s", Util.toStr((Object)key), this.getGlobalTransaction());
        }
        this.lookedUpEntries.put(key, e);
    }

    @Override
    public void putLookedUpEntries(Map<Object, CacheEntry> entries) {
        this.checkIfRolledBack();
        if (trace) {
            log.tracef("Adding keys %s to tx %s", entries.keySet(), this.getGlobalTransaction());
        }
        this.lookedUpEntries.putAll(entries);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RemoteTransaction)) {
            return false;
        }
        RemoteTransaction that = (RemoteTransaction)o;
        return this.tx.equals(that.tx);
    }

    public int hashCode() {
        return this.tx.hashCode();
    }

    public Object clone() {
        try {
            RemoteTransaction dolly = (RemoteTransaction)super.clone();
            dolly.modifications = new ArrayList(this.modifications);
            dolly.lookedUpEntries = new HashMap(this.lookedUpEntries);
            return dolly;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Impossible!!", e);
        }
    }

    public String toString() {
        return "RemoteTransaction{modifications=" + this.modifications + ", lookedUpEntries=" + this.lookedUpEntries + ", lockedKeys=" + Util.toStr(this.getLockedKeys()) + ", backupKeyLocks=" + Util.toStr(this.getBackupLockedKeys()) + ", lookedUpEntriesTopology=" + this.lookedUpEntriesTopology + ", isMarkedForRollback=" + this.isMarkedForRollback() + ", tx=" + this.tx + '}';
    }

    public void setLookedUpEntriesTopology(int lookedUpEntriesTopology) {
        this.lookedUpEntriesTopology = lookedUpEntriesTopology;
    }

    public int lookedUpEntriesTopology() {
        return this.lookedUpEntriesTopology;
    }

    private void checkIfRolledBack() {
        if (this.isMarkedForRollback()) {
            throw new InvalidTransactionException("This remote transaction " + this.getGlobalTransaction() + " is already rolled back");
        }
    }

    public final CompletableFuture<Void> enterSynchronizationAsync(CompletableFuture<Void> releaseFuture) {
        CompletableFuture<Void> currentFuture;
        while (!this.synchronization.compareAndSet(currentFuture = this.synchronization.get(), releaseFuture)) {
        }
        return currentFuture;
    }
}

