/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.function.Function;
import org.wildfly.clustering.ee.infinispan.GroupedKey;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.marshalling.spi.Serializer;
import org.wildfly.clustering.web.cache.SessionIdentifierSerializer;

public class SessionKeyExternalizer<K extends GroupedKey<String>>
implements Externalizer<K> {
    private static final Serializer<String> IDENTIFIER_SERIALIZER = SessionIdentifierSerializer.INSTANCE;
    private final Class<K> targetClass;
    private final Function<String, K> resolver;

    protected SessionKeyExternalizer(Class<K> targetClass, Function<String, K> resolver) {
        this.targetClass = targetClass;
        this.resolver = resolver;
    }

    public void writeObject(ObjectOutput output, K key) throws IOException {
        IDENTIFIER_SERIALIZER.write((DataOutput)output, key.getId());
    }

    public K readObject(ObjectInput input) throws IOException {
        return (K)((GroupedKey)this.resolver.apply((String)IDENTIFIER_SERIALIZER.read((DataInput)input)));
    }

    public Class<K> getTargetClass() {
        return this.targetClass;
    }
}

