/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.security.auth.message.config.AuthConfigFactory;
import javax.security.auth.message.module.ServerAuthModule;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.ObjectListAttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PropertiesAttributeDefinition;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.elytron.BaseAddHandler;
import org.wildfly.extension.elytron.ClassLoadingAttributeDefinitions;
import org.wildfly.extension.elytron.TrivialResourceDefinition;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;
import org.wildfly.security.auth.jaspi.Flag;
import org.wildfly.security.auth.jaspi.JaspiConfigurationBuilder;

class JaspiDefinition {
    private static final Map<String, String> REGISTRATION_MAP = new ConcurrentHashMap<String, String>();
    static final SimpleAttributeDefinition LAYER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("layer", ModelType.STRING, true).setDefaultValue(new ModelNode("*"))).setAllowExpression(true)).setMinSize(1)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition APPLICATION_CONTEXT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("application-context", ModelType.STRING, true).setDefaultValue(new ModelNode("*"))).setAllowExpression(true)).setMinSize(1)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition DESCRIPTION = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("description", ModelType.STRING, true).setAllowExpression(true)).setMinSize(1)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition FLAG = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("flag", ModelType.STRING, true).setAllowExpression(true)).setDefaultValue(new ModelNode("required"))).setAllowedValues(new String[]{"required", "requisite", "sufficient", "optional"})).setValidator((ParameterValidator)EnumValidator.create(Flag.class, (Enum[])Flag.values()))).setMinSize(1)).setRestartAllServices()).build();
    static final PropertiesAttributeDefinition OPTIONS = ((PropertiesAttributeDefinition.Builder)((PropertiesAttributeDefinition.Builder)new PropertiesAttributeDefinition.Builder("options", true).setAllowExpression(true)).setRestartAllServices()).build();
    static final ObjectTypeAttributeDefinition SERVER_AUTH_MODULE = ((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder("server-auth-module", new AttributeDefinition[]{ClassLoadingAttributeDefinitions.CLASS_NAME, ClassLoadingAttributeDefinitions.MODULE, FLAG, OPTIONS}).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final ObjectListAttributeDefinition SERVER_AUTH_MODULES = ((ObjectListAttributeDefinition.Builder)((ObjectListAttributeDefinition.Builder)new ObjectListAttributeDefinition.Builder("server-auth-modules", SERVER_AUTH_MODULE).setRequired(false)).setRestartAllServices()).build();
    static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{LAYER, APPLICATION_CONTEXT, DESCRIPTION, SERVER_AUTH_MODULES};
    static final JaspiAddHandler ADD = new JaspiAddHandler();
    static final AbstractRemoveStepHandler REMOVE = new AbstractRemoveStepHandler(){

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            if (context.isResourceServiceRestartAllowed()) {
                JaspiDefinition.removeRegistration(context);
            } else {
                context.reloadRequired();
            }
        }

        protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            if (context.isResourceServiceRestartAllowed()) {
                ADD.performRuntime(context, operation, model);
            } else {
                context.revertReloadRequired();
            }
        }

        protected boolean requiresRuntime(OperationContext context) {
            return ADD.requiresRuntime(context);
        }
    };

    JaspiDefinition() {
    }

    static ResourceDefinition getJaspiServletConfigurationDefinition() {
        return TrivialResourceDefinition.builder().setPathKey("jaspi-configuration").setAttributes(ATTRIBUTES).setAddHandler(ADD).setRemoveHandler(REMOVE).build();
    }

    private static void removeRegistration(OperationContext context) {
        String registrationId = REGISTRATION_MAP.remove(context.getCurrentAddressValue());
        if (registrationId != null) {
            AuthConfigFactory authConfigFactory = AuthConfigFactory.getFactory();
            authConfigFactory.removeRegistration(registrationId);
        }
    }

    private static Supplier<ServerAuthModule> createServerAuthModuleSupplier(final String className, final String module) {
        return new Supplier<ServerAuthModule>(){

            @Override
            public ServerAuthModule get() {
                try {
                    ClassLoader classLoader = ClassLoadingAttributeDefinitions.resolveClassLoader(module);
                    Object sam = classLoader.loadClass(className).newInstance();
                    return (ServerAuthModule)ServerAuthModule.class.cast(sam);
                }
                catch (Exception e) {
                    throw ElytronSubsystemMessages.ROOT_LOGGER.failedToCreateServerAuthModule(className, module, e);
                }
            }
        };
    }

    static class JaspiAddHandler
    extends BaseAddHandler {
        JaspiAddHandler() {
            super(ATTRIBUTES);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            String layer = LAYER.resolveModelAttribute(context, model).asString();
            String applicationContext = APPLICATION_CONTEXT.resolveModelAttribute(context, model).asString();
            String description = DESCRIPTION.resolveModelAttribute(context, model).asStringOrNull();
            String addressValue = context.getCurrentAddressValue();
            JaspiConfigurationBuilder builder = JaspiConfigurationBuilder.builder((String)("*".equals(layer) ? null : layer), (String)("*".equals(applicationContext) ? null : applicationContext)).setDescription(description);
            List serverAuthModules = SERVER_AUTH_MODULES.resolveModelAttribute(context, model).asList();
            for (ModelNode serverAuthModule : serverAuthModules) {
                String className = ClassLoadingAttributeDefinitions.CLASS_NAME.resolveModelAttribute(context, serverAuthModule).asString();
                String module = ClassLoadingAttributeDefinitions.MODULE.resolveModelAttribute(context, serverAuthModule).asStringOrNull();
                Flag flag = Flag.valueOf((String)FLAG.resolveModelAttribute(context, serverAuthModule).asString());
                Map options = OPTIONS.unwrap((ExpressionResolver)context, serverAuthModule);
                builder.addAuthModuleFactory(JaspiDefinition.createServerAuthModuleSupplier(className, module), flag, options);
            }
            String registrationId = builder.register();
            REGISTRATION_MAP.put(addressValue, registrationId);
        }

        protected void rollbackRuntime(OperationContext context, ModelNode operation, Resource resource) {
            JaspiDefinition.removeRegistration(context);
        }
    }
}

