/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.tx;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.tx.TransactionManagerImpl;
import org.infinispan.commons.tx.Util;
import org.infinispan.commons.tx.XidImpl;

public class TransactionImpl
implements Transaction {
    private static final Log log = LogFactory.getLog(TransactionImpl.class);
    private static final String FORCE_ROLLBACK_MESSAGE = "Force rollback invoked. (debug mode)";
    private static final boolean trace = log.isTraceEnabled();
    private final List<Synchronization> syncs;
    private final List<Map.Entry<XAResource, Integer>> resources;
    private final Object xidLock = new Object();
    private volatile XidImpl xid;
    private volatile int status = 0;
    private RollbackException firstRollbackException;

    protected TransactionImpl() {
        this.syncs = new ArrayList<Synchronization>(2);
        this.resources = new ArrayList<Map.Entry<XAResource, Integer>>(2);
    }

    private static boolean isRollbackCode(XAException ex) {
        return ex.errorCode >= 100 && ex.errorCode <= 107;
    }

    private static RollbackException newRollbackException(String message, Throwable cause) {
        RollbackException exception = new RollbackException(message);
        exception.initCause(cause);
        return exception;
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException {
        if (trace) {
            log.tracef("Transaction.commit() invoked in transaction with Xid=%s", this.xid);
        }
        if (this.isDone()) {
            throw new IllegalStateException("Transaction is done. Cannot commit transaction.");
        }
        this.runPrepare();
        this.runCommit(false);
    }

    public void rollback() throws IllegalStateException, SystemException {
        block5: {
            if (trace) {
                log.tracef("Transaction.rollback() invoked in transaction with Xid=%s", this.xid);
            }
            if (this.isDone()) {
                throw new IllegalStateException("Transaction is done. Cannot rollback transaction");
            }
            try {
                this.status = 1;
                this.endResources();
                this.runCommit(false);
            }
            catch (HeuristicMixedException | HeuristicRollbackException e) {
                log.errorRollingBack(e);
                SystemException systemException = new SystemException("Unable to rollback transaction");
                systemException.initCause(e);
                throw systemException;
            }
            catch (RollbackException e) {
                if (!trace) break block5;
                log.trace("RollbackException thrown while rolling back", e);
            }
        }
    }

    public void setRollbackOnly() throws IllegalStateException {
        if (trace) {
            log.tracef("Transaction.setRollbackOnly() invoked in transaction with Xid=%s", this.xid);
        }
        if (this.isDone()) {
            throw new IllegalStateException("Transaction is done. Cannot change status");
        }
        this.markRollbackOnly(new RollbackException("Transaction marked as rollback only."));
    }

    public int getStatus() {
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enlistResource(XAResource resource) throws RollbackException, IllegalStateException, SystemException {
        if (trace) {
            log.tracef("Transaction.enlistResource(%s) invoked in transaction with Xid=%s", resource, this.xid);
        }
        this.checkStatusBeforeRegister("resource");
        for (Map.Entry<XAResource, Integer> otherResourceEntry : this.resources) {
            try {
                if (!otherResourceEntry.getKey().isSameRM(resource)) continue;
                log.debug("Ignoring resource. It is already there.");
                return true;
            }
            catch (XAException xAException) {
            }
        }
        Object object = this.xidLock;
        synchronized (object) {
            this.resources.add(new AbstractMap.SimpleEntry<XAResource, Object>(resource, null));
        }
        try {
            if (trace) {
                log.tracef("XaResource.start() invoked in transaction with Xid=%s", this.xid);
            }
            resource.start(this.xid, 0);
        }
        catch (XAException e) {
            if (TransactionImpl.isRollbackCode(e)) {
                RollbackException exception = TransactionImpl.newRollbackException(String.format("Resource %s rolled back the transaction while XaResource.start()", resource), e);
                this.markRollbackOnly(exception);
                log.errorEnlistingResource(e);
                throw exception;
            }
            log.errorEnlistingResource(e);
            throw new SystemException(e.getMessage());
        }
        return true;
    }

    public boolean delistResource(XAResource xaRes, int flag) throws IllegalStateException, SystemException {
        throw new SystemException("not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSynchronization(Synchronization sync) throws RollbackException, IllegalStateException {
        if (trace) {
            log.tracef("Transaction.registerSynchronization(%s) invoked in transaction with Xid=%s", sync, this.xid);
        }
        this.checkStatusBeforeRegister("synchronization");
        if (trace) {
            log.tracef("Registering synchronization handler %s", sync);
        }
        Object object = this.xidLock;
        synchronized (object) {
            this.syncs.add(sync);
        }
    }

    public Collection<XAResource> getEnlistedResources() {
        return Collections.unmodifiableList(this.resources.stream().map(Map.Entry::getKey).collect(Collectors.toList()));
    }

    public boolean runPrepare() {
        if (trace) {
            log.tracef("runPrepare() invoked in transaction with Xid=%s", this.xid);
        }
        this.notifyBeforeCompletion();
        this.endResources();
        if (this.status == 1) {
            return false;
        }
        this.status = 7;
        for (Map.Entry<XAResource, Integer> resourceStatusEntry : this.resources) {
            XAResource res = resourceStatusEntry.getKey();
            try {
                if (trace) {
                    log.tracef("XaResource.prepare() for %s", res);
                }
                int lastStatus = res.prepare(this.xid);
                resourceStatusEntry.setValue(lastStatus);
            }
            catch (XAException e) {
                if (trace) {
                    log.trace("The resource wants to rollback!", e);
                }
                this.markRollbackOnly(TransactionImpl.newRollbackException(String.format("XaResource.prepare() for %s wants to rollback.", res), e));
                return false;
            }
            catch (Throwable th) {
                this.markRollbackOnly(TransactionImpl.newRollbackException(String.format("Unexpected error in XaResource.prepare() for %s. Rollback transaction.", res), th));
                log.unexpectedErrorFromResourceManager(th);
                return false;
            }
        }
        this.status = 2;
        return true;
    }

    public synchronized void runCommit(boolean forceRollback) throws HeuristicMixedException, HeuristicRollbackException, RollbackException {
        if (trace) {
            log.tracef("runCommit(forceRollback=%b) invoked in transaction with Xid=%s", forceRollback, this.xid);
        }
        if (forceRollback) {
            this.markRollbackOnly(new RollbackException(FORCE_ROLLBACK_MESSAGE));
        }
        int notifyAfterStatus = 0;
        try {
            if (this.status == 1) {
                notifyAfterStatus = 4;
                this.rollbackResources();
            } else {
                notifyAfterStatus = 3;
                this.commitResources();
            }
        }
        finally {
            this.notifyAfterCompletion(notifyAfterStatus);
            TransactionManagerImpl.dissociateTransaction();
        }
        this.throwRollbackExceptionIfAny(forceRollback);
    }

    public String toString() {
        return "TransactionImpl{xid=" + this.xid + ", status=" + Util.transactionStatusToString(this.status) + '}';
    }

    public XidImpl getXid() {
        return this.xid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setXid(XidImpl xid) {
        Object object = this.xidLock;
        synchronized (object) {
            if (this.syncs.isEmpty() && this.resources.isEmpty()) {
                this.xid = xid;
            }
        }
    }

    public Collection<Synchronization> getEnlistedSynchronization() {
        return Collections.unmodifiableList(this.syncs);
    }

    public final int hashCode() {
        return this.xid.hashCode();
    }

    public final boolean equals(Object obj) {
        return this == obj;
    }

    private void throwRollbackExceptionIfAny(boolean forceRollback) throws RollbackException {
        if (this.firstRollbackException != null) {
            if (forceRollback && FORCE_ROLLBACK_MESSAGE.equals(this.firstRollbackException.getMessage())) {
                return;
            }
            throw this.firstRollbackException;
        }
    }

    private void markRollbackOnly(RollbackException e) {
        if (this.status == 1) {
            return;
        }
        this.status = 1;
        if (this.firstRollbackException == null) {
            this.firstRollbackException = e;
        }
    }

    private void finishResource(boolean commit) throws HeuristicRollbackException, HeuristicMixedException {
        Throwable exception;
        boolean ok = false;
        boolean heuristic = false;
        boolean error = false;
        XAException cause = null;
        block6: for (Map.Entry<XAResource, Integer> resourceStatusEntry : this.resources) {
            XAResource res = resourceStatusEntry.getKey();
            try {
                if (commit) {
                    if (trace) {
                        log.tracef("XaResource.commit() for %s", res);
                    }
                    if (resourceStatusEntry.getValue() == 3) {
                        log.tracef("Skipping XaResource.commit() since prepare status was XA_RDONLY for %s", res);
                        continue;
                    }
                    res.commit(this.xid, false);
                } else {
                    if (trace) {
                        log.tracef("XaResource.rollback() for %s", res);
                    }
                    res.rollback(this.xid);
                }
                ok = true;
            }
            catch (XAException e) {
                cause = e;
                log.errorCommittingTx(e);
                switch (e.errorCode) {
                    case 5: 
                    case 6: 
                    case 7: {
                        heuristic = true;
                        continue block6;
                    }
                    case -4: {
                        if (commit) {
                            heuristic = true;
                            continue block6;
                        }
                        ok = true;
                        continue block6;
                    }
                }
                error = true;
            }
        }
        this.resources.clear();
        if (heuristic && !ok && !error) {
            exception = new HeuristicRollbackException();
            exception.initCause((Throwable)cause);
            throw exception;
        }
        if (error || heuristic) {
            this.status = 5;
            exception = new HeuristicMixedException();
            exception.initCause((Throwable)cause);
            throw exception;
        }
    }

    private void commitResources() throws HeuristicRollbackException, HeuristicMixedException {
        this.status = 8;
        try {
            this.finishResource(true);
        }
        catch (HeuristicMixedException | HeuristicRollbackException e) {
            this.status = 5;
            throw e;
        }
        this.status = 3;
    }

    private void rollbackResources() throws HeuristicRollbackException, HeuristicMixedException {
        this.status = 9;
        try {
            this.finishResource(false);
        }
        catch (HeuristicMixedException | HeuristicRollbackException e) {
            this.status = 5;
            throw e;
        }
        this.status = 4;
    }

    private void notifyBeforeCompletion() {
        for (Synchronization s : this.getEnlistedSynchronization()) {
            if (trace) {
                log.tracef("Synchronization.beforeCompletion() for %s", s);
            }
            try {
                s.beforeCompletion();
            }
            catch (Throwable t) {
                this.markRollbackOnly(TransactionImpl.newRollbackException(String.format("Synchronization.beforeCompletion() for %s wants to rollback.", s), t));
                log.beforeCompletionFailed(s.toString(), t);
            }
        }
    }

    private void notifyAfterCompletion(int status) {
        for (Synchronization s : this.getEnlistedSynchronization()) {
            if (trace) {
                log.tracef("Synchronization.afterCompletion() for %s", s);
            }
            try {
                s.afterCompletion(status);
            }
            catch (Throwable t) {
                log.afterCompletionFailed(s.toString(), t);
            }
        }
        this.syncs.clear();
    }

    private void endResources() {
        for (XAResource resource : this.getEnlistedResources()) {
            if (trace) {
                log.tracef("XAResource.end() for %s", resource);
            }
            try {
                resource.end(this.xid, 0x4000000);
            }
            catch (XAException e) {
                this.markRollbackOnly(TransactionImpl.newRollbackException(String.format("XaResource.end() for %s wants to rollback.", resource), e));
                log.xaResourceEndFailed(resource.toString(), e);
            }
            catch (Throwable t) {
                this.markRollbackOnly(TransactionImpl.newRollbackException(String.format("Unexpected error in XaResource.end() for %s. Marked as rollback", resource), t));
                log.xaResourceEndFailed(resource.toString(), t);
            }
        }
    }

    private void checkStatusBeforeRegister(String component) throws RollbackException, IllegalStateException {
        if (this.status == 1) {
            throw new RollbackException("Transaction has been marked as rollback only");
        }
        if (this.isDone()) {
            throw new IllegalStateException(String.format("Transaction is done. Cannot register any more %s", component));
        }
    }

    private boolean isDone() {
        switch (this.status) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                return true;
            }
        }
        return false;
    }
}

