/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.broker;

import io.netty.buffer.ByteBuf;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.persistence.CoreMessageObjectPools;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPMessage;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPStandardMessage;
import org.apache.activemq.artemis.spi.core.protocol.MessagePersister;

public class AMQPMessagePersister
extends MessagePersister {
    public static final byte ID = 2;
    public static AMQPMessagePersister theInstance;

    public static AMQPMessagePersister getInstance() {
        if (theInstance == null) {
            theInstance = new AMQPMessagePersister();
        }
        return theInstance;
    }

    protected AMQPMessagePersister() {
    }

    public byte getID() {
        return 2;
    }

    public int getEncodeSize(Message record) {
        return 1 + record.getPersistSize() + SimpleString.sizeofNullableString((SimpleString)record.getAddressSimpleString()) + 8 + 8;
    }

    public void encode(ActiveMQBuffer buffer, Message record) {
        super.encode(buffer, record);
        AMQPMessage msgEncode = (AMQPMessage)record;
        buffer.writeLong(record.getMessageID());
        buffer.writeLong(msgEncode.getMessageFormat());
        buffer.writeNullableSimpleString(record.getAddressSimpleString());
        record.persist(buffer);
    }

    public Message decode(ActiveMQBuffer buffer, Message record, CoreMessageObjectPools pool) {
        long id = buffer.readLong();
        long format = buffer.readLong();
        SimpleString address = pool == null ? buffer.readNullableSimpleString() : SimpleString.readNullableSimpleString((ByteBuf)buffer.byteBuf(), (SimpleString.ByteBufSimpleStringPool)pool.getAddressDecoderPool());
        record = new AMQPStandardMessage(format);
        record.reloadPersistence(buffer, pool);
        record.setMessageID(id);
        if (address != null) {
            record.setAddress(address);
        }
        return record;
    }
}

