/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ee.hotrod;

import java.time.Duration;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.infinispan.client.hotrod.RemoteCache;
import org.wildfly.clustering.ee.Mutator;

public class RemoteCacheEntryMutator<K, V>
implements Mutator {
    private final RemoteCache<K, V> cache;
    private final Function<V, Duration> maxIdle;
    private final K id;
    private final V value;

    public RemoteCacheEntryMutator(RemoteCache<K, V> cache, Map.Entry<K, V> entry) {
        this(cache, null, entry);
    }

    public RemoteCacheEntryMutator(RemoteCache<K, V> cache, K id, V value) {
        this(cache, null, id, value);
    }

    public RemoteCacheEntryMutator(RemoteCache<K, V> cache, Function<V, Duration> maxIdle, Map.Entry<K, V> entry) {
        this(cache, maxIdle, entry.getKey(), entry.getValue());
    }

    public RemoteCacheEntryMutator(RemoteCache<K, V> cache, Function<V, Duration> maxIdle, K id, V value) {
        this.cache = cache;
        this.maxIdle = maxIdle;
        this.id = id;
        this.value = value;
    }

    public void mutate() {
        long maxIdle = this.maxIdle != null ? this.maxIdle.apply(this.value).getSeconds() : 0L;
        this.cache.put(this.id, this.value, 0L, TimeUnit.SECONDS, maxIdle, TimeUnit.SECONDS);
    }
}

