/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.io.IOException;
import java.util.OptionalInt;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.RawProtoStreamReader;
import org.infinispan.protostream.RawProtoStreamWriter;
import org.wildfly.clustering.marshalling.protostream.AnyField;
import org.wildfly.clustering.marshalling.protostream.ClassField;
import org.wildfly.clustering.marshalling.protostream.ClassResolver;
import org.wildfly.clustering.marshalling.protostream.Field;

public class ClassResolverField
implements Field<Class<?>> {
    private final ClassResolver resolver;
    private final int index;

    public ClassResolverField(ClassResolver resolver, int index) {
        this.resolver = resolver;
        this.index = index;
    }

    public Class<?> readFrom(ImmutableSerializationContext context, RawProtoStreamReader reader) throws IOException {
        String className = (String)AnyField.STRING.cast(String.class).readFrom(context, reader);
        return this.resolver.resolve(context, reader, className);
    }

    public void writeTo(ImmutableSerializationContext context, RawProtoStreamWriter writer, Class<?> targetClass) throws IOException {
        AnyField.STRING.writeTo(context, writer, targetClass.getName());
        this.resolver.annotate(context, writer, targetClass);
    }

    @Override
    public OptionalInt size(ImmutableSerializationContext context, Class<?> targetClass) {
        OptionalInt size = this.resolver.size(context, targetClass);
        return size.isPresent() ? OptionalInt.of(size.getAsInt() + AnyField.STRING.size(context, targetClass.getName()).getAsInt()) : OptionalInt.empty();
    }

    public Class<? extends Class<?>> getJavaClass() {
        return ClassField.ANY.getJavaClass();
    }

    @Override
    public int getIndex() {
        return this.index;
    }
}

