/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.singleton.deployment;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLMapper;
import org.jboss.vfs.VirtualFile;
import org.wildfly.extension.clustering.singleton.deployment.MutableSingletonDeploymentConfiguration;
import org.wildfly.extension.clustering.singleton.deployment.SingletonDeploymentConfiguration;
import org.wildfly.extension.clustering.singleton.deployment.SingletonDeploymentDependencyProcessor;
import org.wildfly.extension.clustering.singleton.deployment.SingletonDeploymentSchema;
import org.wildfly.extension.clustering.singleton.deployment.SingletonDeploymentXMLReader;

public class SingletonDeploymentParsingProcessor
implements DeploymentUnitProcessor {
    private static final String SINGLETON_DEPLOYMENT_DESCRIPTOR = "META-INF/singleton-deployment.xml";
    private static final XMLInputFactory XML_INPUT_FACTORY = XMLInputFactory.newInstance();
    private final XMLMapper mapper = XMLMapper.Factory.create();

    public SingletonDeploymentParsingProcessor() {
        for (SingletonDeploymentSchema schema : SingletonDeploymentSchema.values()) {
            this.mapper.registerRootElement(schema.getRoot(), (XMLElementReader)new SingletonDeploymentXMLReader(schema));
        }
    }

    public void deploy(DeploymentPhaseContext context) throws DeploymentUnitProcessingException {
        VirtualFile file;
        DeploymentUnit unit = context.getDeploymentUnit();
        if (!unit.hasAttachment(SingletonDeploymentDependencyProcessor.CONFIGURATION_KEY) && (file = ((ResourceRoot)unit.getAttachment(Attachments.DEPLOYMENT_ROOT)).getRoot().getChild(SINGLETON_DEPLOYMENT_DESCRIPTOR)).exists()) {
            try {
                unit.putAttachment(SingletonDeploymentDependencyProcessor.CONFIGURATION_KEY, (Object)this.parse(unit, file.getPhysicalFile()));
            }
            catch (IOException e) {
                throw new DeploymentUnitProcessingException((Throwable)e);
            }
        }
    }

    public void undeploy(DeploymentUnit unit) {
        unit.removeAttachment(SingletonDeploymentDependencyProcessor.CONFIGURATION_KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private SingletonDeploymentConfiguration parse(DeploymentUnit unit, File file) throws DeploymentUnitProcessingException {
        try {
            Throwable throwable = null;
            try (BufferedReader reader = Files.newBufferedReader(file.toPath(), StandardCharsets.UTF_8);){
                MutableSingletonDeploymentConfiguration mutableSingletonDeploymentConfiguration;
                XMLStreamReader xmlReader = XML_INPUT_FACTORY.createXMLStreamReader(reader);
                try {
                    MutableSingletonDeploymentConfiguration config = new MutableSingletonDeploymentConfiguration(unit);
                    this.mapper.parseDocument((Object)config, xmlReader);
                    mutableSingletonDeploymentConfiguration = config;
                }
                catch (Throwable throwable2) {
                    try {
                        xmlReader.close();
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
                xmlReader.close();
                return mutableSingletonDeploymentConfiguration;
            }
        }
        catch (XMLStreamException e) {
            throw ServerLogger.ROOT_LOGGER.errorLoadingDeploymentStructureFile(file.getPath(), e);
        }
        catch (FileNotFoundException e) {
            throw ServerLogger.ROOT_LOGGER.deploymentStructureFileNotFound(file);
        }
        catch (IOException e) {
            throw ServerLogger.ROOT_LOGGER.deploymentStructureFileNotFound(file);
        }
    }
}

