/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.search.analyzer.spi.AnalyzerReference;
import org.hibernate.search.engine.impl.NormalizerRegistry;
import org.hibernate.search.util.impl.Closeables;

public class ImmutableNormalizerRegistry
implements NormalizerRegistry {
    private final Map<String, AnalyzerReference> referencesByName;
    private final Map<Class<?>, AnalyzerReference> referencesByClass;

    ImmutableNormalizerRegistry(NormalizerRegistry registryState) {
        this.referencesByName = Collections.unmodifiableMap(new HashMap<String, AnalyzerReference>(registryState.getNamedNormalizerReferences()));
        this.referencesByClass = Collections.unmodifiableMap(new HashMap(registryState.getLuceneClassNormalizerReferences()));
    }

    @Override
    public Map<String, AnalyzerReference> getNamedNormalizerReferences() {
        return this.referencesByName;
    }

    @Override
    public Map<Class<?>, AnalyzerReference> getLuceneClassNormalizerReferences() {
        return this.referencesByClass;
    }

    @Override
    public AnalyzerReference getNamedNormalizerReference(String name) {
        return this.referencesByName.get(name);
    }

    @Override
    public AnalyzerReference getLuceneClassNormalizerReference(Class<?> analyzerClazz) {
        return this.referencesByClass.get(analyzerClazz);
    }

    @Override
    public void close() {
        Closeables.closeQuietly(this.referencesByName.values(), this.referencesByClass.values());
    }
}

