/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.remote.configuration;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.elements.DefaultElementDefinition;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.persistence.remote.configuration.Element;
import org.infinispan.persistence.remote.configuration.MechanismConfiguration;

public class AuthenticationConfiguration
implements ConfigurationInfo {
    static final AttributeDefinition<Boolean> ENABLED = AttributeDefinition.builder((String)"enabled", (Object)false, Boolean.class).immutable().autoPersist(false).build();
    static final AttributeDefinition<CallbackHandler> CALLBACK_HANDLER = AttributeDefinition.builder((String)"callback-handler", null, CallbackHandler.class).immutable().autoPersist(false).build();
    static final AttributeDefinition<Subject> CLIENT_SUBJECT = AttributeDefinition.builder((String)"client-subject", null, Subject.class).immutable().autoPersist(false).build();
    static final AttributeDefinition<String> SERVER_NAME = AttributeDefinition.builder((String)"server-name", null, String.class).immutable().build();
    static final AttributeDefinition<Map> SASL_PROPERTIES = AttributeDefinition.builder((String)"sasl-properties", null, Map.class).initializer(HashMap::new).autoPersist(false).immutable().build();
    static ElementDefinition ELEMENT_DEFINITION = new DefaultElementDefinition(Element.AUTHENTICATION.getLocalName());
    private final AttributeSet attributes;
    private final MechanismConfiguration mechanismConfiguration;
    private List<ConfigurationInfo> subElements;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(AuthenticationConfiguration.class, new AttributeDefinition[]{ENABLED, CALLBACK_HANDLER, CLIENT_SUBJECT, SERVER_NAME, SASL_PROPERTIES});
    }

    public AuthenticationConfiguration(AttributeSet attributes, MechanismConfiguration mechanismConfiguration) {
        this.attributes = attributes.checkProtection();
        this.mechanismConfiguration = mechanismConfiguration;
        this.subElements = Collections.singletonList(mechanismConfiguration);
    }

    public List<ConfigurationInfo> subElements() {
        return this.subElements;
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    MechanismConfiguration mechanismConfiguration() {
        return this.mechanismConfiguration;
    }

    public ElementDefinition getElementDefinition() {
        return ELEMENT_DEFINITION;
    }

    public CallbackHandler callbackHandler() {
        return (CallbackHandler)this.attributes.attribute(CALLBACK_HANDLER).get();
    }

    public boolean enabled() {
        return (Boolean)this.attributes.attribute(ENABLED).get();
    }

    public String username() {
        return this.mechanismConfiguration.username();
    }

    public char[] password() {
        return this.mechanismConfiguration.password();
    }

    public String realm() {
        return this.mechanismConfiguration.realm();
    }

    public String saslMechanism() {
        return this.mechanismConfiguration.saslMechanism();
    }

    public Map<String, String> saslProperties() {
        return (Map)this.attributes.attribute(SASL_PROPERTIES).get();
    }

    public String serverName() {
        return (String)this.attributes.attribute(SERVER_NAME).get();
    }

    public Subject clientSubject() {
        return (Subject)this.attributes.attribute(CLIENT_SUBJECT).get();
    }

    public String toString() {
        return "AuthenticationConfiguration{attributes=" + this.attributes + ", mechanismConfiguration=" + this.mechanismConfiguration + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticationConfiguration that = (AuthenticationConfiguration)o;
        if (!this.attributes.equals((Object)that.attributes)) {
            return false;
        }
        return this.mechanismConfiguration.equals(that.mechanismConfiguration);
    }

    public int hashCode() {
        int result = this.attributes.hashCode();
        result = 31 * result + this.mechanismConfiguration.hashCode();
        return result;
    }
}

