/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.client.serviceref;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.RespectBindingFeature;
import javax.xml.ws.Service;
import javax.xml.ws.WebEndpoint;
import javax.xml.ws.WebServiceClient;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.soap.AddressingFeature;
import javax.xml.ws.soap.MTOMFeature;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.configuration.Configurer;
import org.jboss.logging.Logger;
import org.jboss.ws.common.Messages;
import org.jboss.wsf.spi.WSFException;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedPortComponentRefMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedServiceRefMetaData;
import org.jboss.wsf.stack.cxf.client.ClientBusSelector;
import org.jboss.wsf.stack.cxf.client.UseThreadBusFeature;
import org.jboss.wsf.stack.cxf.client.serviceref.CXFHandlerResolverImpl;
import org.jboss.wsf.stack.cxf.client.serviceref.CXFServiceRefStubPropertyConfigurer;
import org.jboss.wsf.stack.cxf.client.serviceref.SecurityActions;

public final class CXFServiceObjectFactoryJAXWS {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Object getObjectInstance(UnifiedServiceRefMetaData serviceRef) {
        try {
            String serviceImplClass = this.getServiceClassName(serviceRef);
            String targetClassName = this.getTargetClassName(serviceRef);
            Class<?> serviceClass = this.getClass(serviceImplClass);
            Class<?> targetClass = this.getClass(targetClassName);
            BusFactory.setThreadDefaultBus(null);
            Bus bus = this.createNewBus(serviceRef);
            try {
                Service serviceInstance = this.instantiateService(serviceRef, serviceClass);
                if (serviceRef.getHandlerChain() != null) {
                    serviceInstance.setHandlerResolver((HandlerResolver)new CXFHandlerResolverImpl(bus, serviceRef.getHandlerChain(), serviceInstance.getClass()));
                }
                boolean instantiatePort = targetClassName != null && !Service.class.isAssignableFrom(targetClass);
                if (!instantiatePort) return serviceInstance;
                QName portQName = this.getPortQName(targetClassName, serviceImplClass, serviceRef);
                WebServiceFeature[] portFeatures = this.getFeatures(targetClassName, serviceImplClass, serviceRef);
                String forcedAddress = null;
                if (this.getWsdlURL(serviceRef, serviceClass) == null) {
                    QName serviceQName = this.getServiceQName(serviceRef, serviceClass);
                    forcedAddress = serviceRef.getDeployedServiceAddress(serviceQName);
                }
                Object object = this.instantiatePort(serviceClass, targetClass, serviceInstance, portQName, portFeatures, forcedAddress);
                return object;
            }
            finally {
                BusFactory.setThreadDefaultBus(null);
            }
        }
        catch (Exception ex) {
            WSFException.rethrow((String)"Cannot create service", (Throwable)ex);
            return null;
        }
    }

    private Class<?> getClass(String className) throws ClassNotFoundException {
        if (className != null) {
            return SecurityActions.getContextClassLoader().loadClass(className);
        }
        return null;
    }

    private String getServiceClassName(UnifiedServiceRefMetaData serviceRefMD) {
        String serviceImplClassName = serviceRefMD.getServiceImplClass();
        if (serviceImplClassName != null) {
            return serviceImplClassName;
        }
        String serviceInterfaceName = serviceRefMD.getServiceInterface();
        if (serviceInterfaceName != null) {
            return serviceInterfaceName;
        }
        return Service.class.getName();
    }

    private String getTargetClassName(UnifiedServiceRefMetaData serviceRefMD) {
        return serviceRefMD.getServiceRefType();
    }

    private Object instantiatePort(Class<?> serviceClass, Class<?> targetClass, Service target, QName portQName, WebServiceFeature[] features, String endpointAddress) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Object port = null;
        Object candidatePort = null;
        if (serviceClass != Service.class) {
            HashSet<Method> signatureMatchingMethods = new HashSet<Method>();
            for (Method method : CXFServiceObjectFactoryJAXWS.getDeclaredMethods(serviceClass)) {
                String methodName = method.getName();
                Class<?> retType = method.getReturnType();
                if (!methodName.startsWith("get") || !targetClass.isAssignableFrom(retType)) continue;
                Method targetMethod = this.getMethodFor(methodName, features, serviceClass);
                signatureMatchingMethods.add(targetMethod);
            }
            for (Method method : signatureMatchingMethods) {
                Object[] args;
                PortMatch matchResult = CXFServiceObjectFactoryJAXWS.portNameMatches(portQName, method);
                if (matchResult.equals((Object)PortMatch.YES)) {
                    args = this.getArgumentsFor(features);
                    port = method.invoke((Object)target, args);
                    break;
                }
                if (!matchResult.equals((Object)PortMatch.MAYBE)) continue;
                args = this.getArgumentsFor(features);
                candidatePort = method.invoke((Object)target, args);
            }
        }
        if (port == null) {
            port = candidatePort;
        }
        if (port == null) {
            Method method = this.getMethodFor("getPort", portQName, features, serviceClass);
            Object[] args = this.getArgumentsFor(portQName, features, targetClass);
            port = method.invoke((Object)target, args);
        }
        if (endpointAddress != null) {
            ((BindingProvider)port).getRequestContext().put("javax.xml.ws.service.endpoint.address", endpointAddress);
        }
        return port;
    }

    private static PortMatch portNameMatches(QName portQName, Method targetMethod) {
        String portName;
        String string = portName = portQName != null ? portQName.getLocalPart() : null;
        if (portName == null) {
            return PortMatch.MAYBE;
        }
        WebEndpoint webEndpointAnnotation = targetMethod.getAnnotation(WebEndpoint.class);
        if (webEndpointAnnotation == null || webEndpointAnnotation.name() == null || webEndpointAnnotation.name().isEmpty()) {
            return PortMatch.MAYBE;
        }
        return webEndpointAnnotation.name().equals(portName) ? PortMatch.YES : PortMatch.NO;
    }

    private static Method[] getDeclaredMethods(final Class<?> cls) {
        return AccessController.doPrivileged(new PrivilegedAction<Method[]>(){

            @Override
            public Method[] run() {
                return cls.getDeclaredMethods();
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Service instantiateService(UnifiedServiceRefMetaData serviceRefMD, Class<?> serviceClass) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, WSFException {
        String deployedServiceAddress;
        List<WebServiceFeature> featuresList = this.getFeatures(serviceRefMD);
        if (!ClientBusSelector.getDefaultStrategy().equals("THREAD_BUS")) {
            featuresList.add(new UseThreadBusFeature());
        }
        WebServiceFeature[] features = featuresList.size() == 0 ? null : featuresList.toArray(new WebServiceFeature[0]);
        QName serviceQName = this.getServiceQName(serviceRefMD, serviceClass);
        URL wsdlURL = this.getWsdlURL(serviceRefMD, serviceClass);
        if (wsdlURL == null && (deployedServiceAddress = serviceRefMD.getDeployedServiceAddress(serviceQName)) != null) {
            try {
                wsdlURL = new URL(deployedServiceAddress + "?wsdl");
            }
            catch (MalformedURLException e) {
                Logger.getLogger(CXFServiceObjectFactoryJAXWS.class).trace((Object)e);
            }
        }
        Service target = null;
        if (serviceClass == Service.class) {
            if (wsdlURL == null) throw Messages.MESSAGES.cannotCreateServiceWithoutWsdlLocation(serviceRefMD);
            if (features == null) return Service.create((URL)wsdlURL, (QName)serviceQName);
            return Service.create((URL)wsdlURL, (QName)serviceQName, (WebServiceFeature[])features);
        }
        if (wsdlURL != null) {
            if (features != null) {
                try {
                    Constructor<?> ctor = serviceClass.getConstructor(URL.class, QName.class, WebServiceFeature[].class);
                    return (Service)ctor.newInstance(wsdlURL, serviceQName, features);
                }
                catch (NoSuchMethodException nsme) {
                    throw org.jboss.wsf.stack.cxf.i18n.Messages.MESSAGES.missingJAXWS22ServiceConstructor(serviceClass.getName(), nsme);
                }
            }
            Constructor<?> ctor = serviceClass.getConstructor(URL.class, QName.class);
            return (Service)ctor.newInstance(wsdlURL, serviceQName);
        }
        if (features == null) return (Service)serviceClass.newInstance();
        try {
            Constructor<?> ctor = serviceClass.getConstructor(WebServiceFeature[].class);
            return (Service)ctor.newInstance(new Object[]{features});
        }
        catch (NoSuchMethodException nsme) {
            throw org.jboss.wsf.stack.cxf.i18n.Messages.MESSAGES.missingJAXWS22ServiceConstructor(serviceClass.getName(), nsme);
        }
    }

    private URL getWsdlURL(UnifiedServiceRefMetaData serviceRefMD, Class<?> serviceClass) {
        WebServiceClient webServiceClientAnnotation;
        if (serviceRefMD.getWsdlLocation() == null && (webServiceClientAnnotation = serviceClass.getAnnotation(WebServiceClient.class)) != null && webServiceClientAnnotation.wsdlLocation().length() > 0) {
            return serviceRefMD.getWsdlLocation(webServiceClientAnnotation.wsdlLocation());
        }
        return serviceRefMD.getWsdlLocation();
    }

    private QName getServiceQName(UnifiedServiceRefMetaData serviceRefMD, Class<?> serviceClass) {
        WebServiceClient webServiceClientAnnotation;
        QName retVal = serviceRefMD.getServiceQName();
        if (retVal == null && (webServiceClientAnnotation = serviceClass.getAnnotation(WebServiceClient.class)) != null) {
            retVal = new QName(webServiceClientAnnotation.targetNamespace(), webServiceClientAnnotation.name());
        }
        return retVal;
    }

    private WebServiceFeature[] getFeatures(String targetClassName, String serviceClassName, UnifiedServiceRefMetaData serviceRefMD) {
        if (targetClassName != null && !targetClassName.equals(serviceClassName)) {
            Collection portComponentRefs = serviceRefMD.getPortComponentRefs();
            for (UnifiedPortComponentRefMetaData portComponentRefMD : portComponentRefs) {
                if (!targetClassName.equals(portComponentRefMD.getServiceEndpointInterface())) continue;
                return this.getFeatures(portComponentRefMD);
            }
        }
        return null;
    }

    private QName getPortQName(String targetClassName, String serviceClassName, UnifiedServiceRefMetaData serviceRefMD) {
        if (targetClassName != null && !targetClassName.equals(serviceClassName)) {
            Collection portComponentRefs = serviceRefMD.getPortComponentRefs();
            for (UnifiedPortComponentRefMetaData portComponentRefMD : portComponentRefs) {
                if (!targetClassName.equals(portComponentRefMD.getServiceEndpointInterface())) continue;
                return portComponentRefMD.getPortQName();
            }
        }
        return null;
    }

    private Method getMethodFor(String methodName, QName portQName, WebServiceFeature[] features, Class<?> serviceClass) throws NoSuchMethodException {
        if (portQName == null && features == null) {
            return serviceClass.getMethod(methodName, Class.class);
        }
        if (portQName != null && features == null) {
            return serviceClass.getMethod(methodName, QName.class, Class.class);
        }
        if (portQName == null && features != null) {
            return serviceClass.getMethod(methodName, Class.class, WebServiceFeature[].class);
        }
        if (portQName != null && features != null) {
            return serviceClass.getMethod(methodName, QName.class, Class.class, WebServiceFeature[].class);
        }
        throw new IllegalStateException();
    }

    private Method getMethodFor(String methodName, WebServiceFeature[] features, Class<?> serviceClass) throws NoSuchMethodException {
        if (features == null) {
            return serviceClass.getMethod(methodName, new Class[0]);
        }
        return serviceClass.getMethod(methodName, WebServiceFeature[].class);
    }

    private Object[] getArgumentsFor(QName portQName, WebServiceFeature[] features, Class<?> targetClass) throws NoSuchMethodException {
        if (portQName == null && features == null) {
            return new Object[]{targetClass};
        }
        if (portQName != null && features == null) {
            return new Object[]{portQName, targetClass};
        }
        if (portQName == null && features != null) {
            return new Object[]{targetClass, features};
        }
        if (portQName != null && features != null) {
            return new Object[]{portQName, targetClass, features};
        }
        throw new IllegalStateException();
    }

    private Object[] getArgumentsFor(WebServiceFeature[] features) throws NoSuchMethodException {
        if (features == null) {
            return new Object[0];
        }
        return new Object[]{features};
    }

    private List<WebServiceFeature> getFeatures(UnifiedServiceRefMetaData serviceRef) {
        boolean enabled;
        LinkedList<WebServiceFeature> features = new LinkedList<WebServiceFeature>();
        if (serviceRef.isAddressingAnnotationSpecified()) {
            enabled = serviceRef.isAddressingEnabled();
            boolean required = serviceRef.isAddressingRequired();
            String refResponses = serviceRef.getAddressingResponses();
            AddressingFeature.Responses responses = AddressingFeature.Responses.ALL;
            if ("ANONYMOUS".equals(refResponses)) {
                responses = AddressingFeature.Responses.ANONYMOUS;
            }
            if ("NON_ANONYMOUS".equals(refResponses)) {
                responses = AddressingFeature.Responses.NON_ANONYMOUS;
            }
            features.add((WebServiceFeature)new AddressingFeature(enabled, required, responses));
        }
        if (serviceRef.isMtomAnnotationSpecified()) {
            enabled = serviceRef.isMtomEnabled();
            int threshold = serviceRef.getMtomThreshold();
            features.add((WebServiceFeature)new MTOMFeature(enabled, threshold));
        }
        if (serviceRef.isRespectBindingAnnotationSpecified()) {
            enabled = serviceRef.isRespectBindingEnabled();
            features.add((WebServiceFeature)new RespectBindingFeature(enabled));
        }
        return features;
    }

    private WebServiceFeature[] getFeatures(UnifiedPortComponentRefMetaData portComponentRefMD) {
        boolean enabled;
        LinkedList<Object> features = new LinkedList<Object>();
        if (portComponentRefMD.isAddressingAnnotationSpecified()) {
            enabled = portComponentRefMD.isAddressingEnabled();
            boolean required = portComponentRefMD.isAddressingRequired();
            String refResponses = portComponentRefMD.getAddressingResponses();
            AddressingFeature.Responses responses = AddressingFeature.Responses.ALL;
            if ("ANONYMOUS".equals(refResponses)) {
                responses = AddressingFeature.Responses.ANONYMOUS;
            }
            if ("NON_ANONYMOUS".equals(refResponses)) {
                responses = AddressingFeature.Responses.NON_ANONYMOUS;
            }
            features.add(new AddressingFeature(enabled, required, responses));
        }
        if (portComponentRefMD.isMtomEnabled()) {
            features.add(new MTOMFeature(true, portComponentRefMD.getMtomThreshold()));
        }
        if (portComponentRefMD.isRespectBindingAnnotationSpecified()) {
            enabled = portComponentRefMD.isRespectBindingEnabled();
            features.add(new RespectBindingFeature(enabled));
        }
        return features.size() == 0 ? null : features.toArray(new WebServiceFeature[0]);
    }

    private Bus createNewBus(UnifiedServiceRefMetaData serviceRefMD) {
        Bus threadBus = BusFactory.getThreadDefaultBus((boolean)false);
        Bus bus = threadBus != null ? threadBus : BusFactory.newInstance().createBus();
        Configurer configurer = (Configurer)bus.getExtension(Configurer.class);
        bus.setExtension((Object)new CXFServiceRefStubPropertyConfigurer(serviceRefMD, configurer), Configurer.class);
        return bus;
    }

    private static enum PortMatch {
        YES,
        NO,
        MAYBE;

    }
}

