/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.query.internal;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.picketlink.common.properties.Property;
import org.picketlink.common.properties.query.NamedPropertyCriteria;
import org.picketlink.common.properties.query.PropertyCriteria;
import org.picketlink.common.properties.query.PropertyQueries;
import org.picketlink.common.properties.query.TypedPropertyCriteria;
import org.picketlink.common.reflection.Reflections;
import org.picketlink.idm.IDMInternalMessages;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.PartitionManager;
import org.picketlink.idm.config.OperationNotSupportedException;
import org.picketlink.idm.internal.RelationshipReference;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.query.QueryParameter;
import org.picketlink.idm.query.RelationshipQuery;
import org.picketlink.idm.spi.AttributeStore;
import org.picketlink.idm.spi.IdentityContext;
import org.picketlink.idm.spi.IdentityStore;
import org.picketlink.idm.spi.StoreSelector;
import org.picketlink.idm.util.IDMUtil;

public class DefaultRelationshipQuery<T extends Relationship>
implements RelationshipQuery<T> {
    private Map<QueryParameter, Object[]> parameters = new LinkedHashMap<QueryParameter, Object[]>();
    private IdentityContext context;
    private StoreSelector storeSelector;
    private Class<T> relationshipClass;
    private int offset;
    private int limit;

    public DefaultRelationshipQuery(IdentityContext context, Class<T> relationshipClass, StoreSelector storeSelector) {
        this.context = context;
        this.relationshipClass = relationshipClass;
        this.storeSelector = storeSelector;
    }

    public RelationshipQuery<T> setParameter(QueryParameter param, Object ... value) {
        this.parameters.put(param, value);
        return this;
    }

    public Class<T> getRelationshipClass() {
        return this.relationshipClass;
    }

    public Map<QueryParameter, Object[]> getParameters() {
        return this.parameters;
    }

    public Object[] getParameter(QueryParameter queryParameter) {
        return this.parameters.get(queryParameter);
    }

    public int getLimit() {
        return this.limit;
    }

    public int getOffset() {
        return this.offset;
    }

    public List<T> getResultList() {
        ArrayList<Relationship> result = new ArrayList<Relationship>();
        try {
            AttributeStore attributeStore = this.storeSelector.getStoreForAttributeOperation(this.context);
            for (IdentityStore<?> store : this.getStores()) {
                List references = store.fetchQueryResults(this.context, (RelationshipQuery)this);
                for (Relationship relationship : references) {
                    List identityTypes = PropertyQueries.createQuery(relationship.getClass()).addCriteria((PropertyCriteria)new TypedPropertyCriteria(IdentityType.class, TypedPropertyCriteria.MatchOption.ALL)).getResultList();
                    for (Property identityTypeProperty : identityTypes) {
                        IdentityType identityType = (IdentityType)identityTypeProperty.getValue((Object)relationship);
                        IDMUtil.configureDefaultPartition((IdentityType)identityType, store, (PartitionManager)this.getPartitionManager());
                    }
                    if (RelationshipReference.class.isInstance(relationship)) {
                        RelationshipReference reference = (RelationshipReference)relationship;
                        this.resolveIdentityTypes(reference);
                        relationship = reference.getRelationship();
                    }
                    if (attributeStore != null) {
                        attributeStore.loadAttributes(this.context, (AttributedType)relationship);
                    }
                    result.add(relationship);
                }
            }
        }
        catch (Exception e) {
            throw IDMInternalMessages.MESSAGES.queryRelationshipFailed(this, e);
        }
        return result;
    }

    private void resolveIdentityTypes(RelationshipReference reference) {
        Relationship relationship = reference.getRelationship();
        for (String descriptor : reference.getDescriptors()) {
            Class identityTypeClass;
            String type = reference.getIdentityType(descriptor);
            String partitionId = reference.getPartitionId(descriptor);
            String identityTypeId = reference.getIdentityTypeId(descriptor);
            PartitionManager partitionManager = this.getPartitionManager();
            Partition partition = partitionManager.lookupById(Partition.class, partitionId);
            if (partition == null) {
                throw new IdentityManagementException("No partition [" + partitionId + "] found for referenced IdentityType [" + identityTypeId + "].");
            }
            try {
                identityTypeClass = Reflections.classForName((String)type, (ClassLoader[])new ClassLoader[]{DefaultRelationshipQuery.getClassLoader(reference.getRelationship().getClass())});
            }
            catch (ClassNotFoundException e) {
                throw new IdentityManagementException("Could not instantiate referenced identity type [" + type + "].", (Throwable)e);
            }
            IdentityManager identityManager = partitionManager.createIdentityManager(partition);
            IdentityType identityType = identityManager.lookupIdentityById(identityTypeClass, identityTypeId);
            if (identityType == null) {
                throw new IdentityManagementException("Referenced IdentityType [" + identityTypeId + "] from relationship [" + relationship.getClass() + "] does not exists in any store.");
            }
            Property property = PropertyQueries.createQuery(relationship.getClass()).addCriteria((PropertyCriteria)new NamedPropertyCriteria(new String[]{descriptor})).getSingleResult();
            property.setValue((Object)relationship, (Object)identityType);
        }
    }

    private static ClassLoader getClassLoader(final Class<?> clazz) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return clazz.getClassLoader();
                }
            });
        }
        return clazz.getClassLoader();
    }

    private PartitionManager getPartitionManager() {
        return (PartitionManager)this.storeSelector;
    }

    public int getResultCount() {
        int count = 0;
        try {
            for (IdentityStore<?> store : this.getStores()) {
                count += store.countQueryResults(this.context, (RelationshipQuery)this);
            }
        }
        catch (Exception e) {
            throw IDMInternalMessages.MESSAGES.queryRelationshipFailed(this, e);
        }
        return count;
    }

    public RelationshipQuery<T> setOffset(int offset) {
        this.offset = offset;
        return this;
    }

    public RelationshipQuery<T> setLimit(int limit) {
        this.limit = limit;
        return this;
    }

    private Set<IdentityStore<?>> getStores() {
        HashSet<Partition> partitions = new HashSet<Partition>();
        for (Object[] param : this.parameters.values()) {
            if (!IdentityType.class.isInstance(param)) continue;
            partitions.add(((IdentityType)param).getPartition());
        }
        try {
            return this.storeSelector.getStoresForRelationshipQuery(this.context, this.relationshipClass, partitions);
        }
        catch (OperationNotSupportedException onse) {
            return Collections.EMPTY_SET;
        }
    }
}

