/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.infinispan.client.hotrod.ProtocolVersion;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.client.hotrod.impl.transport.netty.HeaderDecoder;
import org.infinispan.commons.dataconversion.MediaType;

public class PingResponse {
    public static PingResponse EMPTY = new PingResponse(null);
    private final short status;
    private final ProtocolVersion version;
    private final MediaType keyMediaType;
    private final MediaType valueMediaType;
    private final Throwable error;
    private final Set<Short> serverOps;

    private PingResponse(short status, ProtocolVersion version, MediaType keyMediaType, MediaType valueMediaType, Set<Short> serverOps) {
        this.status = status;
        this.version = version;
        this.keyMediaType = keyMediaType;
        this.valueMediaType = valueMediaType;
        this.serverOps = serverOps;
        this.error = null;
    }

    PingResponse(Throwable error) {
        this.status = (short)-1;
        this.version = ProtocolVersion.DEFAULT_PROTOCOL_VERSION;
        this.keyMediaType = MediaType.APPLICATION_UNKNOWN;
        this.valueMediaType = MediaType.APPLICATION_UNKNOWN;
        this.serverOps = Collections.emptySet();
        this.error = error;
    }

    public short getStatus() {
        return this.status;
    }

    public boolean isSuccess() {
        return HotRodConstants.isSuccess(this.status);
    }

    public boolean isObjectStorage() {
        return this.keyMediaType != null && this.keyMediaType.match(MediaType.APPLICATION_OBJECT);
    }

    public boolean isFailed() {
        return this.error != null;
    }

    public boolean isCacheNotFound() {
        return this.error instanceof HotRodClientException && this.error.getMessage().contains("CacheNotFoundException");
    }

    public Set<Short> getServerOps() {
        return this.serverOps;
    }

    public ProtocolVersion getVersion() {
        return this.version;
    }

    public static class Decoder {
        int decoderState = 0;
        final ProtocolVersion version;
        ProtocolVersion serverVersion;
        int serverOpsCount = -1;
        Set<Short> serverOps;
        MediaType keyMediaType;
        MediaType valueMediaType;

        Decoder(ProtocolVersion version) {
            this.version = version;
        }

        void processResponse(Codec codec, ByteBuf buf, HeaderDecoder decoder) {
            while (this.decoderState < 4) {
                switch (this.decoderState) {
                    case 0: {
                        this.keyMediaType = codec.readKeyType(buf);
                        this.valueMediaType = codec.readKeyType(buf);
                        decoder.checkpoint();
                        if (this.version.compareTo(ProtocolVersion.PROTOCOL_VERSION_30) < 0) {
                            this.decoderState = 4;
                            break;
                        }
                        ++this.decoderState;
                    }
                    case 1: {
                        this.serverVersion = ProtocolVersion.getBestVersion(buf.readUnsignedByte());
                        decoder.checkpoint();
                        ++this.decoderState;
                    }
                    case 2: {
                        this.serverOpsCount = ByteBufUtil.readVInt(buf);
                        this.serverOps = new TreeSet<Short>();
                        decoder.checkpoint();
                        ++this.decoderState;
                    }
                    case 3: {
                        while (this.serverOps.size() < this.serverOpsCount) {
                            short opCode = buf.readShort();
                            this.serverOps.add(opCode);
                            decoder.checkpoint();
                        }
                        ++this.decoderState;
                    }
                }
            }
        }

        PingResponse build(short status) {
            assert (this.decoderState == 4) : "Invalid decoder state";
            return new PingResponse(status, this.version, this.keyMediaType, this.valueMediaType, this.serverOps);
        }

        public void reset() {
            this.decoderState = 0;
        }
    }
}

