/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.OptionalInt;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.RawProtoStreamReader;
import org.infinispan.protostream.RawProtoStreamWriter;
import org.wildfly.clustering.marshalling.protostream.Any;
import org.wildfly.clustering.marshalling.protostream.Predictable;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;

public class ArrayMarshaller
implements ProtoStreamMarshaller<Object> {
    private final ProtoStreamMarshaller<Class<?>> componentTypeMarshaller;
    private final ProtoStreamMarshaller<Object> elementMarshaller;

    public ArrayMarshaller(ProtoStreamMarshaller<Class<?>> componentTypeMarshaller, ProtoStreamMarshaller<Object> elementMarshaller) {
        this.componentTypeMarshaller = componentTypeMarshaller;
        this.elementMarshaller = elementMarshaller;
    }

    public Object readFrom(ImmutableSerializationContext context, RawProtoStreamReader reader) throws IOException {
        int length = reader.readUInt32();
        Class componentType = (Class)this.componentTypeMarshaller.readFrom(context, reader);
        Object array = Array.newInstance(componentType == Any.class ? Object.class : componentType, length);
        for (int i = 0; i < length; ++i) {
            Object element = this.elementMarshaller.readFrom(context, reader);
            Array.set(array, i, element);
        }
        return array;
    }

    public void writeTo(ImmutableSerializationContext context, RawProtoStreamWriter writer, Object array) throws IOException {
        int length = Array.getLength(array);
        writer.writeUInt32NoTag(length);
        this.componentTypeMarshaller.writeTo(context, writer, array.getClass().getComponentType());
        for (int i = 0; i < length; ++i) {
            Object element = Array.get(array, i);
            this.elementMarshaller.writeTo(context, writer, element);
        }
    }

    @Override
    public OptionalInt size(ImmutableSerializationContext context, Object array) {
        OptionalInt componentTypeSize = this.componentTypeMarshaller.size(context, array.getClass().getComponentType());
        if (componentTypeSize.isPresent()) {
            int length = Array.getLength(array);
            int size = Predictable.unsignedIntSize(length);
            for (int i = 0; i < length; ++i) {
                Object element = Array.get(array, i);
                OptionalInt elementSize = this.elementMarshaller.size(context, element);
                if (elementSize.isPresent()) {
                    size += elementSize.getAsInt();
                    continue;
                }
                return OptionalInt.empty();
            }
            return OptionalInt.of(size + componentTypeSize.getAsInt());
        }
        return OptionalInt.empty();
    }

    public Class<? extends Object> getJavaClass() {
        return null;
    }
}

