/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream.util;

import java.io.IOException;
import java.lang.reflect.Field;
import java.security.PrivilegedAction;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.OptionalInt;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.RawProtoStreamReader;
import org.infinispan.protostream.RawProtoStreamWriter;
import org.wildfly.clustering.marshalling.protostream.AnyField;
import org.wildfly.clustering.marshalling.protostream.ClassField;
import org.wildfly.clustering.marshalling.protostream.Predictable;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.security.manager.WildFlySecurityManager;

public class EnumSetMarshaller<E extends Enum<E>>
implements ProtoStreamMarshaller<EnumSet<E>> {
    public EnumSet<E> readFrom(ImmutableSerializationContext context, RawProtoStreamReader reader) throws IOException {
        Class enumClass = (Class)ClassField.ANY.readFrom(context, reader);
        EnumSet<Enum> set = EnumSet.noneOf(enumClass);
        BitSet values = BitSet.valueOf((byte[])AnyField.BYTE_ARRAY.cast(byte[].class).readFrom(context, reader));
        Enum[] enumValues = (Enum[])enumClass.getEnumConstants();
        for (int i = 0; i < enumValues.length; ++i) {
            if (!values.get(i)) continue;
            set.add(enumValues[i]);
        }
        return set;
    }

    public void writeTo(ImmutableSerializationContext context, RawProtoStreamWriter writer, EnumSet<E> set) throws IOException {
        Class<?> enumClass = this.findEnumClass(set);
        ClassField.ANY.writeTo(context, writer, enumClass);
        ?[] enumValues = enumClass.getEnumConstants();
        BitSet values = new BitSet(enumValues.length);
        for (int i = 0; i < enumValues.length; ++i) {
            values.set(i, set.contains(enumValues[i]));
        }
        AnyField.BYTE_ARRAY.writeTo(context, writer, values.toByteArray());
    }

    @Override
    public OptionalInt size(ImmutableSerializationContext context, EnumSet<E> set) {
        Class<?> enumClass = this.findEnumClass(set);
        OptionalInt size = ClassField.ANY.size(context, enumClass);
        ?[] enumValues = enumClass.getEnumConstants();
        int bytes = enumValues.length / 8;
        if (enumValues.length % 8 > 0) {
            ++bytes;
        }
        return size.isPresent() ? OptionalInt.of(size.getAsInt() + bytes + Predictable.unsignedIntSize(bytes)) : OptionalInt.empty();
    }

    public Class<? extends EnumSet<E>> getJavaClass() {
        return EnumSet.class;
    }

    private Class<?> findEnumClass(final EnumSet<E> set) {
        EnumSet<E> nonEmptySet = set.isEmpty() ? EnumSet.complementOf(set) : set;
        Iterator values = nonEmptySet.iterator();
        if (values.hasNext()) {
            return ((Enum)values.next()).getDeclaringClass();
        }
        return (Class)WildFlySecurityManager.doUnchecked((PrivilegedAction)new PrivilegedAction<Class<?>>(){

            @Override
            public Class<?> run() {
                try {
                    Field field = EnumSet.class.getDeclaredField("elementType");
                    field.setAccessible(true);
                    return (Class)field.get(set);
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    throw new IllegalStateException(e);
                }
            }
        });
    }
}

