/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.extensions.highlight;

import java.awt.Color;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Map;
import org.aesh.extensions.highlight.Encoder;
import org.aesh.extensions.highlight.Options;
import org.aesh.extensions.highlight.Scanner;
import org.aesh.extensions.highlight.StringScanner;
import org.aesh.extensions.highlight.Theme;
import org.aesh.extensions.highlight.TokenType;
import org.aesh.extensions.highlight.encoder.DebugEncoder;
import org.aesh.extensions.highlight.encoder.TerminalEncoder;
import org.aesh.extensions.highlight.scanner.CSSScanner;
import org.aesh.extensions.highlight.scanner.GroovyScanner;
import org.aesh.extensions.highlight.scanner.HTMLScanner;
import org.aesh.extensions.highlight.scanner.JSONScanner;
import org.aesh.extensions.highlight.scanner.JavaScanner;
import org.aesh.extensions.highlight.scanner.JavaScriptScanner;
import org.aesh.extensions.highlight.scanner.PlainScanner;
import org.aesh.extensions.highlight.scanner.PropertiesScanner;
import org.aesh.extensions.highlight.scanner.SQLScanner;
import org.aesh.extensions.highlight.scanner.XMLScanner;
import org.aesh.extensions.highlight.scanner.YAMLScanner;

public class Syntax {
    public static void builtIns() {
        Scanner.Factory.registrer(PlainScanner.class);
        Scanner.Factory.registrer(JavaScanner.class);
        Scanner.Factory.registrer(HTMLScanner.class);
        Scanner.Factory.registrer(XMLScanner.class);
        Scanner.Factory.registrer(CSSScanner.class);
        Scanner.Factory.registrer(JavaScriptScanner.class);
        Scanner.Factory.registrer(JSONScanner.class);
        Scanner.Factory.registrer(PropertiesScanner.class);
        Scanner.Factory.registrer(SQLScanner.class);
        Scanner.Factory.registrer(GroovyScanner.class);
        Scanner.Factory.registrer(YAMLScanner.class);
        Encoder.Factory.registrer(Encoder.Type.TERMINAL.name(), TerminalEncoder.class);
        Encoder.Factory.registrer(Encoder.Type.DEBUG.name(), DebugEncoder.class);
    }

    public static Theme defaultTheme() {
        return new Theme().set(Color.RED, TokenType.predefined_constant, TokenType.content, TokenType.delimiter, TokenType.color, TokenType.value, TokenType.integer, TokenType.float_).set(Color.CYAN, TokenType.tag, TokenType.class_, TokenType.function).set(Color.MAGENTA, TokenType.keyword, new TokenType[0]).set(Color.GREEN, TokenType.type, TokenType.directive, TokenType.string, TokenType.attribute_value, TokenType.attribute_name, TokenType.key);
    }

    public static void main(String[] args) {
        Scanner scanner;
        Syntax.builtIns();
        if (args.length < 1) {
            System.out.println("Usage: java -jar forge-text-syntax.jar file-name");
        }
        Encoder.Type encoder = Encoder.Type.TERMINAL;
        String fileName = args[0];
        if (args.length == 2) {
            encoder = Encoder.Type.DEBUG;
        }
        if ((scanner = Scanner.Factory.byFileName(fileName)) == null) {
            throw new RuntimeException("Could not determine scanner type based on filename " + fileName);
        }
        String content = null;
        try {
            content = new String(Files.readAllBytes(Paths.get(fileName, new String[0])));
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read given file " + fileName, e);
        }
        BufferedOutputStream out = new BufferedOutputStream(System.out);
        Builder.create().scanner(scanner).encoderType(encoder).output(out).execute(content);
        try {
            out.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static final class Builder {
        private String scannerType;
        private Scanner scanner;
        private Map<String, Object> scannerOptions;
        private String encoderType;
        private Encoder encoder;
        private Map<String, Object> encoderOptions;
        private OutputStream output = System.out;
        private Theme theme = Syntax.defaultTheme();

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public Builder scannerType(String scannerType) {
            this.scannerType = scannerType;
            return this;
        }

        public Builder scanner(Scanner scanner) {
            this.scanner = scanner;
            return this;
        }

        public Builder scannerOptions(Map<String, Object> options) {
            this.scannerOptions = options;
            return this;
        }

        public Builder encoderType(Encoder.Type encoderType) {
            return this.encoderType(encoderType.name());
        }

        public Builder encoderType(String encoderType) {
            this.encoderType = encoderType;
            return this;
        }

        public Builder encoder(Encoder encoder) {
            this.encoder = encoder;
            return this;
        }

        public Builder encoderOptions(Map<String, Object> options) {
            this.encoderOptions = options;
            return this;
        }

        public Builder output(OutputStream output) {
            this.output = output;
            return this;
        }

        public Builder theme(Theme theme) {
            this.theme = theme;
            return this;
        }

        public void execute(String source) {
            this.execute(new StringScanner(source));
        }

        public void execute(StringScanner source) {
            if (this.output == null && this.encoder == null) {
                throw new IllegalArgumentException("Either output or encoder must be defined");
            }
            Scanner in = this.scanner;
            if (this.scanner == null) {
                if (this.scannerType == null) {
                    throw new IllegalArgumentException("Either input or inputType must be defined");
                }
                in = Scanner.Factory.byType(this.scannerType);
            }
            Encoder out = this.encoder;
            if (this.encoder == null) {
                if (this.encoderType == null) {
                    throw new IllegalArgumentException("Either output or outputType must be defined");
                }
                out = Encoder.Factory.create(this.encoderType, this.output, this.theme, this.encoderOptions == null ? Options.create() : this.encoderOptions);
            }
            in.scan(source, out, this.scannerOptions == null ? Options.create() : this.scannerOptions);
        }
    }
}

