/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.jar.runtime;

import java.nio.file.Path;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.wildfly.core.jar.runtime.PropertyUpdater;

class BootableEnvironment {
    private static final AtomicBoolean DEBUG = new AtomicBoolean();
    private static final boolean IS_WINDOWS = System.getProperty("os.name").toLowerCase(Locale.ROOT).contains("windows");
    private final Path jbossHome;
    private final Path serverDir;
    private final Collection<String> ignoredProperties;
    private final PropertyUpdater propertyUpdater;
    private final String pidFileName;
    private final long timeout;

    private BootableEnvironment(Path jbossHome, Collection<String> ignoredProperties, PropertyUpdater propertyUpdater) {
        long timeout;
        this.jbossHome = jbossHome;
        this.serverDir = jbossHome.resolve("standalone");
        this.ignoredProperties = ignoredProperties;
        this.propertyUpdater = propertyUpdater;
        String pidFileName = System.getProperty("org.wildfly.core.bootable.jar.pidFile");
        if (pidFileName == null && (pidFileName = System.getenv("JBOSS_PIDFILE")) == null) {
            pidFileName = "wildfly.pid";
        }
        this.pidFileName = pidFileName;
        try {
            timeout = Long.parseLong(System.getProperty("org.wildfly.core.bootable.jar.timeout", "10"));
        }
        catch (NumberFormatException ignore) {
            timeout = 10L;
        }
        this.timeout = timeout;
    }

    static BootableEnvironment of(Path jbossHome) {
        PropertyUpdater propertyUpdater = System.getSecurityManager() == null ? System::setProperty : (name, value) -> AccessController.doPrivileged(() -> System.setProperty(name, value));
        return BootableEnvironment.of(jbossHome, propertyUpdater);
    }

    static BootableEnvironment of(Path jbossHome, PropertyUpdater propertyUpdater) {
        return new BootableEnvironment(jbossHome, BootableEnvironment.init(jbossHome, propertyUpdater), propertyUpdater);
    }

    Path getJBossHome() {
        return this.jbossHome;
    }

    Path getPidFile() {
        return BootableEnvironment.resolvePath(this.jbossHome, this.pidFileName, new String[0]);
    }

    long getTimeout() {
        return this.timeout;
    }

    boolean isWindows() {
        return IS_WINDOWS;
    }

    Path resolveConfigurationDir(String ... paths) {
        return BootableEnvironment.resolvePath(this.serverDir, "configuration", paths);
    }

    Path resolveContentDir(String ... paths) {
        return BootableEnvironment.resolvePath(this.resolveDataDir(new String[0]), "content", paths);
    }

    Path resolveDataDir(String ... paths) {
        return BootableEnvironment.resolvePath(this.serverDir, "data", paths);
    }

    Path resolveLogDir(String ... paths) {
        return BootableEnvironment.resolvePath(this.serverDir, "log", paths);
    }

    void setSystemProperties(Map<String, String> properties) {
        HashMap<String, String> local = new HashMap<String, String>(properties);
        String debugValue = (String)local.remove("org.wildfly.core.jar.debug");
        if (debugValue != null) {
            DEBUG.set(debugValue.isEmpty() || "true".equalsIgnoreCase(debugValue));
        }
        for (Map.Entry entry : local.entrySet()) {
            this.setSystemProperty((String)entry.getKey(), (String)entry.getValue());
        }
    }

    void setSystemProperty(String key, String value) {
        if (this.ignoredProperties.contains(key)) {
            BootableEnvironment.logDebug("Ignoring system property %s.", key);
        } else {
            this.propertyUpdater.setProperty(key, value);
        }
    }

    private static Collection<String> init(Path jbossHome, PropertyUpdater propertyUpdater) {
        ArrayList<String> propertyNames = new ArrayList<String>();
        propertyNames.add("java.ext.dirs");
        propertyNames.add("java.home");
        propertyNames.add("java.io.tmpdir");
        propertyNames.add("jboss.server.persist.config");
        propertyNames.add("jboss.server.management.uuid");
        propertyNames.add("modules.path");
        propertyNames.add("user.dir");
        propertyNames.add("user.home");
        BootableEnvironment.setSystemProperty(propertyUpdater, "jboss.home.dir", jbossHome, propertyNames);
        Path serverBaseDir = BootableEnvironment.resolvePath(jbossHome, "standalone", new String[0]);
        BootableEnvironment.setSystemProperty(propertyUpdater, "jboss.server.base.dir", serverBaseDir, propertyNames);
        BootableEnvironment.setSystemProperty(propertyUpdater, "jboss.controller.temp.dir", BootableEnvironment.resolvePath(serverBaseDir, "tmp", new String[0]), propertyNames);
        Path dataDir = BootableEnvironment.resolvePath(serverBaseDir, "data", new String[0]);
        BootableEnvironment.setSystemProperty(propertyUpdater, "jboss.server.data.dir", dataDir, propertyNames);
        BootableEnvironment.setSystemProperty(propertyUpdater, "jboss.server.config.dir", BootableEnvironment.resolvePath(serverBaseDir, "configuration", new String[0]), propertyNames);
        BootableEnvironment.setSystemProperty(propertyUpdater, "jboss.server.deploy.dir", BootableEnvironment.resolvePath(dataDir, "content", new String[0]), propertyNames);
        BootableEnvironment.setSystemProperty(propertyUpdater, "jboss.server.log.dir", BootableEnvironment.resolvePath(serverBaseDir, "log", new String[0]), propertyNames);
        BootableEnvironment.setSystemProperty(propertyUpdater, "jboss.server.temp.dir", BootableEnvironment.resolvePath(serverBaseDir, "tmp", new String[0]), propertyNames);
        return propertyNames;
    }

    private static Path resolvePath(Path base, String path1, String ... paths) {
        Path result = base.resolve(path1);
        for (String path : paths) {
            result = result.resolve(path);
        }
        return result.toAbsolutePath().normalize();
    }

    private static void setSystemProperty(PropertyUpdater propertyUpdater, String key, Path path, Collection<String> names) {
        names.add(key);
        String previousValue = propertyUpdater.setProperty(key, path.toString());
        if (previousValue == null) {
            BootableEnvironment.logDebug("Setting system property %s to %s", key, path);
        } else {
            BootableEnvironment.logDebug("Replacing system property %s with a value of %s. The previous value was %s.", key, path, previousValue);
        }
    }

    static void logDebug(String format, Object ... args) {
        if (DEBUG.get()) {
            System.out.printf("[DEBUG] " + format, args);
        }
    }
}

