/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.config.federation;

import java.util.HashMap;
import java.util.Objects;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.config.federation.FederationStreamConfiguration;

public class FederationDownstreamConfiguration
extends FederationStreamConfiguration<FederationDownstreamConfiguration> {
    private String upstreamConfigurationRef;
    private TransportConfiguration upstreamConfiguration;

    public String getUpstreamConfigurationRef() {
        return this.upstreamConfigurationRef;
    }

    public void setUpstreamConfigurationRef(String upstreamConfigurationRef) {
        this.upstreamConfigurationRef = upstreamConfigurationRef;
    }

    public TransportConfiguration getUpstreamConfiguration() {
        return this.upstreamConfiguration;
    }

    public void setUpstreamConfiguration(TransportConfiguration transportConfiguration) {
        HashMap<String, Object> params = new HashMap<String, Object>(transportConfiguration.getParams());
        params.remove("sslEnabled");
        params.remove("sslProvider");
        params.remove("sslKrb5Config");
        params.remove("keyStorePath");
        params.remove("keyStorePassword");
        params.remove("keyStoreProvider");
        params.remove("trustStorePath");
        params.remove("trustStorePassword");
        params.remove("trustStoreProvider");
        this.upstreamConfiguration = new TransportConfiguration(transportConfiguration.getFactoryClassName(), params, transportConfiguration.getName(), transportConfiguration.getExtraParams());
    }

    @Override
    public void encode(ActiveMQBuffer buffer) {
        super.encode(buffer);
        this.upstreamConfiguration.encode(buffer);
    }

    @Override
    public void decode(ActiveMQBuffer buffer) {
        super.decode(buffer);
        this.upstreamConfiguration = new TransportConfiguration();
        this.upstreamConfiguration.decode(buffer);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FederationDownstreamConfiguration that = (FederationDownstreamConfiguration)o;
        return Objects.equals(this.upstreamConfigurationRef, that.upstreamConfigurationRef) && Objects.equals(this.upstreamConfiguration, that.upstreamConfiguration);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.upstreamConfigurationRef, this.upstreamConfiguration);
    }
}

