/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.irac;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.irac.IracUpdateKeyCommand;
import org.infinispan.metadata.impl.IracMetadata;
import org.infinispan.util.ByteString;
import org.infinispan.xsite.BackupReceiver;

public class IracRemoveKeyCommand
extends IracUpdateKeyCommand {
    public static final byte COMMAND_ID = 15;
    private Object key;
    private IracMetadata iracMetadata;

    public IracRemoveKeyCommand() {
        super((byte)15, null);
    }

    public IracRemoveKeyCommand(ByteString cacheName) {
        super((byte)15, cacheName);
    }

    public IracRemoveKeyCommand(ByteString cacheName, Object key, IracMetadata iracMetadata) {
        super((byte)15, cacheName);
        this.key = key;
        this.iracMetadata = iracMetadata;
    }

    @Override
    public CompletionStage<Void> executeOperation(BackupReceiver receiver) {
        return receiver.removeKey(this.key, this.iracMetadata);
    }

    @Override
    public byte getCommandId() {
        return 15;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeObject(this.key);
        this.iracMetadata.writeTo(output);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.key = input.readObject();
        this.iracMetadata = IracMetadata.readFrom(input);
    }

    @Override
    public IracRemoveKeyCommand copyForCacheName(ByteString cacheName) {
        IracRemoveKeyCommand command = new IracRemoveKeyCommand(cacheName);
        command.key = this.key;
        command.iracMetadata = this.iracMetadata;
        return command;
    }

    @Override
    public Object getKey() {
        return this.key;
    }

    @Override
    public String toString() {
        return "IracRemoveKeyCommand{key=" + this.key + ", iracMetadata=" + this.iracMetadata + ", originSite='" + this.originSite + '\'' + ", cacheName=" + this.cacheName + '}';
    }
}

