/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ejb3.logging.EjbLogger;

public class EjbJarDescription {
    private final EEModuleDescription eeModuleDescription;
    private final Set<String> applicationLevelSecurityRoles = new HashSet<String>();
    private final boolean war;

    public EjbJarDescription(EEModuleDescription eeModuleDescription, boolean war) {
        this.war = war;
        if (eeModuleDescription == null) {
            throw EjbLogger.ROOT_LOGGER.paramCannotBeNull("EE module description");
        }
        this.eeModuleDescription = eeModuleDescription;
    }

    public void addSecurityRole(String role) {
        if (role == null || role.trim().isEmpty()) {
            throw EjbLogger.ROOT_LOGGER.stringParamCannotBeNullOrEmpty("Security role");
        }
        this.applicationLevelSecurityRoles.add(role);
    }

    public Set<String> getSecurityRoles() {
        return Collections.unmodifiableSet(this.applicationLevelSecurityRoles);
    }

    public boolean hasComponent(String componentName) {
        return this.eeModuleDescription.hasComponent(componentName);
    }

    public EEModuleDescription getEEModuleDescription() {
        return this.eeModuleDescription;
    }

    public boolean isWar() {
        return this.war;
    }
}

