/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.ServiceLoader;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.protostream.config.Configuration;
import org.infinispan.protostream.impl.SerializationContextImpl;
import org.wildfly.clustering.marshalling.protostream.ClassResolver;
import org.wildfly.clustering.marshalling.protostream.DefaultSerializationContextInitializer;
import org.wildfly.clustering.marshalling.protostream.LangSerializationContextInitializer;
import org.wildfly.security.manager.WildFlySecurityManager;

public class SerializationContextBuilder {
    private final SerializationContext context = new SerializationContextImpl(Configuration.builder().build());

    public SerializationContextBuilder(ClassResolver resolver) {
        this.register(Collections.singleton(new LangSerializationContextInitializer(resolver)));
        this.register(EnumSet.allOf(DefaultSerializationContextInitializer.class));
    }

    public ImmutableSerializationContext build() {
        return this.context;
    }

    public SerializationContextBuilder register(SerializationContextInitializer initializer) {
        this.init(initializer);
        return this;
    }

    public SerializationContextBuilder register(SerializationContextInitializer ... initializers) {
        return this.register(Arrays.asList(initializers));
    }

    public SerializationContextBuilder register(Iterable<? extends SerializationContextInitializer> initializers) {
        this.init(initializers.iterator());
        return this;
    }

    public SerializationContextBuilder load(ClassLoader loader) {
        this.tryLoad(loader);
        return this;
    }

    public SerializationContextBuilder require(ClassLoader loader) {
        if (!this.tryLoad(loader)) {
            throw new NoSuchElementException();
        }
        return this;
    }

    private boolean tryLoad(final ClassLoader loader) {
        PrivilegedAction<Boolean> action = new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                Iterator<SerializationContextInitializer> initializers = ServiceLoader.load(SerializationContextInitializer.class, loader).iterator();
                boolean init = initializers.hasNext();
                SerializationContextBuilder.this.init(initializers);
                return init;
            }
        };
        return (Boolean)WildFlySecurityManager.doUnchecked((PrivilegedAction)action);
    }

    void init(Iterator<? extends SerializationContextInitializer> initializers) {
        while (initializers.hasNext()) {
            this.init(initializers.next());
        }
    }

    private void init(SerializationContextInitializer initializer) {
        initializer.registerSchema(this.context);
        initializer.registerMarshallers(this.context);
    }
}

