/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.federation.service;

import java.util.ArrayList;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.picketlink.config.federation.AuthPropertyType;
import org.picketlink.config.federation.KeyProviderType;
import org.picketlink.config.federation.KeyValueType;
import org.wildfly.extension.picketlink.federation.service.FederationService;

public class KeyStoreProviderService
implements Service<KeyStoreProviderService> {
    private static final String SERVICE_NAME = "KeyStoreProviderService";
    private volatile KeyProviderType keyProviderType;
    private final InjectedValue<FederationService> federationService = new InjectedValue();
    private volatile String relativeTo;
    private volatile String filePath;
    private final InjectedValue<PathManager> pathManager = new InjectedValue();

    public KeyStoreProviderService(KeyProviderType keyProviderType, String filePath, String relativeTo) {
        this.keyProviderType = keyProviderType;
        this.filePath = filePath;
        this.relativeTo = relativeTo;
    }

    public static ServiceName createServiceName(String alias) {
        return ServiceName.JBOSS.append(new String[]{"picketlink-federation", SERVICE_NAME, alias});
    }

    public KeyStoreProviderService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public void start(StartContext context) throws StartException {
        this.setKeyProviderType(this.keyProviderType, this.filePath, this.relativeTo);
    }

    public void stop(StopContext context) {
        this.setKeyProviderType(null, null, null);
        context.getController().setMode(ServiceController.Mode.REMOVE);
    }

    public InjectedValue<FederationService> getFederationService() {
        return this.federationService;
    }

    public InjectedValue<PathManager> getPathManager() {
        return this.pathManager;
    }

    private void configureKeyStoreFilePath() {
        if (this.keyProviderType != null) {
            String resolvedPath = this.relativeTo != null ? ((PathManager)this.getPathManager().getValue()).resolveRelativePathEntry(this.filePath, this.relativeTo) : this.filePath;
            AuthPropertyType keyStoreURL = new AuthPropertyType();
            keyStoreURL.setKey("KeyStoreURL");
            keyStoreURL.setValue(resolvedPath);
            this.keyProviderType.add(keyStoreURL);
        }
    }

    public void removeKey(String key) {
        for (KeyValueType keyValueType : new ArrayList(this.keyProviderType.getValidatingAlias())) {
            if (keyValueType.getValue() == null || !keyValueType.getValue().equals(key)) continue;
            this.keyProviderType.remove(keyValueType);
        }
    }

    public void addKey(String key, String validatingHost) {
        String[] hosts;
        this.removeKey(key);
        for (String host : hosts = validatingHost.split(",")) {
            KeyValueType kv = new KeyValueType();
            kv.setKey(host.trim());
            kv.setValue(key.trim());
            this.keyProviderType.add(kv);
        }
    }

    public void setKeyProviderType(KeyProviderType keyProviderType, String file, String relativeTo) {
        if (keyProviderType != null) {
            for (KeyValueType kv : this.keyProviderType.getValidatingAlias()) {
                keyProviderType.add(kv);
            }
        }
        this.filePath = file;
        this.relativeTo = relativeTo;
        this.keyProviderType = keyProviderType;
        this.configureKeyStoreFilePath();
        ((FederationService)this.getFederationService().getValue()).setKeyProviderType(this.keyProviderType);
    }
}

