/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.jboss.as.domain.http.server.logging.HttpServerLogger;
import org.jboss.as.protocol.mgmt.support.ManagementChannelShutdownHandle;

public class ManagementHttpRequestProcessor
implements ManagementChannelShutdownHandle {
    private volatile int state;
    private final List<ShutdownListener> listeners = new ArrayList<ShutdownListener>();
    private static final int CLOSED = Integer.MIN_VALUE;
    private volatile CountDownLatch latch = new CountDownLatch(1);
    private static final AtomicIntegerFieldUpdater<ManagementHttpRequestProcessor> stateUpdater = AtomicIntegerFieldUpdater.newUpdater(ManagementHttpRequestProcessor.class, "state");

    public void shutdown() {
        this.prepareShutdown();
    }

    public void shutdownNow() {
        this.prepareShutdown();
    }

    public boolean awaitCompletion(long timeout, TimeUnit unit) throws InterruptedException {
        boolean completed = this.latch.await(timeout, unit);
        if (!completed) {
            HttpServerLogger.ROOT_LOGGER.debugf("ShutdownListener(s) %s have not completed within %d %s", this.listeners, timeout, (Object)unit);
        }
        return completed;
    }

    void prepareShutdown() {
        int newState;
        int oldState;
        do {
            if (((oldState = this.state) & Integer.MIN_VALUE) == 0) continue;
            return;
        } while (!stateUpdater.compareAndSet(this, oldState, newState = oldState | Integer.MIN_VALUE));
        if (newState == Integer.MIN_VALUE) {
            this.handleCompleted();
        }
    }

    public synchronized void addShutdownListener(ShutdownListener listener) {
        if (this.state == Integer.MIN_VALUE) {
            listener.handleCompleted();
        } else {
            this.listeners.add(listener);
        }
    }

    protected synchronized void handleCompleted() {
        this.latch.countDown();
        for (ShutdownListener listener : this.listeners) {
            listener.handleCompleted();
        }
        this.listeners.clear();
    }

    protected boolean beginRequest() {
        int newState;
        int oldState;
        do {
            if (((oldState = this.state) & Integer.MIN_VALUE) != 0) {
                return false;
            }
            newState = oldState + 1;
            if (newState != Integer.MAX_VALUE) continue;
            return false;
        } while (!stateUpdater.compareAndSet(this, oldState, newState));
        return true;
    }

    protected void endRequest() {
        int newState;
        int oldState;
        while (!stateUpdater.compareAndSet(this, oldState = this.state, newState = oldState - 1)) {
        }
        if (newState == Integer.MIN_VALUE) {
            this.handleCompleted();
        }
    }

    public static interface ShutdownListener {
        public void handleCompleted();
    }
}

