/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.resourceadapters;

import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.connector.metadata.api.resourceadapter.WorkManagerSecurity;
import org.jboss.as.connector.subsystems.resourceadapters.Constants;
import org.jboss.as.connector.subsystems.resourceadapters.Element;
import org.jboss.as.connector.subsystems.resourceadapters.Namespace;
import org.jboss.as.connector.subsystems.resourceadapters.ResourceAdapterParser;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.jca.common.api.metadata.common.Capacity;
import org.jboss.jca.common.api.metadata.common.Extension;
import org.jboss.jca.common.api.metadata.common.Pool;
import org.jboss.jca.common.api.metadata.common.Recovery;
import org.jboss.jca.common.api.metadata.common.TransactionSupportEnum;
import org.jboss.jca.common.api.metadata.resourceadapter.Activation;
import org.jboss.jca.common.api.metadata.resourceadapter.Activations;
import org.jboss.jca.common.api.metadata.resourceadapter.ConnectionDefinition;
import org.jboss.jca.common.api.metadata.resourceadapter.WorkManager;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public final class ResourceAdapterSubsystemParser
implements XMLStreamConstants,
XMLElementReader<List<ModelNode>>,
XMLElementWriter<SubsystemMarshallingContext> {
    static final ResourceAdapterSubsystemParser INSTANCE = new ResourceAdapterSubsystemParser();

    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        ModelNode node = context.getModelNode();
        boolean hasChildren = node.hasDefined("resource-adapter") && node.get("resource-adapter").asPropertyList().size() > 0;
        context.startSubsystemElement(Namespace.CURRENT.getUriString(), !hasChildren);
        if (hasChildren) {
            writer.writeStartElement(Element.RESOURCE_ADAPTERS.getLocalName());
            ModelNode ras = node.get("resource-adapter");
            for (String name : ras.keys()) {
                ModelNode ra = ras.get(name);
                this.writeRaElement(writer, ra, name);
            }
            writer.writeEndElement();
            writer.writeEndElement();
        }
    }

    private void writeRaElement(XMLExtendedStreamWriter streamWriter, ModelNode ra, String name) throws XMLStreamException {
        streamWriter.writeStartElement(Activations.Tag.RESOURCE_ADAPTER.getLocalName());
        streamWriter.writeAttribute(ResourceAdapterParser.Attribute.ID.getLocalName(), name);
        Constants.STATISTICS_ENABLED.marshallAsAttribute(ra, (XMLStreamWriter)streamWriter);
        Constants.ARCHIVE.marshallAsElement(ra, (XMLStreamWriter)streamWriter);
        Constants.MODULE.marshallAsElement(ra, (XMLStreamWriter)streamWriter);
        Constants.BOOTSTRAP_CONTEXT.marshallAsElement(ra, (XMLStreamWriter)streamWriter);
        if (ra.hasDefined(Constants.BEANVALIDATION_GROUPS.getName())) {
            streamWriter.writeStartElement(Activation.Tag.BEAN_VALIDATION_GROUPS.getLocalName());
            for (ModelNode bvg : ra.get(Constants.BEANVALIDATION_GROUPS.getName()).asList()) {
                streamWriter.writeStartElement(Constants.BEANVALIDATION_GROUPS.getXmlName());
                streamWriter.writeCharacters(bvg.asString());
                streamWriter.writeEndElement();
            }
            streamWriter.writeEndElement();
        }
        Constants.TRANSACTION_SUPPORT.marshallAsElement(ra, (XMLStreamWriter)streamWriter);
        this.writeNewConfigProperties(streamWriter, ra);
        TransactionSupportEnum transactionSupport = ra.hasDefined(Constants.TRANSACTION_SUPPORT.getName()) ? TransactionSupportEnum.valueOf((String)ra.get(Constants.TRANSACTION_SUPPORT.getName()).asString()) : null;
        boolean isXa = false;
        if (transactionSupport == TransactionSupportEnum.XATransaction) {
            isXa = true;
        }
        if (ra.hasDefined(Constants.WM_SECURITY.getName()) && ra.get(Constants.WM_SECURITY.getName()).asBoolean()) {
            streamWriter.writeStartElement(Activation.Tag.WORKMANAGER.getLocalName());
            streamWriter.writeStartElement(WorkManager.Tag.SECURITY.getLocalName());
            Constants.WM_SECURITY_MAPPING_REQUIRED.marshallAsElement(ra, (XMLStreamWriter)streamWriter);
            Constants.WM_SECURITY_DOMAIN.marshallAsElement(ra, (XMLStreamWriter)streamWriter);
            Constants.WM_ELYTRON_SECURITY_DOMAIN.marshallAsElement(ra, (XMLStreamWriter)streamWriter);
            Constants.WM_SECURITY_DEFAULT_PRINCIPAL.marshallAsElement(ra, (XMLStreamWriter)streamWriter);
            if (ra.hasDefined(Constants.WM_SECURITY_DEFAULT_GROUPS.getName())) {
                streamWriter.writeStartElement(Constants.WM_SECURITY_DEFAULT_GROUPS.getXmlName());
                for (ModelNode group : ra.get(Constants.WM_SECURITY_DEFAULT_GROUPS.getName()).asList()) {
                    streamWriter.writeStartElement(Constants.WM_SECURITY_DEFAULT_GROUP.getXmlName());
                    streamWriter.writeCharacters(group.asString());
                    streamWriter.writeEndElement();
                }
                streamWriter.writeEndElement();
            }
            if (ra.hasDefined(Constants.WM_SECURITY_MAPPING_USERS.getName()) || ra.hasDefined(Constants.WM_SECURITY_MAPPING_GROUPS.getName())) {
                streamWriter.writeStartElement(WorkManagerSecurity.Tag.MAPPINGS.getLocalName());
                if (ra.hasDefined(Constants.WM_SECURITY_MAPPING_USERS.getName())) {
                    streamWriter.writeStartElement(WorkManagerSecurity.Tag.USERS.getLocalName());
                    for (ModelNode node : ra.get(Constants.WM_SECURITY_MAPPING_USERS.getName()).asList()) {
                        streamWriter.writeStartElement(WorkManagerSecurity.Tag.MAP.getLocalName());
                        Constants.WM_SECURITY_MAPPING_FROM.marshallAsAttribute(node, (XMLStreamWriter)streamWriter);
                        Constants.WM_SECURITY_MAPPING_TO.marshallAsAttribute(node, (XMLStreamWriter)streamWriter);
                        streamWriter.writeEndElement();
                    }
                    streamWriter.writeEndElement();
                }
                if (ra.hasDefined(Constants.WM_SECURITY_MAPPING_GROUPS.getName())) {
                    streamWriter.writeStartElement(WorkManagerSecurity.Tag.GROUPS.getLocalName());
                    for (ModelNode node : ra.get(Constants.WM_SECURITY_MAPPING_GROUPS.getName()).asList()) {
                        streamWriter.writeStartElement(WorkManagerSecurity.Tag.MAP.getLocalName());
                        Constants.WM_SECURITY_MAPPING_FROM.marshallAsAttribute(node, (XMLStreamWriter)streamWriter);
                        Constants.WM_SECURITY_MAPPING_TO.marshallAsAttribute(node, (XMLStreamWriter)streamWriter);
                        streamWriter.writeEndElement();
                    }
                    streamWriter.writeEndElement();
                }
                streamWriter.writeEndElement();
            }
            streamWriter.writeEndElement();
            streamWriter.writeEndElement();
        }
        if (ra.hasDefined("connection-definitions")) {
            streamWriter.writeStartElement(Activation.Tag.CONNECTION_DEFINITIONS.getLocalName());
            for (Property conDef : ra.get("connection-definitions").asPropertyList()) {
                this.writeConDef(streamWriter, conDef.getValue(), conDef.getName(), isXa);
            }
            streamWriter.writeEndElement();
        }
        if (ra.hasDefined("admin-objects")) {
            streamWriter.writeStartElement(Activation.Tag.ADMIN_OBJECTS.getLocalName());
            for (Property adminObject : ra.get("admin-objects").asPropertyList()) {
                this.writeAdminObject(streamWriter, adminObject.getValue(), adminObject.getName());
            }
            streamWriter.writeEndElement();
        }
        streamWriter.writeEndElement();
    }

    private void writeNewConfigProperties(XMLExtendedStreamWriter streamWriter, ModelNode ra) throws XMLStreamException {
        if (ra.hasDefined(Constants.CONFIG_PROPERTIES.getName())) {
            for (Property connectionProperty : ra.get(Constants.CONFIG_PROPERTIES.getName()).asPropertyList()) {
                this.writeProperty(streamWriter, ra, connectionProperty.getName(), connectionProperty.getValue().get("value").asString(), Activation.Tag.CONFIG_PROPERTY.getLocalName());
            }
        }
    }

    private void writeProperty(XMLExtendedStreamWriter writer, ModelNode node, String name, String value, String localName) throws XMLStreamException {
        writer.writeStartElement(localName);
        writer.writeAttribute("name", name);
        if (value.indexOf(10) > -1) {
            writer.writeCharacters(value);
        } else {
            char[] chars = value.toCharArray();
            writer.writeCharacters(chars, 0, chars.length);
        }
        writer.writeEndElement();
    }

    private void writeAdminObject(XMLExtendedStreamWriter streamWriter, ModelNode adminObject, String poolName) throws XMLStreamException {
        streamWriter.writeStartElement(Activation.Tag.ADMIN_OBJECT.getLocalName());
        Constants.CLASS_NAME.marshallAsAttribute(adminObject, (XMLStreamWriter)streamWriter);
        Constants.JNDINAME.marshallAsAttribute(adminObject, (XMLStreamWriter)streamWriter);
        Constants.ENABLED.marshallAsAttribute(adminObject, (XMLStreamWriter)streamWriter);
        Constants.USE_JAVA_CONTEXT.marshallAsAttribute(adminObject, (XMLStreamWriter)streamWriter);
        streamWriter.writeAttribute("pool-name", poolName);
        this.writeNewConfigProperties(streamWriter, adminObject);
        streamWriter.writeEndElement();
    }

    private void writeConDef(XMLExtendedStreamWriter streamWriter, ModelNode conDef, String poolName, boolean isXa) throws XMLStreamException {
        streamWriter.writeStartElement(Activation.Tag.CONNECTION_DEFINITION.getLocalName());
        Constants.CLASS_NAME.marshallAsAttribute(conDef, (XMLStreamWriter)streamWriter);
        Constants.JNDINAME.marshallAsAttribute(conDef, (XMLStreamWriter)streamWriter);
        Constants.ENABLED.marshallAsAttribute(conDef, (XMLStreamWriter)streamWriter);
        Constants.CONNECTABLE.marshallAsAttribute(conDef, (XMLStreamWriter)streamWriter);
        Constants.TRACKING.marshallAsAttribute(conDef, (XMLStreamWriter)streamWriter);
        Constants.USE_JAVA_CONTEXT.marshallAsAttribute(conDef, (XMLStreamWriter)streamWriter);
        streamWriter.writeAttribute("pool-name", poolName);
        Constants.USE_CCM.marshallAsAttribute(conDef, (XMLStreamWriter)streamWriter);
        Constants.SHARABLE.marshallAsAttribute(conDef, (XMLStreamWriter)streamWriter);
        Constants.ENLISTMENT.marshallAsAttribute(conDef, (XMLStreamWriter)streamWriter);
        Constants.MCP.marshallAsAttribute(conDef, (XMLStreamWriter)streamWriter);
        Constants.ENLISTMENT_TRACE.marshallAsAttribute(conDef, (XMLStreamWriter)streamWriter);
        this.writeNewConfigProperties(streamWriter, conDef);
        boolean poolRequired = org.jboss.as.connector.subsystems.common.pool.Constants.INITIAL_POOL_SIZE.isMarshallable(conDef) || org.jboss.as.connector.subsystems.common.pool.Constants.MAX_POOL_SIZE.isMarshallable(conDef) || org.jboss.as.connector.subsystems.common.pool.Constants.MIN_POOL_SIZE.isMarshallable(conDef) || org.jboss.as.connector.subsystems.common.pool.Constants.POOL_USE_STRICT_MIN.isMarshallable(conDef) || org.jboss.as.connector.subsystems.common.pool.Constants.POOL_PREFILL.isMarshallable(conDef) || org.jboss.as.connector.subsystems.common.pool.Constants.POOL_FAIR.isMarshallable(conDef) || org.jboss.as.connector.subsystems.common.pool.Constants.POOL_FLUSH_STRATEGY.isMarshallable(conDef);
        boolean capacityRequired = org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_INCREMENTER_CLASS.isMarshallable(conDef) || org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_INCREMENTER_PROPERTIES.isMarshallable(conDef) || org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_DECREMENTER_CLASS.isMarshallable(conDef) || org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_DECREMENTER_PROPERTIES.isMarshallable(conDef);
        boolean bl = poolRequired = poolRequired || capacityRequired;
        if (poolRequired) {
            if (isXa) {
                streamWriter.writeStartElement(ConnectionDefinition.Tag.XA_POOL.getLocalName());
                org.jboss.as.connector.subsystems.common.pool.Constants.MIN_POOL_SIZE.marshallAsElement(conDef, (XMLStreamWriter)streamWriter);
                org.jboss.as.connector.subsystems.common.pool.Constants.INITIAL_POOL_SIZE.marshallAsElement(conDef, (XMLStreamWriter)streamWriter);
                org.jboss.as.connector.subsystems.common.pool.Constants.MAX_POOL_SIZE.marshallAsElement(conDef, (XMLStreamWriter)streamWriter);
                org.jboss.as.connector.subsystems.common.pool.Constants.POOL_PREFILL.marshallAsElement(conDef, (XMLStreamWriter)streamWriter);
                org.jboss.as.connector.subsystems.common.pool.Constants.POOL_FAIR.marshallAsElement(conDef, (XMLStreamWriter)streamWriter);
                org.jboss.as.connector.subsystems.common.pool.Constants.POOL_USE_STRICT_MIN.marshallAsElement(conDef, (XMLStreamWriter)streamWriter);
                org.jboss.as.connector.subsystems.common.pool.Constants.POOL_FLUSH_STRATEGY.marshallAsElement(conDef, (XMLStreamWriter)streamWriter);
                Constants.SAME_RM_OVERRIDE.marshallAsElement(conDef, (XMLStreamWriter)streamWriter);
                if (conDef.hasDefined(Constants.INTERLEAVING.getName()) && conDef.get(Constants.INTERLEAVING.getName()).asBoolean()) {
                    streamWriter.writeEmptyElement(Constants.INTERLEAVING.getXmlName());
                } else {
                    Constants.INTERLEAVING.marshallAsElement(conDef, (XMLStreamWriter)streamWriter);
                }
                if (conDef.hasDefined(Constants.NOTXSEPARATEPOOL.getName()) && conDef.get(Constants.NOTXSEPARATEPOOL.getName()).asBoolean()) {
                    streamWriter.writeEmptyElement(Constants.NOTXSEPARATEPOOL.getXmlName());
                } else {
                    Constants.NOTXSEPARATEPOOL.marshallAsElement(conDef, (XMLStreamWriter)streamWriter);
                }
                Constants.PAD_XID.marshallAsElement(conDef, (XMLStreamWriter)streamWriter);
                Constants.WRAP_XA_RESOURCE.marshallAsElement(conDef, (XMLStreamWriter)streamWriter);
            } else {
                streamWriter.writeStartElement(ConnectionDefinition.Tag.POOL.getLocalName());
                org.jboss.as.connector.subsystems.common.pool.Constants.MIN_POOL_SIZE.marshallAsElement(conDef, (XMLStreamWriter)streamWriter);
                org.jboss.as.connector.subsystems.common.pool.Constants.INITIAL_POOL_SIZE.marshallAsElement(conDef, (XMLStreamWriter)streamWriter);
                org.jboss.as.connector.subsystems.common.pool.Constants.MAX_POOL_SIZE.marshallAsElement(conDef, (XMLStreamWriter)streamWriter);
                org.jboss.as.connector.subsystems.common.pool.Constants.POOL_PREFILL.marshallAsElement(conDef, (XMLStreamWriter)streamWriter);
                org.jboss.as.connector.subsystems.common.pool.Constants.POOL_USE_STRICT_MIN.marshallAsElement(conDef, (XMLStreamWriter)streamWriter);
                org.jboss.as.connector.subsystems.common.pool.Constants.POOL_FLUSH_STRATEGY.marshallAsElement(conDef, (XMLStreamWriter)streamWriter);
            }
            if (capacityRequired) {
                streamWriter.writeStartElement(Pool.Tag.CAPACITY.getLocalName());
                if (conDef.hasDefined(org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_INCREMENTER_CLASS.getName())) {
                    streamWriter.writeStartElement(Capacity.Tag.INCREMENTER.getLocalName());
                    org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_INCREMENTER_CLASS.marshallAsAttribute(conDef, (XMLStreamWriter)streamWriter);
                    org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_INCREMENTER_PROPERTIES.marshallAsElement(conDef, (XMLStreamWriter)streamWriter);
                    streamWriter.writeEndElement();
                }
                if (conDef.hasDefined(org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_DECREMENTER_CLASS.getName())) {
                    streamWriter.writeStartElement(Capacity.Tag.DECREMENTER.getLocalName());
                    org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_DECREMENTER_CLASS.marshallAsAttribute(conDef, (XMLStreamWriter)streamWriter);
                    org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_DECREMENTER_PROPERTIES.marshallAsElement(conDef, (XMLStreamWriter)streamWriter);
                    streamWriter.writeEndElement();
                }
                streamWriter.writeEndElement();
            }
            streamWriter.writeEndElement();
        }
        if (conDef.hasDefined(Constants.APPLICATION.getName()) || conDef.hasDefined(Constants.SECURITY_DOMAIN.getName()) || conDef.hasDefined(Constants.SECURITY_DOMAIN_AND_APPLICATION.getName()) || conDef.hasDefined(Constants.ELYTRON_ENABLED.getName())) {
            streamWriter.writeStartElement(ConnectionDefinition.Tag.SECURITY.getLocalName());
            if (conDef.hasDefined(Constants.APPLICATION.getName()) && conDef.get(Constants.APPLICATION.getName()).getType().equals((Object)ModelType.BOOLEAN) && conDef.get(Constants.APPLICATION.getName()).asBoolean()) {
                streamWriter.writeEmptyElement(Constants.APPLICATION.getXmlName());
            } else {
                Constants.APPLICATION.marshallAsElement(conDef, (XMLStreamWriter)streamWriter);
            }
            Constants.SECURITY_DOMAIN.marshallAsElement(conDef, (XMLStreamWriter)streamWriter);
            Constants.SECURITY_DOMAIN_AND_APPLICATION.marshallAsElement(conDef, (XMLStreamWriter)streamWriter);
            Constants.ELYTRON_ENABLED.marshallAsElement(conDef, (XMLStreamWriter)streamWriter);
            Constants.AUTHENTICATION_CONTEXT.marshallAsElement(conDef, (XMLStreamWriter)streamWriter);
            Constants.AUTHENTICATION_CONTEXT_AND_APPLICATION.marshallAsElement(conDef, (XMLStreamWriter)streamWriter);
            streamWriter.writeEndElement();
        }
        if (conDef.hasDefined(org.jboss.as.connector.subsystems.common.pool.Constants.BLOCKING_TIMEOUT_WAIT_MILLIS.getName()) || conDef.hasDefined(org.jboss.as.connector.subsystems.common.pool.Constants.IDLETIMEOUTMINUTES.getName()) || conDef.hasDefined(Constants.ALLOCATION_RETRY.getName()) || conDef.hasDefined(Constants.ALLOCATION_RETRY_WAIT_MILLIS.getName()) || conDef.hasDefined(Constants.XA_RESOURCE_TIMEOUT.getName())) {
            streamWriter.writeStartElement(ConnectionDefinition.Tag.TIMEOUT.getLocalName());
            org.jboss.as.connector.subsystems.common.pool.Constants.BLOCKING_TIMEOUT_WAIT_MILLIS.marshallAsElement(conDef, (XMLStreamWriter)streamWriter);
            org.jboss.as.connector.subsystems.common.pool.Constants.IDLETIMEOUTMINUTES.marshallAsElement(conDef, (XMLStreamWriter)streamWriter);
            Constants.ALLOCATION_RETRY.marshallAsElement(conDef, (XMLStreamWriter)streamWriter);
            Constants.ALLOCATION_RETRY_WAIT_MILLIS.marshallAsElement(conDef, (XMLStreamWriter)streamWriter);
            Constants.XA_RESOURCE_TIMEOUT.marshallAsElement(conDef, (XMLStreamWriter)streamWriter);
            streamWriter.writeEndElement();
        }
        if (conDef.hasDefined(org.jboss.as.connector.subsystems.common.pool.Constants.BACKGROUNDVALIDATION.getName()) || conDef.hasDefined(org.jboss.as.connector.subsystems.common.pool.Constants.BACKGROUNDVALIDATIONMILLIS.getName()) || conDef.hasDefined(org.jboss.as.connector.subsystems.common.pool.Constants.USE_FAST_FAIL.getName()) || conDef.hasDefined(org.jboss.as.connector.subsystems.common.pool.Constants.VALIDATE_ON_MATCH.getName())) {
            streamWriter.writeStartElement(ConnectionDefinition.Tag.VALIDATION.getLocalName());
            org.jboss.as.connector.subsystems.common.pool.Constants.BACKGROUNDVALIDATION.marshallAsElement(conDef, (XMLStreamWriter)streamWriter);
            org.jboss.as.connector.subsystems.common.pool.Constants.BACKGROUNDVALIDATIONMILLIS.marshallAsElement(conDef, (XMLStreamWriter)streamWriter);
            org.jboss.as.connector.subsystems.common.pool.Constants.USE_FAST_FAIL.marshallAsElement(conDef, (XMLStreamWriter)streamWriter);
            org.jboss.as.connector.subsystems.common.pool.Constants.VALIDATE_ON_MATCH.marshallAsElement(conDef, (XMLStreamWriter)streamWriter);
            streamWriter.writeEndElement();
        }
        if (conDef.hasDefined(Constants.RECOVERY_USERNAME.getName()) || conDef.hasDefined(Constants.RECOVERY_PASSWORD.getName()) || conDef.hasDefined(Constants.RECOVERY_SECURITY_DOMAIN.getName()) || conDef.hasDefined(Constants.RECOVERLUGIN_CLASSNAME.getName()) || conDef.hasDefined(Constants.RECOVERLUGIN_PROPERTIES.getName()) || conDef.hasDefined(Constants.NO_RECOVERY.getName()) || conDef.hasDefined(Constants.ELYTRON_ENABLED.getName())) {
            streamWriter.writeStartElement(ConnectionDefinition.Tag.RECOVERY.getLocalName());
            Constants.NO_RECOVERY.marshallAsAttribute(conDef, (XMLStreamWriter)streamWriter);
            if (conDef.hasDefined(Constants.RECOVERY_USERNAME.getName()) || conDef.hasDefined(Constants.RECOVERY_PASSWORD.getName()) || conDef.hasDefined(Constants.RECOVERY_CREDENTIAL_REFERENCE.getName()) || conDef.hasDefined(Constants.RECOVERY_SECURITY_DOMAIN.getName()) || conDef.hasDefined(Constants.RECOVERY_ELYTRON_ENABLED.getName())) {
                streamWriter.writeStartElement(Recovery.Tag.RECOVER_CREDENTIAL.getLocalName());
                Constants.RECOVERY_USERNAME.marshallAsElement(conDef, (XMLStreamWriter)streamWriter);
                Constants.RECOVERY_PASSWORD.marshallAsElement(conDef, (XMLStreamWriter)streamWriter);
                Constants.RECOVERY_CREDENTIAL_REFERENCE.marshallAsElement(conDef, (XMLStreamWriter)streamWriter);
                Constants.RECOVERY_SECURITY_DOMAIN.marshallAsElement(conDef, (XMLStreamWriter)streamWriter);
                Constants.RECOVERY_ELYTRON_ENABLED.marshallAsElement(conDef, (XMLStreamWriter)streamWriter);
                Constants.RECOVERY_AUTHENTICATION_CONTEXT.marshallAsElement(conDef, (XMLStreamWriter)streamWriter);
                streamWriter.writeEndElement();
            }
            if (conDef.hasDefined(Constants.RECOVERLUGIN_CLASSNAME.getName()) || conDef.hasDefined(Constants.RECOVERLUGIN_PROPERTIES.getName())) {
                streamWriter.writeStartElement(Recovery.Tag.RECOVER_PLUGIN.getLocalName());
                Constants.RECOVERLUGIN_CLASSNAME.marshallAsAttribute(conDef, (XMLStreamWriter)streamWriter);
                if (conDef.hasDefined(Constants.RECOVERLUGIN_PROPERTIES.getName())) {
                    for (Property property : conDef.get(Constants.RECOVERLUGIN_PROPERTIES.getName()).asPropertyList()) {
                        this.writeProperty(streamWriter, conDef, property.getName(), property.getValue().asString(), Extension.Tag.CONFIG_PROPERTY.getLocalName());
                    }
                }
                streamWriter.writeEndElement();
            }
            streamWriter.writeEndElement();
        }
        streamWriter.writeEndElement();
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        ModelNode address = new ModelNode();
        address.add("subsystem", "resource-adapters");
        address.protect();
        ModelNode subsystem = new ModelNode();
        subsystem.get("operation").set("add");
        subsystem.get("address").set(address);
        list.add(subsystem);
        try {
            block1 : switch (Namespace.forUri(reader.getNamespaceURI())) {
                case RESOURCEADAPTERS_1_0: 
                case RESOURCEADAPTERS_1_1: 
                case RESOURCEADAPTERS_2_0: 
                case RESOURCEADAPTERS_3_0: 
                case RESOURCEADAPTERS_4_0: 
                case RESOURCEADAPTERS_5_0: 
                case RESOURCEADAPTERS_6_0: {
                    String localName = reader.getLocalName();
                    Element element = Element.forName(reader.getLocalName());
                    ConnectorLogger.SUBSYSTEM_RA_LOGGER.tracef("%s -> %s", localName, (Object)element);
                    switch (element) {
                        case SUBSYSTEM: {
                            ResourceAdapterParser parser = new ResourceAdapterParser();
                            parser.parse(reader, list, address);
                            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                            break block1;
                        }
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            throw new XMLStreamException(e);
        }
    }
}

