/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.metrics;

import java.io.Closeable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.wildfly.extension.metrics.Metric;
import org.wildfly.extension.metrics.MetricID;
import org.wildfly.extension.metrics.MetricMetadata;
import org.wildfly.extension.metrics.MetricRegistry;

public class WildFlyMetricRegistry
implements Closeable,
MetricRegistry {
    private Map<String, MetricMetadata> metadataMap = new HashMap<String, MetricMetadata>();
    private Map<MetricID, Metric> metricMap = new TreeMap<MetricID, Metric>();

    @Override
    public void close() {
        this.metricMap.clear();
        this.metadataMap.clear();
    }

    Map<MetricID, Metric> getMetrics() {
        return this.metricMap;
    }

    Map<String, MetricMetadata> getMetricMetadata() {
        return this.metadataMap;
    }

    @Override
    public synchronized void registerMetric(Metric metric, MetricMetadata metadata) {
        Objects.requireNonNull(metadata);
        Objects.requireNonNull(metric);
        MetricID metricID = metadata.getMetricID();
        if (!this.metadataMap.containsKey(metadata.getMetricName())) {
            this.metadataMap.put(metadata.getMetricName(), metadata);
        }
        this.metricMap.put(metricID, metric);
    }

    @Override
    public void unregister(MetricID metricID) {
        this.metricMap.remove(metricID);
    }
}

