/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.infinispan.spi;

import java.util.EnumSet;
import java.util.concurrent.CompletableFuture;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.SurvivesRestarts;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.globalstate.GlobalConfigurationManager;
import org.infinispan.manager.EmbeddedCacheManager;

@Scope(value=Scopes.GLOBAL)
@SurvivesRestarts
public class LocalGlobalConfigurationManager
implements GlobalConfigurationManager {
    @Inject
    EmbeddedCacheManager manager;

    public CompletableFuture<Configuration> createCache(String cacheName, Configuration configuration, EnumSet<CacheContainerAdmin.AdminFlag> flags) {
        return CompletableFuture.completedFuture(this.manager.defineConfiguration(cacheName, configuration));
    }

    public CompletableFuture<Configuration> getOrCreateCache(String cacheName, Configuration configuration, EnumSet<CacheContainerAdmin.AdminFlag> flags) {
        Configuration existing = this.manager.getCacheConfiguration(cacheName);
        return CompletableFuture.completedFuture(existing == null ? this.manager.defineConfiguration(cacheName, configuration) : existing);
    }

    public CompletableFuture<Configuration> createCache(String cacheName, String template, EnumSet<CacheContainerAdmin.AdminFlag> flags) {
        Configuration config = this.manager.getCacheConfiguration(template);
        return CompletableFuture.completedFuture(this.manager.defineConfiguration(cacheName, config));
    }

    public CompletableFuture<Configuration> getOrCreateCache(String cacheName, String template, EnumSet<CacheContainerAdmin.AdminFlag> flags) {
        Configuration config = this.manager.getCacheConfiguration(template);
        return CompletableFuture.completedFuture(config == null ? this.manager.defineConfiguration(cacheName, config) : config);
    }

    public CompletableFuture<Void> removeCache(String cacheName, EnumSet<CacheContainerAdmin.AdminFlag> flags) {
        this.manager.undefineConfiguration(cacheName);
        return CompletableFuture.completedFuture(null);
    }
}

