/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.server.ConnectorStatistics;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.undertow.ListenerResourceDefinition;
import org.wildfly.extension.undertow.ListenerService;
import org.wildfly.extension.undertow.UndertowExtension;

public class ResetConnectorStatisticsHandler
implements OperationStepHandler {
    public static final String OPERATION_NAME = "reset-statistics";
    public static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("reset-statistics", (ResourceDescriptionResolver)UndertowExtension.getResolver("listener")).setRuntimeOnly().build();
    public static final ResetConnectorStatisticsHandler INSTANCE = new ResetConnectorStatisticsHandler();

    private ResetConnectorStatisticsHandler() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ConnectorStatistics stats;
        ListenerService service = ListenerResourceDefinition.getListenerService(context);
        if (service != null && (stats = service.getOpenListener().getConnectorStatistics()) != null) {
            stats.reset();
        }
        context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
    }
}

