/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.spi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Priority;
import javax.ws.rs.ConstrainedTo;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.client.RxInvoker;
import javax.ws.rs.client.RxInvokerProvider;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Configurable;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Feature;
import javax.ws.rs.core.FeatureContext;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.core.Variant;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;
import javax.ws.rs.ext.Providers;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.RuntimeDelegate;
import javax.ws.rs.ext.WriterInterceptor;
import org.jboss.resteasy.annotations.interception.ClientInterceptor;
import org.jboss.resteasy.annotations.interception.ServerInterceptor;
import org.jboss.resteasy.client.core.ClientErrorInterceptor;
import org.jboss.resteasy.client.exception.mapper.ClientExceptionMapper;
import org.jboss.resteasy.core.Dispatcher;
import org.jboss.resteasy.core.InjectorFactoryImpl;
import org.jboss.resteasy.core.MediaTypeMap;
import org.jboss.resteasy.core.interception.ClientResponseFilterRegistry;
import org.jboss.resteasy.core.interception.ContainerRequestFilterRegistry;
import org.jboss.resteasy.core.interception.ContainerResponseFilterRegistry;
import org.jboss.resteasy.core.interception.InterceptorRegistry;
import org.jboss.resteasy.core.interception.JaxrsInterceptorRegistry;
import org.jboss.resteasy.core.interception.LegacyPrecedence;
import org.jboss.resteasy.core.interception.ReaderInterceptorRegistry;
import org.jboss.resteasy.core.interception.WriterInterceptorRegistry;
import org.jboss.resteasy.core.interception.jaxrs.ClientRequestFilterRegistry;
import org.jboss.resteasy.plugins.delegates.CacheControlDelegate;
import org.jboss.resteasy.plugins.delegates.CookieHeaderDelegate;
import org.jboss.resteasy.plugins.delegates.DateDelegate;
import org.jboss.resteasy.plugins.delegates.EntityTagDelegate;
import org.jboss.resteasy.plugins.delegates.LinkDelegate;
import org.jboss.resteasy.plugins.delegates.LinkHeaderDelegate;
import org.jboss.resteasy.plugins.delegates.LocaleDelegate;
import org.jboss.resteasy.plugins.delegates.MediaTypeHeaderDelegate;
import org.jboss.resteasy.plugins.delegates.NewCookieHeaderDelegate;
import org.jboss.resteasy.plugins.delegates.UriHeaderDelegate;
import org.jboss.resteasy.plugins.providers.RegisterBuiltin;
import org.jboss.resteasy.plugins.server.resourcefactory.SingletonResource;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.specimpl.LinkBuilderImpl;
import org.jboss.resteasy.specimpl.ResponseBuilderImpl;
import org.jboss.resteasy.specimpl.ResteasyUriBuilder;
import org.jboss.resteasy.specimpl.VariantListBuilderImpl;
import org.jboss.resteasy.spi.AsyncClientResponseProvider;
import org.jboss.resteasy.spi.AsyncResponseProvider;
import org.jboss.resteasy.spi.AsyncStreamProvider;
import org.jboss.resteasy.spi.BadRequestException;
import org.jboss.resteasy.spi.ConstructorInjector;
import org.jboss.resteasy.spi.HeaderValueProcessor;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.InjectorFactory;
import org.jboss.resteasy.spi.LinkHeader;
import org.jboss.resteasy.spi.PropertyInjector;
import org.jboss.resteasy.spi.StringConverter;
import org.jboss.resteasy.spi.StringParameterUnmarshaller;
import org.jboss.resteasy.spi.interception.ClientExecutionInterceptor;
import org.jboss.resteasy.spi.interception.MessageBodyReaderInterceptor;
import org.jboss.resteasy.spi.interception.MessageBodyWriterInterceptor;
import org.jboss.resteasy.spi.interception.PostProcessInterceptor;
import org.jboss.resteasy.spi.interception.PreProcessInterceptor;
import org.jboss.resteasy.spi.metadata.ResourceBuilder;
import org.jboss.resteasy.spi.metadata.ResourceClassProcessor;
import org.jboss.resteasy.spi.statistics.StatisticsController;
import org.jboss.resteasy.statistics.StatisticsControllerImpl;
import org.jboss.resteasy.util.FeatureContextDelegate;
import org.jboss.resteasy.util.PickConstructor;
import org.jboss.resteasy.util.ThreadLocalStack;
import org.jboss.resteasy.util.Types;

public class ResteasyProviderFactory
extends RuntimeDelegate
implements Providers,
HeaderValueProcessor,
Configurable<ResteasyProviderFactory>,
Configuration {
    protected static AtomicReference<ResteasyProviderFactory> pfr = new AtomicReference();
    protected static ThreadLocalStack<Map<Class<?>, Object>> contextualData = new ThreadLocalStack();
    protected static int maxForwards = 20;
    protected static volatile ResteasyProviderFactory instance;
    public static boolean registerBuiltinByDefault;
    protected MediaTypeMap<SortedKey<MessageBodyReader>> serverMessageBodyReaders;
    protected MediaTypeMap<SortedKey<MessageBodyWriter>> serverMessageBodyWriters;
    protected MediaTypeMap<SortedKey<MessageBodyReader>> clientMessageBodyReaders;
    protected MediaTypeMap<SortedKey<MessageBodyWriter>> clientMessageBodyWriters;
    protected Map<Class<?>, SortedKey<ExceptionMapper>> sortedExceptionMappers;
    protected Map<Class<?>, ExceptionMapper> exceptionMappers;
    protected Map<Class<?>, ClientExceptionMapper> clientExceptionMappers;
    protected Map<Class<?>, AsyncResponseProvider> asyncResponseProviders;
    protected Map<Class<?>, AsyncClientResponseProvider> asyncClientResponseProviders;
    protected Map<Class<?>, AsyncStreamProvider> asyncStreamProviders;
    protected Map<Class<?>, MediaTypeMap<SortedKey<ContextResolver>>> contextResolvers;
    protected Map<Class<?>, StringConverter> stringConverters;
    protected Set<ExtSortedKey<ParamConverterProvider>> sortedParamConverterProviders;
    protected List<ParamConverterProvider> paramConverterProviders;
    protected Map<Class<?>, Class<? extends StringParameterUnmarshaller>> stringParameterUnmarshallers;
    protected Map<Class<?>, Map<Class<?>, Integer>> classContracts;
    protected Map<Class<?>, RuntimeDelegate.HeaderDelegate> headerDelegates;
    protected LegacyPrecedence precedence;
    protected ReaderInterceptorRegistry serverReaderInterceptorRegistry;
    protected WriterInterceptorRegistry serverWriterInterceptorRegistry;
    protected ContainerRequestFilterRegistry containerRequestFilterRegistry;
    protected ContainerResponseFilterRegistry containerResponseFilterRegistry;
    protected ClientRequestFilterRegistry clientRequestFilterRegistry;
    @Deprecated
    protected JaxrsInterceptorRegistry<ClientRequestFilter> clientRequestFilters;
    protected ClientResponseFilterRegistry clientResponseFilters;
    protected ReaderInterceptorRegistry clientReaderInterceptorRegistry;
    protected WriterInterceptorRegistry clientWriterInterceptorRegistry;
    protected InterceptorRegistry<ClientExecutionInterceptor> clientExecutionInterceptorRegistry;
    protected List<ClientErrorInterceptor> clientErrorInterceptors;
    protected boolean builtinsRegistered = false;
    protected boolean registerBuiltins = true;
    protected InjectorFactory injectorFactory;
    protected ResteasyProviderFactory parent;
    protected Set<DynamicFeature> serverDynamicFeatures;
    protected Set<DynamicFeature> clientDynamicFeatures;
    protected Set<Feature> enabledFeatures;
    protected Map<String, Object> properties;
    protected Set<Class<?>> providerClasses;
    protected Set<Object> providerInstances;
    protected Set<Class<?>> featureClasses;
    protected Set<Object> featureInstances;
    protected Map<Class<?>, Class<? extends RxInvokerProvider<?>>> reactiveClasses;
    private boolean initialized = false;
    protected ResourceBuilder resourceBuilder;
    private Map<Class<?>, SingletonResource> singletonResourceFactories;
    private StatisticsControllerImpl statisticsController = new StatisticsControllerImpl();
    static final Object RD_LOCK;

    public ResteasyProviderFactory() {
        this.initialize();
    }

    public ResteasyProviderFactory(ResteasyProviderFactory parent) {
        this(parent, false);
    }

    public ResteasyProviderFactory(ResteasyProviderFactory parent, boolean local) {
        if (local || parent == null) {
            this.parent = null;
            this.initialize(parent);
        } else {
            this.parent = parent;
            this.featureClasses = new CopyOnWriteArraySet();
            this.featureInstances = new CopyOnWriteArraySet<Object>();
            this.providerClasses = new CopyOnWriteArraySet();
            this.providerInstances = new CopyOnWriteArraySet<Object>();
            this.properties = new ConcurrentHashMap<String, Object>();
            this.properties.putAll(parent.getProperties());
            this.enabledFeatures = new CopyOnWriteArraySet<Feature>();
            this.reactiveClasses = new ConcurrentHashMap();
        }
    }

    protected void initialize() {
        this.initialize(null);
    }

    protected void initialize(ResteasyProviderFactory parent) {
        this.serverDynamicFeatures = parent == null ? new CopyOnWriteArraySet<DynamicFeature>() : new CopyOnWriteArraySet<DynamicFeature>(parent.getServerDynamicFeatures());
        this.clientDynamicFeatures = parent == null ? new CopyOnWriteArraySet<DynamicFeature>() : new CopyOnWriteArraySet<DynamicFeature>(parent.getClientDynamicFeatures());
        this.enabledFeatures = parent == null ? new CopyOnWriteArraySet<Feature>() : new CopyOnWriteArraySet<Feature>(parent.getEnabledFeatures());
        this.properties = parent == null ? new ConcurrentHashMap<String, Object>() : new ConcurrentHashMap<String, Object>(parent.getProperties());
        this.featureClasses = parent == null ? new CopyOnWriteArraySet() : new CopyOnWriteArraySet(parent.getFeatureClasses());
        this.featureInstances = parent == null ? new CopyOnWriteArraySet<Object>() : new CopyOnWriteArraySet<Object>(parent.getFeatureInstances());
        this.providerClasses = parent == null ? new CopyOnWriteArraySet() : new CopyOnWriteArraySet(parent.getProviderClasses());
        this.providerInstances = parent == null ? new CopyOnWriteArraySet<Object>() : new CopyOnWriteArraySet<Object>(parent.getProviderInstances());
        this.classContracts = parent == null ? new ConcurrentHashMap() : new ConcurrentHashMap(parent.getClassContracts());
        this.serverMessageBodyReaders = parent == null ? new MediaTypeMap() : new MediaTypeMap<SortedKey<MessageBodyReader>>(parent.getServerMessageBodyReaders());
        this.serverMessageBodyWriters = parent == null ? new MediaTypeMap() : new MediaTypeMap<SortedKey<MessageBodyWriter>>(parent.getServerMessageBodyWriters());
        this.clientMessageBodyReaders = parent == null ? new MediaTypeMap() : new MediaTypeMap<SortedKey<MessageBodyReader>>(parent.getClientMessageBodyReaders());
        this.clientMessageBodyWriters = parent == null ? new MediaTypeMap() : new MediaTypeMap<SortedKey<MessageBodyWriter>>(parent.getClientMessageBodyWriters());
        this.sortedExceptionMappers = parent == null ? new ConcurrentHashMap() : new ConcurrentHashMap(parent.getSortedExceptionMappers());
        this.exceptionMappers = parent == null ? new ConcurrentHashMap() : new ConcurrentHashMap(parent.getExceptionMappers());
        this.clientExceptionMappers = parent == null ? new ConcurrentHashMap() : new ConcurrentHashMap(parent.getClientExceptionMappers());
        this.asyncResponseProviders = parent == null ? new ConcurrentHashMap() : new ConcurrentHashMap(parent.getAsyncResponseProviders());
        this.asyncClientResponseProviders = parent == null ? new ConcurrentHashMap() : new ConcurrentHashMap(parent.getAsyncClientResponseProviders());
        this.asyncStreamProviders = parent == null ? new ConcurrentHashMap() : new ConcurrentHashMap(parent.getAsyncStreamProviders());
        this.contextResolvers = new ConcurrentHashMap();
        if (parent != null) {
            for (Map.Entry<Class<?>, MediaTypeMap<SortedKey<ContextResolver>>> entry : parent.getContextResolvers().entrySet()) {
                this.contextResolvers.put(entry.getKey(), new MediaTypeMap<SortedKey<ContextResolver>>(entry.getValue()));
            }
        }
        this.sortedParamConverterProviders = Collections.synchronizedSortedSet(parent == null ? new TreeSet() : new TreeSet<ExtSortedKey<ParamConverterProvider>>(parent.getSortedParamConverterProviders()));
        this.stringConverters = parent == null ? new ConcurrentHashMap() : new ConcurrentHashMap(parent.getStringConverters());
        this.stringParameterUnmarshallers = parent == null ? new ConcurrentHashMap() : new ConcurrentHashMap(parent.getStringParameterUnmarshallers());
        this.reactiveClasses = parent == null ? new ConcurrentHashMap() : new ConcurrentHashMap(parent.reactiveClasses);
        this.headerDelegates = parent == null ? new ConcurrentHashMap() : new ConcurrentHashMap(parent.getHeaderDelegates());
        this.precedence = new LegacyPrecedence();
        this.serverReaderInterceptorRegistry = parent == null ? new ReaderInterceptorRegistry(this, this.precedence) : parent.getServerReaderInterceptorRegistry().clone(this);
        this.serverWriterInterceptorRegistry = parent == null ? new WriterInterceptorRegistry(this, this.precedence) : parent.getServerWriterInterceptorRegistry().clone(this);
        this.containerRequestFilterRegistry = parent == null ? new ContainerRequestFilterRegistry(this, this.precedence) : parent.getContainerRequestFilterRegistry().clone(this);
        this.containerResponseFilterRegistry = parent == null ? new ContainerResponseFilterRegistry(this, this.precedence) : parent.getContainerResponseFilterRegistry().clone(this);
        this.initializeClientProviders(parent);
        this.clientReaderInterceptorRegistry = parent == null ? new ReaderInterceptorRegistry(this, this.precedence) : parent.getClientReaderInterceptorRegistry().clone(this);
        this.clientWriterInterceptorRegistry = parent == null ? new WriterInterceptorRegistry(this, this.precedence) : parent.getClientWriterInterceptorRegistry().clone(this);
        this.clientExecutionInterceptorRegistry = parent == null ? new InterceptorRegistry<ClientExecutionInterceptor>(ClientExecutionInterceptor.class, this) : parent.getClientExecutionInterceptorRegistry().cloneTo(this);
        this.clientErrorInterceptors = parent == null ? new CopyOnWriteArrayList<ClientErrorInterceptor>() : new CopyOnWriteArrayList<ClientErrorInterceptor>(parent.getClientErrorInterceptors());
        this.resourceBuilder = new ResourceBuilder();
        this.builtinsRegistered = false;
        this.registerBuiltins = true;
        this.singletonResourceFactories = new HashMap();
        this.injectorFactory = parent == null ? new InjectorFactoryImpl() : parent.getInjectorFactory();
        this.registerDefaultInterceptorPrecedences();
        this.addHeaderDelegateIfAbsent(MediaType.class, new MediaTypeHeaderDelegate());
        this.addHeaderDelegateIfAbsent(NewCookie.class, new NewCookieHeaderDelegate());
        this.addHeaderDelegateIfAbsent(Cookie.class, new CookieHeaderDelegate());
        this.addHeaderDelegateIfAbsent(URI.class, new UriHeaderDelegate());
        this.addHeaderDelegateIfAbsent(EntityTag.class, new EntityTagDelegate());
        this.addHeaderDelegateIfAbsent(CacheControl.class, new CacheControlDelegate());
        this.addHeaderDelegateIfAbsent(Locale.class, new LocaleDelegate());
        this.addHeaderDelegateIfAbsent(LinkHeader.class, new LinkHeaderDelegate());
        this.addHeaderDelegateIfAbsent(Link.class, new LinkDelegate());
        this.addHeaderDelegateIfAbsent(Date.class, new DateDelegate());
        this.initialized = true;
    }

    public Set<DynamicFeature> getServerDynamicFeatures() {
        if (this.serverDynamicFeatures == null && this.parent != null) {
            return this.parent.getServerDynamicFeatures();
        }
        return this.serverDynamicFeatures;
    }

    public Set<DynamicFeature> getClientDynamicFeatures() {
        if (this.clientDynamicFeatures == null && this.parent != null) {
            return this.parent.getClientDynamicFeatures();
        }
        return this.clientDynamicFeatures;
    }

    protected MediaTypeMap<SortedKey<MessageBodyReader>> getServerMessageBodyReaders() {
        if (this.serverMessageBodyReaders == null && this.parent != null) {
            return this.parent.getServerMessageBodyReaders();
        }
        return this.serverMessageBodyReaders;
    }

    protected MediaTypeMap<SortedKey<MessageBodyWriter>> getServerMessageBodyWriters() {
        if (this.serverMessageBodyWriters == null && this.parent != null) {
            return this.parent.getServerMessageBodyWriters();
        }
        return this.serverMessageBodyWriters;
    }

    protected MediaTypeMap<SortedKey<MessageBodyReader>> getClientMessageBodyReaders() {
        if (this.clientMessageBodyReaders == null && this.parent != null) {
            return this.parent.getClientMessageBodyReaders();
        }
        return this.clientMessageBodyReaders;
    }

    protected MediaTypeMap<SortedKey<MessageBodyWriter>> getClientMessageBodyWriters() {
        if (this.clientMessageBodyWriters == null && this.parent != null) {
            return this.parent.getClientMessageBodyWriters();
        }
        return this.clientMessageBodyWriters;
    }

    public Map<Class<?>, ExceptionMapper> getExceptionMappers() {
        if (this.exceptionMappers != null) {
            return this.exceptionMappers;
        }
        ConcurrentHashMap map = new ConcurrentHashMap();
        for (Map.Entry<Class<?>, SortedKey<ExceptionMapper>> entry : this.getSortedExceptionMappers().entrySet()) {
            map.put(entry.getKey(), entry.getValue().getObj());
        }
        this.exceptionMappers = map;
        return map;
    }

    protected Map<Class<?>, SortedKey<ExceptionMapper>> getSortedExceptionMappers() {
        if (this.sortedExceptionMappers == null && this.parent != null) {
            return this.parent.getSortedExceptionMappers();
        }
        return this.sortedExceptionMappers;
    }

    protected Map<Class<?>, ClientExceptionMapper> getClientExceptionMappers() {
        if (this.clientExceptionMappers == null && this.parent != null) {
            return this.parent.getClientExceptionMappers();
        }
        return this.clientExceptionMappers;
    }

    public Map<Class<?>, AsyncClientResponseProvider> getAsyncClientResponseProviders() {
        if (this.asyncClientResponseProviders == null && this.parent != null) {
            return this.parent.getAsyncClientResponseProviders();
        }
        return this.asyncClientResponseProviders;
    }

    public Map<Class<?>, AsyncResponseProvider> getAsyncResponseProviders() {
        if (this.asyncResponseProviders == null && this.parent != null) {
            return this.parent.getAsyncResponseProviders();
        }
        return this.asyncResponseProviders;
    }

    public Map<Class<?>, AsyncStreamProvider> getAsyncStreamProviders() {
        if (this.asyncStreamProviders == null && this.parent != null) {
            return this.parent.getAsyncStreamProviders();
        }
        return this.asyncStreamProviders;
    }

    protected void addAsyncClientResponseProvider(Class<? extends AsyncClientResponseProvider> providerClass) {
        AsyncClientResponseProvider provider = this.createProviderInstance(providerClass);
        this.addAsyncClientResponseProvider(provider, providerClass);
    }

    protected void addAsyncClientResponseProvider(AsyncClientResponseProvider provider) {
        this.addAsyncClientResponseProvider(provider, provider.getClass());
    }

    protected void addAsyncClientResponseProvider(AsyncClientResponseProvider provider, Class providerClass) {
        Type asyncType = Types.getActualTypeArgumentsOfAnInterface(providerClass, AsyncClientResponseProvider.class)[0];
        this.addAsyncClientResponseProvider(provider, asyncType);
    }

    protected void addAsyncClientResponseProvider(AsyncClientResponseProvider provider, Type asyncType) {
        this.injectProperties(provider.getClass(), provider);
        Class<?> asyncClass = Types.getRawType(asyncType);
        if (this.asyncClientResponseProviders == null) {
            this.asyncClientResponseProviders = new ConcurrentHashMap();
            this.asyncClientResponseProviders.putAll(this.parent.getAsyncClientResponseProviders());
        }
        this.asyncClientResponseProviders.put(asyncClass, provider);
    }

    protected Map<Class<?>, MediaTypeMap<SortedKey<ContextResolver>>> getContextResolvers() {
        if (this.contextResolvers == null && this.parent != null) {
            return this.parent.getContextResolvers();
        }
        return this.contextResolvers;
    }

    protected Map<Class<?>, StringConverter> getStringConverters() {
        if (this.stringConverters == null && this.parent != null) {
            return this.parent.getStringConverters();
        }
        return this.stringConverters;
    }

    public List<ParamConverterProvider> getParamConverterProviders() {
        if (this.paramConverterProviders != null) {
            return this.paramConverterProviders;
        }
        CopyOnWriteArrayList<ParamConverterProvider> list = new CopyOnWriteArrayList<ParamConverterProvider>();
        for (SortedKey sortedKey : this.getSortedParamConverterProviders()) {
            list.add((ParamConverterProvider)sortedKey.getObj());
        }
        this.paramConverterProviders = list;
        return list;
    }

    protected Set<ExtSortedKey<ParamConverterProvider>> getSortedParamConverterProviders() {
        if (this.sortedParamConverterProviders == null && this.parent != null) {
            return this.parent.getSortedParamConverterProviders();
        }
        return this.sortedParamConverterProviders;
    }

    protected Map<Class<?>, Class<? extends StringParameterUnmarshaller>> getStringParameterUnmarshallers() {
        if (this.stringParameterUnmarshallers == null && this.parent != null) {
            return this.parent.getStringParameterUnmarshallers();
        }
        return this.stringParameterUnmarshallers;
    }

    public Set<Class<?>> getProviderClasses() {
        if (this.initialized) {
            return this.providerClasses;
        }
        HashSet set = new HashSet();
        if (this.parent != null) {
            set.addAll(this.parent.getProviderClasses());
        }
        set.addAll(this.providerClasses);
        return set;
    }

    public Set<Object> getProviderInstances() {
        if (this.initialized) {
            return this.providerInstances;
        }
        HashSet<Object> set = new HashSet<Object>();
        if (this.parent != null) {
            set.addAll(this.parent.getProviderInstances());
        }
        set.addAll(this.providerInstances);
        return set;
    }

    public Map<Class<?>, Map<Class<?>, Integer>> getClassContracts() {
        if (this.classContracts != null) {
            return this.classContracts;
        }
        ConcurrentHashMap map = new ConcurrentHashMap();
        if (this.parent != null) {
            for (Map.Entry<Class<?>, Map<Class<?>, Integer>> entry : this.parent.getClassContracts().entrySet()) {
                HashMap mapEntry = new HashMap();
                mapEntry.putAll(entry.getValue());
                map.put(entry.getKey(), mapEntry);
            }
        }
        this.classContracts = map;
        return this.classContracts;
    }

    protected LegacyPrecedence getPrecedence() {
        if (this.precedence == null && this.parent != null) {
            return this.parent.getPrecedence();
        }
        return this.precedence;
    }

    public ResteasyProviderFactory getParent() {
        return this.parent;
    }

    protected void registerDefaultInterceptorPrecedences(InterceptorRegistry registry) {
        registry.appendPrecedence("SECURITY");
        registry.appendPrecedence("HEADER_DECORATOR");
        registry.appendPrecedence("ENCODER");
        registry.appendPrecedence("REDIRECT");
        registry.appendPrecedence("DECODER");
    }

    protected void registerDefaultInterceptorPrecedences() {
        this.precedence.addPrecedence("SECURITY", 1000);
        this.precedence.addPrecedence("HEADER_DECORATOR", 3000);
        this.precedence.addPrecedence("ENCODER", 4000);
        this.precedence.addPrecedence("REDIRECT", 4050);
        this.precedence.addPrecedence("DECODER", 4000);
        this.registerDefaultInterceptorPrecedences(this.getClientExecutionInterceptorRegistry());
    }

    @Deprecated
    public void appendInterceptorPrecedence(String precedence) {
        if (this.precedence == null) {
            this.precedence = this.parent.getPrecedence().clone();
        }
        if (this.clientExecutionInterceptorRegistry == null) {
            this.clientExecutionInterceptorRegistry = this.parent.getClientExecutionInterceptorRegistry().cloneTo(this);
        }
        this.precedence.appendPrecedence(precedence);
        this.clientExecutionInterceptorRegistry.appendPrecedence(precedence);
    }

    @Deprecated
    public void insertInterceptorPrecedenceAfter(String after, String newPrecedence) {
        if (this.precedence == null) {
            this.precedence = this.parent.getPrecedence().clone();
        }
        if (this.clientExecutionInterceptorRegistry == null) {
            this.clientExecutionInterceptorRegistry = this.parent.getClientExecutionInterceptorRegistry().cloneTo(this);
        }
        this.precedence.insertPrecedenceAfter(after, newPrecedence);
        this.getClientExecutionInterceptorRegistry().insertPrecedenceAfter(after, newPrecedence);
    }

    @Deprecated
    public void insertInterceptorPrecedenceBefore(String before, String newPrecedence) {
        if (this.precedence == null) {
            this.precedence = this.parent.getPrecedence().clone();
        }
        if (this.clientExecutionInterceptorRegistry == null) {
            this.clientExecutionInterceptorRegistry = this.parent.getClientExecutionInterceptorRegistry().cloneTo(this);
        }
        this.precedence.insertPrecedenceBefore(before, newPrecedence);
        this.getClientExecutionInterceptorRegistry().insertPrecedenceBefore(before, newPrecedence);
    }

    public static <T> void pushContext(Class<T> type, T data) {
        ResteasyProviderFactory.getContextDataMap().put(type, data);
    }

    public static void pushContextDataMap(Map<Class<?>, Object> map) {
        contextualData.push(map);
    }

    public static Map<Class<?>, Object> getContextDataMap() {
        return ResteasyProviderFactory.getContextDataMap(true);
    }

    public static <T> T getContextData(Class<T> type) {
        Map<Class<?>, Object> contextDataMap = ResteasyProviderFactory.getContextDataMap(false);
        if (contextDataMap == null) {
            return null;
        }
        return (T)contextDataMap.get(type);
    }

    public static <T> T popContextData(Class<T> type) {
        return (T)ResteasyProviderFactory.getContextDataMap().remove(type);
    }

    public static void clearContextData() {
        contextualData.clear();
    }

    public static Map<Class<?>, Object> getContextDataMap(boolean create) {
        Map<Class<?>, Object> map = contextualData.get();
        if (map == null && create) {
            map = new HashMap();
            contextualData.setLast(map);
        }
        return map;
    }

    public static CloseableContext addCloseableContextDataLevel() {
        ResteasyProviderFactory.addContextDataLevel();
        return () -> ResteasyProviderFactory.removeContextDataLevel();
    }

    public static CloseableContext addCloseableContextDataLevel(Map<Class<?>, Object> data) {
        ResteasyProviderFactory.pushContextDataMap(data);
        return ResteasyProviderFactory::removeContextDataLevel;
    }

    public static Map<Class<?>, Object> addContextDataLevel() {
        if (ResteasyProviderFactory.getContextDataLevelCount() == maxForwards) {
            throw new BadRequestException(Messages.MESSAGES.excededMaximumForwards(ResteasyProviderFactory.getContextData(UriInfo.class).getPath()));
        }
        HashMap map = new HashMap();
        contextualData.push(map);
        return map;
    }

    public static int getContextDataLevelCount() {
        return contextualData.size();
    }

    public static void removeContextDataLevel() {
        contextualData.pop();
    }

    public static Object searchContextData(Object o) {
        for (int i = contextualData.size() - 1; i >= 0; --i) {
            Map<Class<?>, Object> map = contextualData.get(i);
            if (!map.containsKey(o)) continue;
            return map.get(o);
        }
        return null;
    }

    public static ResteasyProviderFactory peekInstance() {
        return instance;
    }

    public static synchronized void clearInstanceIfEqual(ResteasyProviderFactory factory) {
        if (instance == factory) {
            instance = null;
            RuntimeDelegate.setInstance(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void setInstance(ResteasyProviderFactory factory) {
        Object object = RD_LOCK;
        synchronized (object) {
            instance = factory;
        }
        RuntimeDelegate.setInstance((RuntimeDelegate)factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResteasyProviderFactory getInstance() {
        ResteasyProviderFactory result = instance;
        if (result == null) {
            Object object = RD_LOCK;
            synchronized (object) {
                result = instance;
                if (result == null) {
                    RuntimeDelegate runtimeDelegate = RuntimeDelegate.getInstance();
                    instance = runtimeDelegate instanceof ResteasyProviderFactory ? (result = (ResteasyProviderFactory)runtimeDelegate) : (result = new ResteasyProviderFactory());
                    if (registerBuiltinByDefault) {
                        RegisterBuiltin.register(instance);
                    }
                }
            }
        }
        return instance;
    }

    public static ResteasyProviderFactory newInstance() {
        return new ResteasyProviderFactory();
    }

    public static void setRegisterBuiltinByDefault(boolean registerBuiltinByDefault) {
        ResteasyProviderFactory.registerBuiltinByDefault = registerBuiltinByDefault;
    }

    public boolean isRegisterBuiltins() {
        return this.registerBuiltins;
    }

    public void setRegisterBuiltins(boolean registerBuiltins) {
        this.registerBuiltins = registerBuiltins;
    }

    public InjectorFactory getInjectorFactory() {
        if (this.injectorFactory == null && this.parent != null) {
            return this.parent.getInjectorFactory();
        }
        return this.injectorFactory;
    }

    public void setInjectorFactory(InjectorFactory injectorFactory) {
        this.injectorFactory = injectorFactory;
    }

    public InterceptorRegistry<ClientExecutionInterceptor> getClientExecutionInterceptorRegistry() {
        if (this.clientExecutionInterceptorRegistry == null && this.parent != null) {
            return this.parent.getClientExecutionInterceptorRegistry();
        }
        return this.clientExecutionInterceptorRegistry;
    }

    public ReaderInterceptorRegistry getServerReaderInterceptorRegistry() {
        if (this.serverReaderInterceptorRegistry == null && this.parent != null) {
            return this.parent.getServerReaderInterceptorRegistry();
        }
        return this.serverReaderInterceptorRegistry;
    }

    public WriterInterceptorRegistry getServerWriterInterceptorRegistry() {
        if (this.serverWriterInterceptorRegistry == null && this.parent != null) {
            return this.parent.getServerWriterInterceptorRegistry();
        }
        return this.serverWriterInterceptorRegistry;
    }

    public ContainerRequestFilterRegistry getContainerRequestFilterRegistry() {
        if (this.containerRequestFilterRegistry == null && this.parent != null) {
            return this.parent.getContainerRequestFilterRegistry();
        }
        return this.containerRequestFilterRegistry;
    }

    public ContainerResponseFilterRegistry getContainerResponseFilterRegistry() {
        if (this.containerResponseFilterRegistry == null && this.parent != null) {
            return this.parent.getContainerResponseFilterRegistry();
        }
        return this.containerResponseFilterRegistry;
    }

    public ReaderInterceptorRegistry getClientReaderInterceptorRegistry() {
        if (this.clientReaderInterceptorRegistry == null && this.parent != null) {
            return this.parent.getClientReaderInterceptorRegistry();
        }
        return this.clientReaderInterceptorRegistry;
    }

    public WriterInterceptorRegistry getClientWriterInterceptorRegistry() {
        if (this.clientWriterInterceptorRegistry == null && this.parent != null) {
            return this.parent.getClientWriterInterceptorRegistry();
        }
        return this.clientWriterInterceptorRegistry;
    }

    public ClientRequestFilterRegistry getClientRequestFilterRegistry() {
        if (this.clientRequestFilterRegistry == null && this.parent != null) {
            return this.parent.getClientRequestFilterRegistry();
        }
        return this.clientRequestFilterRegistry;
    }

    @Deprecated
    public JaxrsInterceptorRegistry<ClientRequestFilter> getClientRequestFilters() {
        if (this.clientRequestFilters == null && this.parent != null) {
            return this.parent.getClientRequestFilters();
        }
        return this.clientRequestFilters;
    }

    public ClientResponseFilterRegistry getClientResponseFilters() {
        if (this.clientResponseFilters == null && this.parent != null) {
            return this.parent.getClientResponseFilters();
        }
        return this.clientResponseFilters;
    }

    public boolean isBuiltinsRegistered() {
        return this.builtinsRegistered;
    }

    public void setBuiltinsRegistered(boolean builtinsRegistered) {
        this.builtinsRegistered = builtinsRegistered;
    }

    public UriBuilder createUriBuilder() {
        return new ResteasyUriBuilder();
    }

    public Response.ResponseBuilder createResponseBuilder() {
        return new ResponseBuilderImpl();
    }

    public Variant.VariantListBuilder createVariantListBuilder() {
        return new VariantListBuilderImpl();
    }

    public <T> RuntimeDelegate.HeaderDelegate<T> createHeaderDelegate(Class<T> tClass) {
        if (tClass == null) {
            throw new IllegalArgumentException(Messages.MESSAGES.tClassParameterNull());
        }
        if (this.headerDelegates == null && this.parent != null) {
            return this.parent.createHeaderDelegate(tClass);
        }
        for (Class<T> clazz = tClass; clazz != null; clazz = clazz.getSuperclass()) {
            RuntimeDelegate.HeaderDelegate<T> delegate = this.headerDelegates.get(clazz);
            if (delegate != null) {
                return delegate;
            }
            delegate = this.createHeaderDelegateFromInterfaces(clazz.getInterfaces());
            if (delegate == null) continue;
            return delegate;
        }
        return this.createHeaderDelegateFromInterfaces(tClass.getInterfaces());
    }

    protected <T> RuntimeDelegate.HeaderDelegate<T> createHeaderDelegateFromInterfaces(Class<?>[] interfaces) {
        RuntimeDelegate.HeaderDelegate<T> delegate = null;
        for (int i = 0; i < interfaces.length; ++i) {
            delegate = this.headerDelegates.get(interfaces[i]);
            if (delegate != null) {
                return delegate;
            }
            delegate = this.createHeaderDelegateFromInterfaces(interfaces[i].getInterfaces());
            if (delegate == null) continue;
            return delegate;
        }
        return null;
    }

    protected Map<Class<?>, RuntimeDelegate.HeaderDelegate> getHeaderDelegates() {
        if (this.headerDelegates == null && this.parent != null) {
            return this.parent.getHeaderDelegates();
        }
        return this.headerDelegates;
    }

    private void addHeaderDelegateIfAbsent(Class clazz, RuntimeDelegate.HeaderDelegate header) {
        if (this.headerDelegates == null || !this.headerDelegates.containsKey(clazz)) {
            this.addHeaderDelegate(clazz, header);
        }
    }

    public void addHeaderDelegate(Class clazz, RuntimeDelegate.HeaderDelegate header) {
        if (this.headerDelegates == null) {
            this.headerDelegates = new ConcurrentHashMap();
            this.headerDelegates.putAll(this.parent.getHeaderDelegates());
        }
        this.headerDelegates.put(clazz, header);
    }

    protected void addMessageBodyReader(Class<? extends MessageBodyReader> provider, int priority, boolean isBuiltin) {
        MessageBodyReader reader = this.createProviderInstance(provider);
        this.addMessageBodyReader(reader, provider, priority, isBuiltin);
    }

    protected void addMessageBodyReader(MessageBodyReader provider) {
        this.addMessageBodyReader(provider, 5000, false);
    }

    protected void addMessageBodyReader(MessageBodyReader provider, int priority, boolean isBuiltin) {
        this.addMessageBodyReader(provider, provider.getClass(), priority, isBuiltin);
    }

    protected void addMessageBodyReader(MessageBodyReader provider, Class<?> providerClass, int priority, boolean isBuiltin) {
        SortedKey<MessageBodyReader> key = new SortedKey<MessageBodyReader>(MessageBodyReader.class, provider, providerClass, priority, isBuiltin);
        this.injectProperties(providerClass, provider);
        Consumes consumeMime = provider.getClass().getAnnotation(Consumes.class);
        RuntimeType type = null;
        ConstrainedTo constrainedTo = providerClass.getAnnotation(ConstrainedTo.class);
        if (constrainedTo != null) {
            type = constrainedTo.value();
        }
        if (type == null) {
            this.addClientMessageBodyReader(key, consumeMime);
            this.addServerMessageBodyReader(key, consumeMime);
        } else if (type == RuntimeType.CLIENT) {
            this.addClientMessageBodyReader(key, consumeMime);
        } else {
            this.addServerMessageBodyReader(key, consumeMime);
        }
    }

    protected void addServerMessageBodyReader(SortedKey<MessageBodyReader> key, Consumes consumeMime) {
        if (this.serverMessageBodyReaders == null) {
            this.serverMessageBodyReaders = new MediaTypeMap<SortedKey<MessageBodyReader>>(this.parent.getServerMessageBodyReaders());
        }
        if (consumeMime != null) {
            for (String consume : consumeMime.value()) {
                MediaType mime = MediaType.valueOf((String)consume);
                this.serverMessageBodyReaders.add(mime, key);
            }
        } else {
            this.serverMessageBodyReaders.add(new MediaType("*", "*"), key);
        }
    }

    protected void addClientMessageBodyReader(SortedKey<MessageBodyReader> key, Consumes consumeMime) {
        if (this.clientMessageBodyReaders == null) {
            this.clientMessageBodyReaders = new MediaTypeMap<SortedKey<MessageBodyReader>>(this.parent.getClientMessageBodyReaders());
        }
        if (consumeMime != null) {
            for (String consume : consumeMime.value()) {
                MediaType mime = MediaType.valueOf((String)consume);
                this.clientMessageBodyReaders.add(mime, key);
            }
        } else {
            this.clientMessageBodyReaders.add(new MediaType("*", "*"), key);
        }
    }

    protected void addMessageBodyWriter(Class<? extends MessageBodyWriter> provider, int priority, boolean isBuiltin) {
        MessageBodyWriter writer = this.createProviderInstance(provider);
        this.addMessageBodyWriter(writer, provider, priority, isBuiltin);
    }

    protected void addMessageBodyWriter(MessageBodyWriter provider) {
        this.addMessageBodyWriter(provider, provider.getClass(), 5000, false);
    }

    protected void addMessageBodyWriter(MessageBodyWriter provider, Class<?> providerClass, int priority, boolean isBuiltin) {
        this.injectProperties(providerClass, provider);
        Produces consumeMime = provider.getClass().getAnnotation(Produces.class);
        SortedKey<MessageBodyWriter> key = new SortedKey<MessageBodyWriter>(MessageBodyWriter.class, provider, providerClass, priority, isBuiltin);
        RuntimeType type = null;
        ConstrainedTo constrainedTo = providerClass.getAnnotation(ConstrainedTo.class);
        if (constrainedTo != null) {
            type = constrainedTo.value();
        }
        if (type == null) {
            this.addClientMessageBodyWriter(consumeMime, key);
            this.addServerMessageBodyWriter(consumeMime, key);
        } else if (type == RuntimeType.CLIENT) {
            this.addClientMessageBodyWriter(consumeMime, key);
        } else {
            this.addServerMessageBodyWriter(consumeMime, key);
        }
    }

    protected void addServerMessageBodyWriter(Produces consumeMime, SortedKey<MessageBodyWriter> key) {
        if (this.serverMessageBodyWriters == null) {
            this.serverMessageBodyWriters = new MediaTypeMap<SortedKey<MessageBodyWriter>>(this.parent.getServerMessageBodyWriters());
        }
        if (consumeMime != null) {
            for (String consume : consumeMime.value()) {
                MediaType mime = MediaType.valueOf((String)consume);
                this.serverMessageBodyWriters.add(mime, key);
            }
        } else {
            this.serverMessageBodyWriters.add(new MediaType("*", "*"), key);
        }
    }

    protected void addClientMessageBodyWriter(Produces consumeMime, SortedKey<MessageBodyWriter> key) {
        if (this.clientMessageBodyWriters == null) {
            this.clientMessageBodyWriters = new MediaTypeMap<SortedKey<MessageBodyWriter>>(this.parent.getClientMessageBodyWriters());
        }
        if (consumeMime != null) {
            for (String consume : consumeMime.value()) {
                MediaType mime = MediaType.valueOf((String)consume);
                this.clientMessageBodyWriters.add(mime, key);
            }
        } else {
            this.clientMessageBodyWriters.add(new MediaType("*", "*"), key);
        }
    }

    public <T> MessageBodyReader<T> getServerMessageBodyReader(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        MediaTypeMap<SortedKey<MessageBodyReader>> availableReaders = this.getServerMessageBodyReaders();
        return this.resolveMessageBodyReader(type, genericType, annotations, mediaType, availableReaders);
    }

    public <T> MessageBodyReader<T> getMessageBodyReader(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        MediaTypeMap<SortedKey<MessageBodyReader>> availableReaders = this.getServerMessageBodyReaders();
        MessageBodyReader<T> reader = this.resolveMessageBodyReader(type, genericType, annotations, mediaType, availableReaders);
        if (reader != null) {
            LogMessages.LOGGER.debugf("MessageBodyReader: %s", reader.getClass().getName());
        }
        return reader;
    }

    public <T> MessageBodyReader<T> getClientMessageBodyReader(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        MediaTypeMap<SortedKey<MessageBodyReader>> availableReaders = this.getClientMessageBodyReaders();
        return this.resolveMessageBodyReader(type, genericType, annotations, mediaType, availableReaders);
    }

    protected <T> MessageBodyReader<T> resolveMessageBodyReader(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType, MediaTypeMap<SortedKey<MessageBodyReader>> availableReaders) {
        List<SortedKey<MessageBodyReader>> readers = availableReaders.getPossible(mediaType, type);
        for (SortedKey<MessageBodyReader> reader : readers) {
            if (!((MessageBodyReader)reader.obj).isReadable(type, genericType, annotations, mediaType)) continue;
            LogMessages.LOGGER.debugf("MessageBodyReader: %s", reader.getClass().getName());
            return (MessageBodyReader)reader.obj;
        }
        return null;
    }

    protected void addExceptionMapper(Class<? extends ExceptionMapper> providerClass) {
        this.addExceptionMapper(providerClass, false);
    }

    protected void addExceptionMapper(ExceptionMapper provider) {
        this.addExceptionMapper(provider, false);
    }

    protected void addExceptionMapper(ExceptionMapper provider, Class providerClass) {
        this.addExceptionMapper(provider, providerClass, false);
    }

    protected void addExceptionMapper(ExceptionMapper provider, Type exceptionType) {
        this.addExceptionMapper(provider, exceptionType, provider.getClass(), false);
    }

    protected void addExceptionMapper(Class<? extends ExceptionMapper> providerClass, boolean isBuiltin) {
        ExceptionMapper provider = this.createProviderInstance(providerClass);
        this.addExceptionMapper(provider, providerClass, isBuiltin);
    }

    protected void addExceptionMapper(ExceptionMapper provider, boolean isBuiltin) {
        this.addExceptionMapper(provider, provider.getClass(), isBuiltin);
    }

    protected void addExceptionMapper(ExceptionMapper provider, Class providerClass, boolean isBuiltin) {
        if (providerClass.isSynthetic()) {
            providerClass = providerClass.getSuperclass();
        }
        Type exceptionType = Types.getActualTypeArgumentsOfAnInterface(providerClass, ExceptionMapper.class)[0];
        this.addExceptionMapper(provider, exceptionType, providerClass, isBuiltin);
    }

    protected void addExceptionMapper(ExceptionMapper provider, Type exceptionType, Class providerClass, boolean isBuiltin) {
        if (providerClass.isSynthetic()) {
            providerClass = providerClass.getSuperclass();
        }
        this.injectProperties(providerClass, provider);
        Class<?> exceptionClass = Types.getRawType(exceptionType);
        if (!Throwable.class.isAssignableFrom(exceptionClass)) {
            throw new RuntimeException(Messages.MESSAGES.incorrectTypeParameterExceptionMapper());
        }
        if (this.sortedExceptionMappers == null) {
            this.sortedExceptionMappers = new ConcurrentHashMap();
            this.sortedExceptionMappers.putAll(this.parent.getSortedExceptionMappers());
        }
        int priority = this.getPriority(null, null, ExceptionMapper.class, providerClass);
        SortedKey<ExceptionMapper> candidateExceptionMapper = new SortedKey<ExceptionMapper>(null, provider, providerClass, priority, isBuiltin);
        SortedKey<ExceptionMapper> registeredExceptionMapper = this.sortedExceptionMappers.get(exceptionClass);
        if (registeredExceptionMapper != null && candidateExceptionMapper.compareTo(registeredExceptionMapper) > 0) {
            return;
        }
        this.sortedExceptionMappers.put(exceptionClass, candidateExceptionMapper);
        this.exceptionMappers = null;
    }

    public void addClientExceptionMapper(Class<? extends ClientExceptionMapper<?>> providerClass) {
        ClientExceptionMapper<?> provider = this.createProviderInstance(providerClass);
        this.addClientExceptionMapper(provider, providerClass);
    }

    public void addClientExceptionMapper(ClientExceptionMapper<?> provider) {
        this.addClientExceptionMapper(provider, provider.getClass());
    }

    public void addClientExceptionMapper(ClientExceptionMapper<?> provider, Class<?> providerClass) {
        Type exceptionType = Types.getActualTypeArgumentsOfAnInterface(providerClass, ClientExceptionMapper.class)[0];
        this.addClientExceptionMapper(provider, exceptionType);
    }

    public void addClientExceptionMapper(ClientExceptionMapper<?> provider, Type exceptionType) {
        this.injectProperties(provider.getClass());
        Class<?> exceptionClass = Types.getRawType(exceptionType);
        if (!Throwable.class.isAssignableFrom(exceptionClass)) {
            throw new RuntimeException(Messages.MESSAGES.incorrectTypeParameterClientExceptionMapper());
        }
        if (this.clientExceptionMappers == null) {
            this.clientExceptionMappers = new ConcurrentHashMap();
            this.clientExceptionMappers.putAll(this.parent.getClientExceptionMappers());
        }
        this.clientExceptionMappers.put(exceptionClass, provider);
    }

    public void addClientErrorInterceptor(ClientErrorInterceptor handler) {
        if (this.clientErrorInterceptors == null) {
            this.clientErrorInterceptors = new CopyOnWriteArrayList<ClientErrorInterceptor>(this.parent.getClientErrorInterceptors());
        }
        if (!this.clientErrorInterceptors.contains(handler)) {
            this.clientErrorInterceptors.add(handler);
        }
    }

    public List<ClientErrorInterceptor> getClientErrorInterceptors() {
        if (this.clientErrorInterceptors == null && this.parent != null) {
            return this.parent.getClientErrorInterceptors();
        }
        return this.clientErrorInterceptors;
    }

    protected void addAsyncResponseProvider(Class<? extends AsyncResponseProvider> providerClass) {
        AsyncResponseProvider provider = this.createProviderInstance(providerClass);
        this.addAsyncResponseProvider(provider, providerClass);
    }

    protected void addAsyncResponseProvider(AsyncResponseProvider provider) {
        this.addAsyncResponseProvider(provider, provider.getClass());
    }

    protected void addAsyncResponseProvider(AsyncResponseProvider provider, Class providerClass) {
        Type asyncType = Types.getActualTypeArgumentsOfAnInterface(providerClass, AsyncResponseProvider.class)[0];
        this.addAsyncResponseProvider(provider, asyncType);
    }

    protected void addAsyncResponseProvider(AsyncResponseProvider provider, Type asyncType) {
        this.injectProperties(provider.getClass(), provider);
        Class<?> asyncClass = Types.getRawType(asyncType);
        if (this.asyncResponseProviders == null) {
            this.asyncResponseProviders = new ConcurrentHashMap();
            this.asyncResponseProviders.putAll(this.parent.getAsyncResponseProviders());
        }
        this.asyncResponseProviders.put(asyncClass, provider);
    }

    protected void addAsyncStreamProvider(Class<? extends AsyncStreamProvider> providerClass) {
        AsyncStreamProvider provider = this.createProviderInstance(providerClass);
        this.addAsyncStreamProvider(provider, providerClass);
    }

    protected void addAsyncStreamProvider(AsyncStreamProvider provider) {
        this.addAsyncStreamProvider(provider, provider.getClass());
    }

    protected void addAsyncStreamProvider(AsyncStreamProvider provider, Class providerClass) {
        Type asyncType = Types.getActualTypeArgumentsOfAnInterface(providerClass, AsyncStreamProvider.class)[0];
        this.addAsyncStreamProvider(provider, asyncType);
    }

    protected void addAsyncStreamProvider(AsyncStreamProvider provider, Type asyncType) {
        this.injectProperties(provider.getClass(), provider);
        Class<?> asyncClass = Types.getRawType(asyncType);
        if (this.asyncStreamProviders == null) {
            this.asyncStreamProviders = new ConcurrentHashMap();
            this.asyncStreamProviders.putAll(this.parent.getAsyncStreamProviders());
        }
        this.asyncStreamProviders.put(asyncClass, provider);
    }

    protected void addContextResolver(Class<? extends ContextResolver> resolver, int priority, boolean builtin) {
        ContextResolver writer = this.createProviderInstance(resolver);
        this.addContextResolver(writer, priority, resolver, builtin);
    }

    protected void addContextResolver(ContextResolver provider, int priority) {
        this.addContextResolver(provider, priority, false);
    }

    protected void addContextResolver(ContextResolver provider, int priority, boolean builtin) {
        this.addContextResolver(provider, priority, provider.getClass(), builtin);
    }

    protected void addContextResolver(ContextResolver provider, int priority, Class providerClass, boolean builtin) {
        if (providerClass.getName().contains("$$Lambda$")) {
            throw new RuntimeException(Messages.MESSAGES.registeringContextResolverAsLambda());
        }
        Type parameter = Types.getActualTypeArgumentsOfAnInterface(providerClass, ContextResolver.class)[0];
        this.addContextResolver(provider, priority, parameter, providerClass, builtin);
    }

    protected void addContextResolver(ContextResolver provider, int priority, Type typeParameter, Class providerClass, boolean builtin) {
        MediaTypeMap<SortedKey<Object>> resolvers;
        this.injectProperties(providerClass, provider);
        Class<?> parameterClass = Types.getRawType(typeParameter);
        if (this.contextResolvers == null) {
            this.contextResolvers = new ConcurrentHashMap();
            for (Map.Entry<Class<?>, MediaTypeMap<SortedKey<ContextResolver>>> entry : this.parent.getContextResolvers().entrySet()) {
                this.contextResolvers.put(entry.getKey(), new MediaTypeMap<SortedKey<ContextResolver>>(entry.getValue()));
            }
        }
        if ((resolvers = this.contextResolvers.get(parameterClass)) == null) {
            resolvers = new MediaTypeMap();
            this.contextResolvers.put(parameterClass, resolvers);
        }
        Produces produces = provider.getClass().getAnnotation(Produces.class);
        SortedKey<ContextResolver> key = new SortedKey<ContextResolver>(ContextResolver.class, provider, providerClass, priority, builtin);
        if (produces != null) {
            for (String produce : produces.value()) {
                MediaType mime = MediaType.valueOf((String)produce);
                resolvers.add(mime, key);
            }
        } else {
            resolvers.add(new MediaType("*", "*"), key);
        }
    }

    protected void addContextResolver(Class<? extends ContextResolver> resolver, boolean builtin) {
        ContextResolver writer = this.createProviderInstance(resolver);
        this.addContextResolver(writer, resolver, builtin);
    }

    protected void addContextResolver(ContextResolver provider) {
        this.addContextResolver(provider, false);
    }

    protected void addContextResolver(ContextResolver provider, boolean builtin) {
        this.addContextResolver(provider, provider.getClass(), builtin);
    }

    protected void addContextResolver(ContextResolver provider, Class providerClass, boolean builtin) {
        if (providerClass.getName().contains("$$Lambda$")) {
            throw new RuntimeException(Messages.MESSAGES.registeringContextResolverAsLambda());
        }
        Type parameter = Types.getActualTypeArgumentsOfAnInterface(providerClass, ContextResolver.class)[0];
        this.addContextResolver(provider, parameter, providerClass, builtin);
    }

    protected void addContextResolver(ContextResolver provider, Type typeParameter, Class providerClass, boolean builtin) {
        int priority = this.getPriority(null, null, ContextResolver.class, providerClass);
        this.addContextResolver(provider, priority, typeParameter, providerClass, builtin);
    }

    protected void addStringConverter(Class<? extends StringConverter> resolver) {
        StringConverter writer = this.createProviderInstance(resolver);
        this.addStringConverter(writer, resolver);
    }

    protected void addStringConverter(StringConverter provider) {
        this.addStringConverter(provider, provider.getClass());
    }

    protected void addStringConverter(StringConverter provider, Class providerClass) {
        Type parameter = Types.getActualTypeArgumentsOfAnInterface(providerClass, StringConverter.class)[0];
        this.addStringConverter(provider, parameter);
    }

    protected void addStringConverter(StringConverter provider, Type typeParameter) {
        this.injectProperties(provider.getClass(), provider);
        Class<?> parameterClass = Types.getRawType(typeParameter);
        if (this.stringConverters == null) {
            this.stringConverters = new ConcurrentHashMap();
            this.stringConverters.putAll(this.parent.getStringConverters());
        }
        this.stringConverters.put(parameterClass, provider);
    }

    public void addStringParameterUnmarshaller(Class<? extends StringParameterUnmarshaller> provider) {
        Type[] intfs;
        if (this.stringParameterUnmarshallers == null) {
            this.stringParameterUnmarshallers = new ConcurrentHashMap();
            this.stringParameterUnmarshallers.putAll(this.parent.getStringParameterUnmarshallers());
        }
        for (Type type : intfs = provider.getGenericInterfaces()) {
            ParameterizedType pt;
            if (!(type instanceof ParameterizedType) || !(pt = (ParameterizedType)type).getRawType().equals(StringParameterUnmarshaller.class)) continue;
            Class<?> aClass = Types.getRawType(pt.getActualTypeArguments()[0]);
            this.stringParameterUnmarshallers.put(aClass, provider);
        }
    }

    public List<ContextResolver> getContextResolvers(Class<?> clazz, MediaType type) {
        MediaTypeMap<SortedKey<ContextResolver>> resolvers = this.getContextResolvers().get(clazz);
        if (resolvers == null) {
            return null;
        }
        ArrayList<ContextResolver> rtn = new ArrayList<ContextResolver>();
        List<SortedKey<ContextResolver>> list = resolvers.getPossible(type);
        list.forEach(resolver -> rtn.add((ContextResolver)resolver.obj));
        return rtn;
    }

    public ParamConverter getParamConverter(Class clazz, Type genericType, Annotation[] annotations) {
        for (SortedKey sortedKey : this.getSortedParamConverterProviders()) {
            ParamConverter converter = ((ParamConverterProvider)sortedKey.getObj()).getConverter(clazz, genericType, annotations);
            if (converter == null) continue;
            return converter;
        }
        return null;
    }

    public StringConverter getStringConverter(Class<?> clazz) {
        if (this.getStringConverters().size() == 0) {
            return null;
        }
        return this.getStringConverters().get(clazz);
    }

    public <T> StringParameterUnmarshaller<T> createStringParameterUnmarshaller(Class<T> clazz) {
        if (this.getStringParameterUnmarshallers().size() == 0) {
            return null;
        }
        Class<? extends StringParameterUnmarshaller> un = this.getStringParameterUnmarshallers().get(clazz);
        if (un == null) {
            return null;
        }
        StringParameterUnmarshaller provider = this.injectedInstance(un);
        return provider;
    }

    public void registerProvider(Class provider) {
        this.registerProvider(provider, false);
    }

    public String toString(Object object, Class clazz, Type genericType, Annotation[] annotations) {
        if (object instanceof String) {
            return (String)object;
        }
        ParamConverter paramConverter = this.getParamConverter(clazz, genericType, annotations);
        if (paramConverter != null) {
            return paramConverter.toString(object);
        }
        StringConverter converter = this.getStringConverter(object.getClass());
        if (converter != null) {
            return converter.toString(object);
        }
        return object.toString();
    }

    @Override
    public String toHeaderString(Object object) {
        if (object == null) {
            return "";
        }
        if (object instanceof String) {
            return (String)object;
        }
        Class<?> aClass = object.getClass();
        ParamConverter paramConverter = this.getParamConverter(aClass, null, null);
        if (paramConverter != null) {
            return paramConverter.toString(object);
        }
        StringConverter converter = this.getStringConverter(aClass);
        if (converter != null) {
            return converter.toString(object);
        }
        RuntimeDelegate.HeaderDelegate delegate = this.getHeaderDelegate(aClass);
        if (delegate != null) {
            return delegate.toString(object);
        }
        return object.toString();
    }

    public RuntimeDelegate.HeaderDelegate getHeaderDelegate(Class<?> aClass) {
        RuntimeDelegate.HeaderDelegate delegate = null;
        delegate = RuntimeDelegate.getInstance() instanceof ResteasyProviderFactory ? this.createHeaderDelegate(aClass) : RuntimeDelegate.getInstance().createHeaderDelegate(aClass);
        return delegate;
    }

    public void registerProvider(Class provider, boolean isBuiltin) {
        this.registerProvider(provider, null, isBuiltin, null);
    }

    public static boolean isA(Class target, Class type, Set<Class<?>> contracts) {
        if (!type.isAssignableFrom(target)) {
            return false;
        }
        if (contracts == null || contracts.size() == 0) {
            return true;
        }
        for (Class<?> contract : contracts) {
            if (!contract.equals(type)) continue;
            return true;
        }
        return false;
    }

    public static boolean isA(Object target, Class type, Set<Class<?>> contracts) {
        return ResteasyProviderFactory.isA(target.getClass(), type, contracts);
    }

    protected boolean isA(Class target, Class type, Map<Class<?>, Integer> contracts) {
        return ResteasyProviderFactory.isA(target, type, contracts == null ? null : contracts.keySet());
    }

    protected boolean isA(Object target, Class type, Map<Class<?>, Integer> contracts) {
        return this.isA(target.getClass(), type, contracts);
    }

    protected int getPriority(Integer override, Map<Class<?>, Integer> contracts, Class type, Class<?> component) {
        Integer p;
        if (override != null && override != -1) {
            return override;
        }
        if (contracts != null && (p = contracts.get(type)) != null) {
            return p;
        }
        Priority priority = (component = component.isSynthetic() ? component.getSuperclass() : component).getAnnotation(Priority.class);
        if (priority == null) {
            return 5000;
        }
        return priority.value();
    }

    public void registerProvider(Class provider, Integer priorityOverride, boolean isBuiltin, Map<Class<?>, Integer> contracts) {
        ConstrainedTo constrainedTo;
        int priority;
        Map<Class<?>, Map<Class<?>, Integer>> classContracts = this.getClassContracts();
        if (classContracts.containsKey(provider)) {
            LogMessages.LOGGER.providerClassAlreadyRegistered(provider.getName());
            return;
        }
        HashMap<Class<ResourceClassProcessor>, Integer> newContracts = new HashMap<Class<ResourceClassProcessor>, Integer>();
        if (this.isA(provider, ParamConverterProvider.class, contracts)) {
            ParamConverterProvider paramConverterProvider = (ParamConverterProvider)this.injectedInstance(provider);
            this.injectProperties(provider);
            if (this.sortedParamConverterProviders == null) {
                this.sortedParamConverterProviders = Collections.synchronizedSortedSet(new TreeSet<ExtSortedKey<ParamConverterProvider>>(this.parent.getSortedParamConverterProviders()));
            }
            priority = this.getPriority(priorityOverride, contracts, ParamConverterProvider.class, provider);
            this.sortedParamConverterProviders.add(new ExtSortedKey<ParamConverterProvider>(null, paramConverterProvider, provider, priority, isBuiltin));
            this.paramConverterProviders = null;
            newContracts.put(ParamConverterProvider.class, priority);
        }
        if (this.isA(provider, MessageBodyReader.class, contracts)) {
            try {
                int priority2 = this.getPriority(priorityOverride, contracts, MessageBodyReader.class, provider);
                this.addMessageBodyReader(provider, priority2, isBuiltin);
                newContracts.put(MessageBodyReader.class, priority2);
            }
            catch (Exception e) {
                throw new RuntimeException(Messages.MESSAGES.unableToInstantiateMessageBodyReader(), e);
            }
        }
        if (this.isA(provider, MessageBodyWriter.class, contracts)) {
            try {
                int priority3 = this.getPriority(priorityOverride, contracts, MessageBodyWriter.class, provider);
                this.addMessageBodyWriter(provider, priority3, isBuiltin);
                newContracts.put(MessageBodyWriter.class, priority3);
            }
            catch (Exception e) {
                throw new RuntimeException(Messages.MESSAGES.unableToInstantiateMessageBodyWriter(), e);
            }
        }
        if (this.isA(provider, ExceptionMapper.class, contracts)) {
            try {
                this.addExceptionMapper(provider, isBuiltin);
                newContracts.put(ExceptionMapper.class, this.getPriority(priorityOverride, contracts, ExceptionMapper.class, provider));
            }
            catch (Exception e) {
                throw new RuntimeException(Messages.MESSAGES.unableToInstantiateExceptionMapper(), e);
            }
        }
        if (this.isA(provider, ClientExceptionMapper.class, contracts)) {
            try {
                this.addClientExceptionMapper(provider);
                newContracts.put(ClientExceptionMapper.class, this.getPriority(priorityOverride, contracts, ClientExceptionMapper.class, provider));
            }
            catch (Exception e) {
                throw new RuntimeException(Messages.MESSAGES.unableToInstantiateClientExceptionMapper(), e);
            }
        }
        if (this.isA(provider, AsyncResponseProvider.class, contracts)) {
            try {
                this.addAsyncResponseProvider(provider);
                newContracts.put(AsyncResponseProvider.class, this.getPriority(priorityOverride, contracts, AsyncResponseProvider.class, provider));
            }
            catch (Exception e) {
                throw new RuntimeException(Messages.MESSAGES.unableToInstantiateAsyncResponseProvider(), e);
            }
        }
        if (this.isA(provider, AsyncClientResponseProvider.class, contracts)) {
            try {
                this.addAsyncClientResponseProvider(provider);
                newContracts.put(AsyncClientResponseProvider.class, this.getPriority(priorityOverride, contracts, AsyncClientResponseProvider.class, provider));
            }
            catch (Exception e) {
                throw new RuntimeException(Messages.MESSAGES.unableToInstantiateAsyncClientResponseProvider(), e);
            }
        }
        if (this.isA(provider, AsyncStreamProvider.class, contracts)) {
            try {
                this.addAsyncStreamProvider(provider);
                newContracts.put(AsyncStreamProvider.class, this.getPriority(priorityOverride, contracts, AsyncStreamProvider.class, provider));
            }
            catch (Exception e) {
                throw new RuntimeException(Messages.MESSAGES.unableToInstantiateAsyncStreamProvider(), e);
            }
        }
        if (this.isA(provider, ClientRequestFilter.class, contracts)) {
            if (this.clientRequestFilterRegistry == null) {
                this.clientRequestFilterRegistry = this.parent.getClientRequestFilterRegistry().clone(this);
            }
            int priority4 = this.getPriority(priorityOverride, contracts, ClientRequestFilter.class, provider);
            this.clientRequestFilterRegistry.registerClass(provider, priority4);
            newContracts.put(ClientRequestFilter.class, priority4);
            if (this.clientRequestFilters == null) {
                this.clientRequestFilters = this.parent.getClientRequestFilters().clone(this);
            }
            this.clientRequestFilters.registerClass(provider, priority4);
        }
        if (this.isA(provider, ClientResponseFilter.class, contracts)) {
            if (this.clientResponseFilters == null) {
                this.clientResponseFilters = this.parent.getClientResponseFilters().clone(this);
            }
            int priority5 = this.getPriority(priorityOverride, contracts, ClientResponseFilter.class, provider);
            this.clientResponseFilters.registerClass(provider, priority5);
            newContracts.put(ClientResponseFilter.class, priority5);
        }
        if (this.isA(provider, ClientExecutionInterceptor.class, contracts)) {
            if (this.clientExecutionInterceptorRegistry == null) {
                this.clientExecutionInterceptorRegistry = this.parent.getClientExecutionInterceptorRegistry().cloneTo(this);
            }
            this.clientExecutionInterceptorRegistry.register((ClientExecutionInterceptor)((Object)provider));
            newContracts.put(ClientExecutionInterceptor.class, 0);
        }
        if (this.isA(provider, PreProcessInterceptor.class, contracts)) {
            if (this.containerRequestFilterRegistry == null) {
                this.containerRequestFilterRegistry = this.parent.getContainerRequestFilterRegistry().clone(this);
            }
            this.containerRequestFilterRegistry.registerLegacy(provider);
            newContracts.put(PreProcessInterceptor.class, 0);
        }
        if (this.isA(provider, PostProcessInterceptor.class, contracts)) {
            if (this.containerResponseFilterRegistry == null) {
                this.containerResponseFilterRegistry = this.parent.getContainerResponseFilterRegistry().clone(this);
            }
            this.containerResponseFilterRegistry.registerLegacy(provider);
            newContracts.put(PostProcessInterceptor.class, 0);
        }
        if (this.isA(provider, ContainerRequestFilter.class, contracts)) {
            if (this.containerRequestFilterRegistry == null) {
                this.containerRequestFilterRegistry = this.parent.getContainerRequestFilterRegistry().clone(this);
            }
            int priority6 = this.getPriority(priorityOverride, contracts, ContainerRequestFilter.class, provider);
            this.containerRequestFilterRegistry.registerClass(provider, priority6);
            newContracts.put(ContainerRequestFilter.class, priority6);
        }
        if (this.isA(provider, ContainerResponseFilter.class, contracts)) {
            if (this.containerResponseFilterRegistry == null) {
                this.containerResponseFilterRegistry = this.parent.getContainerResponseFilterRegistry().clone(this);
            }
            int priority7 = this.getPriority(priorityOverride, contracts, ContainerResponseFilter.class, provider);
            this.containerResponseFilterRegistry.registerClass(provider, priority7);
            newContracts.put(ContainerResponseFilter.class, priority7);
        }
        if (this.isA(provider, ReaderInterceptor.class, contracts)) {
            constrainedTo = provider.getAnnotation(ConstrainedTo.class);
            priority = this.getPriority(priorityOverride, contracts, ReaderInterceptor.class, provider);
            if (constrainedTo != null && constrainedTo.value() == RuntimeType.SERVER) {
                if (this.serverReaderInterceptorRegistry == null) {
                    this.serverReaderInterceptorRegistry = this.parent.getServerReaderInterceptorRegistry().clone(this);
                }
                this.serverReaderInterceptorRegistry.registerClass(provider, priority);
            }
            if (constrainedTo != null && constrainedTo.value() == RuntimeType.CLIENT) {
                if (this.clientReaderInterceptorRegistry == null) {
                    this.clientReaderInterceptorRegistry = this.parent.getClientReaderInterceptorRegistry().clone(this);
                }
                this.clientReaderInterceptorRegistry.registerClass(provider, priority);
            }
            if (constrainedTo == null) {
                if (this.serverReaderInterceptorRegistry == null) {
                    this.serverReaderInterceptorRegistry = this.parent.getServerReaderInterceptorRegistry().clone(this);
                }
                this.serverReaderInterceptorRegistry.registerClass(provider, priority);
                if (this.clientReaderInterceptorRegistry == null) {
                    this.clientReaderInterceptorRegistry = this.parent.getClientReaderInterceptorRegistry().clone(this);
                }
                this.clientReaderInterceptorRegistry.registerClass(provider, priority);
            }
            newContracts.put(ReaderInterceptor.class, priority);
        }
        if (this.isA(provider, WriterInterceptor.class, contracts)) {
            constrainedTo = provider.getAnnotation(ConstrainedTo.class);
            priority = this.getPriority(priorityOverride, contracts, WriterInterceptor.class, provider);
            if (constrainedTo != null && constrainedTo.value() == RuntimeType.SERVER) {
                if (this.serverWriterInterceptorRegistry == null) {
                    this.serverWriterInterceptorRegistry = this.parent.getServerWriterInterceptorRegistry().clone(this);
                }
                this.serverWriterInterceptorRegistry.registerClass(provider, priority);
            }
            if (constrainedTo != null && constrainedTo.value() == RuntimeType.CLIENT) {
                if (this.clientWriterInterceptorRegistry == null) {
                    this.clientWriterInterceptorRegistry = this.parent.getClientWriterInterceptorRegistry().clone(this);
                }
                this.clientWriterInterceptorRegistry.registerClass(provider, priority);
            }
            if (constrainedTo == null) {
                if (this.serverWriterInterceptorRegistry == null) {
                    this.serverWriterInterceptorRegistry = this.parent.getServerWriterInterceptorRegistry().clone(this);
                }
                this.serverWriterInterceptorRegistry.registerClass(provider, priority);
                if (this.clientWriterInterceptorRegistry == null) {
                    this.clientWriterInterceptorRegistry = this.parent.getClientWriterInterceptorRegistry().clone(this);
                }
                this.clientWriterInterceptorRegistry.registerClass(provider, priority);
            }
            newContracts.put(WriterInterceptor.class, priority);
        }
        if (this.isA(provider, MessageBodyWriterInterceptor.class, contracts)) {
            if (provider.isAnnotationPresent(ServerInterceptor.class)) {
                if (this.serverWriterInterceptorRegistry == null) {
                    this.serverWriterInterceptorRegistry = this.parent.getServerWriterInterceptorRegistry().clone(this);
                }
                this.serverWriterInterceptorRegistry.registerLegacy(provider);
            }
            if (provider.isAnnotationPresent(ClientInterceptor.class)) {
                if (this.clientWriterInterceptorRegistry == null) {
                    this.clientWriterInterceptorRegistry = this.parent.getClientWriterInterceptorRegistry().clone(this);
                }
                this.clientWriterInterceptorRegistry.registerLegacy(provider);
            }
            if (!provider.isAnnotationPresent(ServerInterceptor.class) && !provider.isAnnotationPresent(ClientInterceptor.class)) {
                throw new RuntimeException(Messages.MESSAGES.interceptorClassMustBeAnnotated());
            }
            newContracts.put(MessageBodyWriterInterceptor.class, 0);
        }
        if (this.isA(provider, MessageBodyReaderInterceptor.class, contracts)) {
            if (provider.isAnnotationPresent(ServerInterceptor.class)) {
                if (this.serverReaderInterceptorRegistry == null) {
                    this.serverReaderInterceptorRegistry = this.parent.getServerReaderInterceptorRegistry().clone(this);
                }
                this.serverReaderInterceptorRegistry.registerLegacy(provider);
            }
            if (provider.isAnnotationPresent(ClientInterceptor.class)) {
                if (this.clientReaderInterceptorRegistry == null) {
                    this.clientReaderInterceptorRegistry = this.parent.getClientReaderInterceptorRegistry().clone(this);
                }
                this.clientReaderInterceptorRegistry.registerLegacy(provider);
            }
            if (!provider.isAnnotationPresent(ServerInterceptor.class) && !provider.isAnnotationPresent(ClientInterceptor.class)) {
                throw new RuntimeException(Messages.MESSAGES.interceptorClassMustBeAnnotated());
            }
            newContracts.put(MessageBodyReaderInterceptor.class, 0);
        }
        if (this.isA(provider, ContextResolver.class, contracts)) {
            try {
                int priority8 = this.getPriority(priorityOverride, contracts, ContextResolver.class, provider);
                this.addContextResolver(provider, priority8, isBuiltin);
                newContracts.put(ContextResolver.class, priority8);
            }
            catch (Exception e) {
                throw new RuntimeException(Messages.MESSAGES.unableToInstantiateContextResolver(), e);
            }
        }
        if (this.isA(provider, StringConverter.class, contracts)) {
            this.addStringConverter(provider);
            int priority9 = this.getPriority(priorityOverride, contracts, StringConverter.class, provider);
            newContracts.put(StringConverter.class, priority9);
        }
        if (this.isA(provider, StringParameterUnmarshaller.class, contracts)) {
            this.addStringParameterUnmarshaller(provider);
            int priority10 = this.getPriority(priorityOverride, contracts, StringParameterUnmarshaller.class, provider);
            newContracts.put(StringParameterUnmarshaller.class, priority10);
        }
        if (this.isA(provider, InjectorFactory.class, contracts)) {
            try {
                this.injectorFactory = (InjectorFactory)provider.newInstance();
                newContracts.put(InjectorFactory.class, 0);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (this.isA(provider, DynamicFeature.class, contracts)) {
            ConstrainedTo constrainedTo2 = provider.getAnnotation(ConstrainedTo.class);
            priority = this.getPriority(priorityOverride, contracts, DynamicFeature.class, provider);
            if (constrainedTo2 != null && constrainedTo2.value() == RuntimeType.SERVER) {
                if (this.serverDynamicFeatures == null) {
                    this.serverDynamicFeatures = new CopyOnWriteArraySet<DynamicFeature>(this.parent.getServerDynamicFeatures());
                }
                this.serverDynamicFeatures.add((DynamicFeature)this.injectedInstance(provider));
            }
            if (constrainedTo2 != null && constrainedTo2.value() == RuntimeType.CLIENT) {
                if (this.clientDynamicFeatures == null) {
                    this.clientDynamicFeatures = new CopyOnWriteArraySet<DynamicFeature>(this.parent.getClientDynamicFeatures());
                }
                this.clientDynamicFeatures.add((DynamicFeature)this.injectedInstance(provider));
            }
            if (constrainedTo2 == null) {
                if (this.serverDynamicFeatures == null) {
                    this.serverDynamicFeatures = new CopyOnWriteArraySet<DynamicFeature>(this.parent.getServerDynamicFeatures());
                }
                this.serverDynamicFeatures.add((DynamicFeature)this.injectedInstance(provider));
                if (this.clientDynamicFeatures == null) {
                    this.clientDynamicFeatures = new CopyOnWriteArraySet<DynamicFeature>(this.parent.getClientDynamicFeatures());
                }
                this.clientDynamicFeatures.add((DynamicFeature)this.injectedInstance(provider));
            }
            newContracts.put(DynamicFeature.class, priority);
        }
        if (this.isA(provider, Feature.class, contracts)) {
            ConstrainedTo constrainedTo3 = provider.getAnnotation(ConstrainedTo.class);
            priority = this.getPriority(priorityOverride, contracts, Feature.class, provider);
            Feature feature = (Feature)this.injectedInstance(provider);
            if ((constrainedTo3 == null || constrainedTo3.value() == this.getRuntimeType()) && feature.configure((FeatureContext)new FeatureContextDelegate(this))) {
                this.enabledFeatures.add(feature);
            }
            this.featureClasses.add(provider);
            newContracts.put(Feature.class, priority);
        }
        if (this.isA(provider, RxInvokerProvider.class, contracts)) {
            int priority11 = this.getPriority(priorityOverride, contracts, RxInvokerProvider.class, provider);
            newContracts.put(RxInvokerProvider.class, priority11);
            Class clazz = Types.getTemplateParameterOfInterface(provider, RxInvokerProvider.class);
            clazz = Types.getTemplateParameterOfInterface(clazz, RxInvoker.class);
            if (clazz != null) {
                this.reactiveClasses.put(clazz, provider);
            }
        }
        if (this.isA(provider, ResourceClassProcessor.class, contracts)) {
            int priority12 = this.getPriority(priorityOverride, contracts, ResourceClassProcessor.class, provider);
            this.addResourceClassProcessor(provider, priority12);
            newContracts.put(ResourceClassProcessor.class, priority12);
        }
        this.providerClasses.add(provider);
        this.getClassContracts().put(provider, newContracts);
    }

    public void registerProviderInstance(Object provider) {
        this.registerProviderInstance(provider, null, null, false);
    }

    public void registerProviderInstance(Object provider, Map<Class<?>, Integer> contracts, Integer priorityOverride, boolean builtIn) {
        int priority;
        int priority2;
        Class<?> providerClass = provider.getClass();
        if (this.getClassContracts().containsKey(providerClass)) {
            LogMessages.LOGGER.providerInstanceAlreadyRegistered(providerClass.getName());
            return;
        }
        HashMap<Class<ResourceClassProcessor>, Integer> newContracts = new HashMap<Class<ResourceClassProcessor>, Integer>();
        if (this.isA(provider, ParamConverterProvider.class, contracts)) {
            this.injectProperties(provider);
            if (this.sortedParamConverterProviders == null) {
                this.sortedParamConverterProviders = Collections.synchronizedSortedSet(new TreeSet<ExtSortedKey<ParamConverterProvider>>(this.parent.getSortedParamConverterProviders()));
            }
            priority2 = this.getPriority(priorityOverride, contracts, ParamConverterProvider.class, provider.getClass());
            this.sortedParamConverterProviders.add(new ExtSortedKey<ParamConverterProvider>(null, (ParamConverterProvider)provider, provider.getClass(), priority2, builtIn));
            this.paramConverterProviders = null;
            newContracts.put(ParamConverterProvider.class, priority2);
        }
        if (this.isA(provider, MessageBodyReader.class, contracts)) {
            try {
                priority2 = this.getPriority(priorityOverride, contracts, MessageBodyReader.class, provider.getClass());
                this.addMessageBodyReader((MessageBodyReader)provider, priority2, builtIn);
                newContracts.put(MessageBodyReader.class, priority2);
            }
            catch (Exception e) {
                throw new RuntimeException(Messages.MESSAGES.unableToInstantiateMessageBodyReader(), e);
            }
        }
        if (this.isA(provider, MessageBodyWriter.class, contracts)) {
            try {
                priority2 = this.getPriority(priorityOverride, contracts, MessageBodyWriter.class, provider.getClass());
                this.addMessageBodyWriter((MessageBodyWriter)provider, provider.getClass(), priority2, builtIn);
                newContracts.put(MessageBodyWriter.class, priority2);
            }
            catch (Exception e) {
                throw new RuntimeException(Messages.MESSAGES.unableToInstantiateMessageBodyWriter(), e);
            }
        }
        if (this.isA(provider, ExceptionMapper.class, contracts)) {
            try {
                this.addExceptionMapper((ExceptionMapper)provider, builtIn);
                priority2 = this.getPriority(priorityOverride, contracts, ExceptionMapper.class, provider.getClass());
                newContracts.put(ExceptionMapper.class, priority2);
            }
            catch (Exception e) {
                throw new RuntimeException(Messages.MESSAGES.unableToInstantiateExceptionMapper(), e);
            }
        }
        if (this.isA(provider, ClientExceptionMapper.class, contracts)) {
            try {
                this.addClientExceptionMapper((ClientExceptionMapper)provider);
                newContracts.put(ClientExceptionMapper.class, 0);
            }
            catch (Exception e) {
                throw new RuntimeException(Messages.MESSAGES.unableToInstantiateExceptionMapper(), e);
            }
        }
        if (this.isA(provider, AsyncResponseProvider.class, contracts)) {
            try {
                this.addAsyncResponseProvider((AsyncResponseProvider)provider);
                priority2 = this.getPriority(priorityOverride, contracts, AsyncResponseProvider.class, provider.getClass());
                newContracts.put(AsyncResponseProvider.class, priority2);
            }
            catch (Exception e) {
                throw new RuntimeException(Messages.MESSAGES.unableToInstantiateAsyncResponseProvider(), e);
            }
        }
        if (this.isA(provider, AsyncClientResponseProvider.class, contracts)) {
            try {
                this.addAsyncClientResponseProvider((AsyncClientResponseProvider)provider);
                priority2 = this.getPriority(priorityOverride, contracts, AsyncClientResponseProvider.class, provider.getClass());
                newContracts.put(AsyncClientResponseProvider.class, priority2);
            }
            catch (Exception e) {
                throw new RuntimeException(Messages.MESSAGES.unableToInstantiateAsyncClientResponseProvider(), e);
            }
        }
        if (this.isA(provider, AsyncStreamProvider.class, contracts)) {
            try {
                this.addAsyncStreamProvider((AsyncStreamProvider)provider);
                priority2 = this.getPriority(priorityOverride, contracts, AsyncStreamProvider.class, provider.getClass());
                newContracts.put(AsyncStreamProvider.class, priority2);
            }
            catch (Exception e) {
                throw new RuntimeException(Messages.MESSAGES.unableToInstantiateAsyncStreamProvider(), e);
            }
        }
        if (this.isA(provider, ContextResolver.class, contracts)) {
            try {
                priority2 = this.getPriority(priorityOverride, contracts, ContextResolver.class, provider.getClass());
                this.addContextResolver((ContextResolver)provider, priority2);
                newContracts.put(ContextResolver.class, priority2);
            }
            catch (Exception e) {
                throw new RuntimeException(Messages.MESSAGES.unableToInstantiateContextResolver(), e);
            }
        }
        if (this.isA(provider, ClientRequestFilter.class, contracts)) {
            if (this.clientRequestFilterRegistry == null) {
                this.clientRequestFilterRegistry = this.parent.getClientRequestFilterRegistry().clone(this);
            }
            priority2 = this.getPriority(priorityOverride, contracts, ClientRequestFilter.class, provider.getClass());
            this.clientRequestFilterRegistry.registerSingleton((ClientRequestFilter)provider, priority2);
            newContracts.put(ClientRequestFilter.class, priority2);
            if (this.clientRequestFilters == null) {
                this.clientRequestFilters = this.parent.getClientRequestFilters().clone(this);
            }
            this.clientRequestFilters.registerSingleton((ClientRequestFilter)provider, priority2);
        }
        if (this.isA(provider, ClientResponseFilter.class, contracts)) {
            if (this.clientResponseFilters == null) {
                this.clientResponseFilters = this.parent.getClientResponseFilters().clone(this);
            }
            priority2 = this.getPriority(priorityOverride, contracts, ClientResponseFilter.class, provider.getClass());
            this.clientResponseFilters.registerSingleton((ClientResponseFilter)provider, priority2);
            newContracts.put(ClientResponseFilter.class, priority2);
        }
        if (this.isA(provider, ClientExecutionInterceptor.class, contracts)) {
            if (this.clientExecutionInterceptorRegistry == null) {
                this.clientExecutionInterceptorRegistry = this.parent.getClientExecutionInterceptorRegistry().cloneTo(this);
            }
            this.clientExecutionInterceptorRegistry.register((ClientExecutionInterceptor)provider);
            newContracts.put(ClientExecutionInterceptor.class, 0);
        }
        if (this.isA(provider, PreProcessInterceptor.class, contracts)) {
            if (this.containerRequestFilterRegistry == null) {
                this.containerRequestFilterRegistry = this.parent.getContainerRequestFilterRegistry().clone(this);
            }
            this.containerRequestFilterRegistry.registerLegacy((PreProcessInterceptor)provider);
            newContracts.put(PreProcessInterceptor.class, 0);
        }
        if (this.isA(provider, ContainerRequestFilter.class, contracts)) {
            if (this.containerRequestFilterRegistry == null) {
                this.containerRequestFilterRegistry = this.parent.getContainerRequestFilterRegistry().clone(this);
            }
            priority2 = this.getPriority(priorityOverride, contracts, ContainerRequestFilter.class, provider.getClass());
            this.containerRequestFilterRegistry.registerSingleton((ContainerRequestFilter)provider, priority2);
            newContracts.put(ContainerRequestFilter.class, priority2);
        }
        if (this.isA(provider, PostProcessInterceptor.class, contracts)) {
            if (this.containerResponseFilterRegistry == null) {
                this.containerResponseFilterRegistry = this.parent.getContainerResponseFilterRegistry().clone(this);
            }
            this.containerResponseFilterRegistry.registerLegacy((PostProcessInterceptor)provider);
            newContracts.put(PostProcessInterceptor.class, 0);
        }
        if (this.isA(provider, ContainerResponseFilter.class, contracts)) {
            if (this.containerResponseFilterRegistry == null) {
                this.containerResponseFilterRegistry = this.parent.getContainerResponseFilterRegistry().clone(this);
            }
            priority2 = this.getPriority(priorityOverride, contracts, ContainerResponseFilter.class, provider.getClass());
            this.containerResponseFilterRegistry.registerSingleton((ContainerResponseFilter)provider, priority2);
            newContracts.put(ContainerResponseFilter.class, priority2);
        }
        if (this.isA(provider, ReaderInterceptor.class, contracts)) {
            ConstrainedTo constrainedTo = provider.getClass().getAnnotation(ConstrainedTo.class);
            priority = this.getPriority(priorityOverride, contracts, ReaderInterceptor.class, provider.getClass());
            if (constrainedTo != null && constrainedTo.value() == RuntimeType.SERVER) {
                if (this.serverReaderInterceptorRegistry == null) {
                    this.serverReaderInterceptorRegistry = this.parent.getServerReaderInterceptorRegistry().clone(this);
                }
                this.serverReaderInterceptorRegistry.registerSingleton((ReaderInterceptor)provider, priority);
            }
            if (constrainedTo != null && constrainedTo.value() == RuntimeType.CLIENT) {
                if (this.clientReaderInterceptorRegistry == null) {
                    this.clientReaderInterceptorRegistry = this.parent.getClientReaderInterceptorRegistry().clone(this);
                }
                this.clientReaderInterceptorRegistry.registerSingleton((ReaderInterceptor)provider, priority);
            }
            if (constrainedTo == null) {
                if (this.serverReaderInterceptorRegistry == null) {
                    this.serverReaderInterceptorRegistry = this.parent.getServerReaderInterceptorRegistry().clone(this);
                }
                this.serverReaderInterceptorRegistry.registerSingleton((ReaderInterceptor)provider, priority);
                if (this.clientReaderInterceptorRegistry == null) {
                    this.clientReaderInterceptorRegistry = this.parent.getClientReaderInterceptorRegistry().clone(this);
                }
                this.clientReaderInterceptorRegistry.registerSingleton((ReaderInterceptor)provider, priority);
            }
            newContracts.put(ReaderInterceptor.class, priority);
        }
        if (this.isA(provider, WriterInterceptor.class, contracts)) {
            ConstrainedTo constrainedTo = provider.getClass().getAnnotation(ConstrainedTo.class);
            priority = this.getPriority(priorityOverride, contracts, WriterInterceptor.class, provider.getClass());
            if (constrainedTo != null && constrainedTo.value() == RuntimeType.SERVER) {
                if (this.serverWriterInterceptorRegistry == null) {
                    this.serverWriterInterceptorRegistry = this.parent.getServerWriterInterceptorRegistry().clone(this);
                }
                this.serverWriterInterceptorRegistry.registerSingleton((WriterInterceptor)provider, priority);
            }
            if (constrainedTo != null && constrainedTo.value() == RuntimeType.CLIENT) {
                if (this.clientWriterInterceptorRegistry == null) {
                    this.clientWriterInterceptorRegistry = this.parent.getClientWriterInterceptorRegistry().clone(this);
                }
                this.clientWriterInterceptorRegistry.registerSingleton((WriterInterceptor)provider, priority);
            }
            if (constrainedTo == null) {
                if (this.serverWriterInterceptorRegistry == null) {
                    this.serverWriterInterceptorRegistry = this.parent.getServerWriterInterceptorRegistry().clone(this);
                }
                this.serverWriterInterceptorRegistry.registerSingleton((WriterInterceptor)provider, priority);
                if (this.clientWriterInterceptorRegistry == null) {
                    this.clientWriterInterceptorRegistry = this.parent.getClientWriterInterceptorRegistry().clone(this);
                }
                this.clientWriterInterceptorRegistry.registerSingleton((WriterInterceptor)provider, priority);
            }
            newContracts.put(WriterInterceptor.class, priority);
        }
        if (this.isA(provider, MessageBodyWriterInterceptor.class, contracts)) {
            if (provider.getClass().isAnnotationPresent(ServerInterceptor.class)) {
                if (this.serverWriterInterceptorRegistry == null) {
                    this.serverWriterInterceptorRegistry = this.parent.getServerWriterInterceptorRegistry().clone(this);
                }
                this.serverWriterInterceptorRegistry.registerLegacy((MessageBodyWriterInterceptor)provider);
            }
            if (provider.getClass().isAnnotationPresent(ClientInterceptor.class)) {
                if (this.clientWriterInterceptorRegistry == null) {
                    this.clientWriterInterceptorRegistry = this.parent.getClientWriterInterceptorRegistry().clone(this);
                }
                this.clientWriterInterceptorRegistry.registerLegacy((MessageBodyWriterInterceptor)provider);
            }
            if (!provider.getClass().isAnnotationPresent(ServerInterceptor.class) && !provider.getClass().isAnnotationPresent(ClientInterceptor.class)) {
                throw new RuntimeException(Messages.MESSAGES.interceptorClassMustBeAnnotatedWithClass(provider.getClass()));
            }
            newContracts.put(MessageBodyWriterInterceptor.class, 0);
        }
        if (this.isA(provider, MessageBodyReaderInterceptor.class, contracts)) {
            if (provider.getClass().isAnnotationPresent(ServerInterceptor.class)) {
                if (this.serverReaderInterceptorRegistry == null) {
                    this.serverReaderInterceptorRegistry = this.parent.getServerReaderInterceptorRegistry().clone(this);
                }
                this.serverReaderInterceptorRegistry.registerLegacy((MessageBodyReaderInterceptor)provider);
            }
            if (provider.getClass().isAnnotationPresent(ClientInterceptor.class)) {
                if (this.clientReaderInterceptorRegistry == null) {
                    this.clientReaderInterceptorRegistry = this.parent.getClientReaderInterceptorRegistry().clone(this);
                }
                this.clientReaderInterceptorRegistry.registerLegacy((MessageBodyReaderInterceptor)provider);
            }
            if (!provider.getClass().isAnnotationPresent(ServerInterceptor.class) && !provider.getClass().isAnnotationPresent(ClientInterceptor.class)) {
                throw new RuntimeException(Messages.MESSAGES.interceptorClassMustBeAnnotatedWithClass(provider.getClass()));
            }
            newContracts.put(MessageBodyReaderInterceptor.class, 0);
        }
        if (this.isA(provider, StringConverter.class, contracts)) {
            this.addStringConverter((StringConverter)provider);
            newContracts.put(StringConverter.class, 0);
        }
        if (this.isA(provider, InjectorFactory.class, contracts)) {
            this.injectorFactory = (InjectorFactory)provider;
            newContracts.put(InjectorFactory.class, 0);
        }
        if (this.isA(provider, DynamicFeature.class, contracts)) {
            ConstrainedTo constrainedTo = provider.getClass().getAnnotation(ConstrainedTo.class);
            priority = this.getPriority(priorityOverride, contracts, DynamicFeature.class, provider.getClass());
            if (constrainedTo != null && constrainedTo.value() == RuntimeType.SERVER) {
                if (this.serverDynamicFeatures == null) {
                    this.serverDynamicFeatures = new CopyOnWriteArraySet<DynamicFeature>(this.parent.getServerDynamicFeatures());
                }
                this.serverDynamicFeatures.add((DynamicFeature)provider);
            }
            if (constrainedTo != null && constrainedTo.value() == RuntimeType.CLIENT) {
                if (this.clientDynamicFeatures == null) {
                    this.clientDynamicFeatures = new CopyOnWriteArraySet<DynamicFeature>(this.parent.getClientDynamicFeatures());
                }
                this.clientDynamicFeatures.add((DynamicFeature)provider);
            }
            if (constrainedTo == null) {
                if (this.serverDynamicFeatures == null) {
                    this.serverDynamicFeatures = new CopyOnWriteArraySet<DynamicFeature>(this.parent.getServerDynamicFeatures());
                }
                this.serverDynamicFeatures.add((DynamicFeature)provider);
                if (this.clientDynamicFeatures == null) {
                    this.clientDynamicFeatures = new CopyOnWriteArraySet<DynamicFeature>(this.parent.getClientDynamicFeatures());
                }
                this.clientDynamicFeatures.add((DynamicFeature)provider);
            }
            newContracts.put(DynamicFeature.class, priority);
        }
        if (this.isA(provider, Feature.class, contracts)) {
            Feature feature = (Feature)provider;
            this.injectProperties(provider.getClass(), provider);
            ConstrainedTo constrainedTo = provider.getClass().getAnnotation(ConstrainedTo.class);
            if ((constrainedTo == null || constrainedTo.value() == this.getRuntimeType()) && feature.configure((FeatureContext)new FeatureContextDelegate(this))) {
                this.enabledFeatures.add(feature);
            }
            int priority3 = this.getPriority(priorityOverride, contracts, Feature.class, provider.getClass());
            this.featureInstances.add(provider);
            newContracts.put(Feature.class, priority3);
        }
        if (this.isA(provider, ResourceClassProcessor.class, contracts)) {
            int priority4 = this.getPriority(priorityOverride, contracts, ResourceClassProcessor.class, provider.getClass());
            this.addResourceClassProcessor((ResourceClassProcessor)provider, priority4);
            newContracts.put(ResourceClassProcessor.class, priority4);
        }
        this.providerInstances.add(provider);
        this.getClassContracts().put(provider.getClass(), newContracts);
    }

    public <T extends Throwable> ExceptionMapper<T> getExceptionMapper(Class<T> type) {
        Class<T> exceptionType = type;
        SortedKey<ExceptionMapper> mapper = null;
        while (mapper == null && exceptionType != null) {
            mapper = this.getSortedExceptionMappers().get(exceptionType);
            if (mapper != null) continue;
            exceptionType = exceptionType.getSuperclass();
        }
        return mapper != null ? (ExceptionMapper)mapper.getObj() : null;
    }

    public <T extends Throwable> ClientExceptionMapper<T> getClientExceptionMapper(Class<T> type) {
        return this.getClientExceptionMappers().get(type);
    }

    public <T> AsyncResponseProvider<T> getAsyncResponseProvider(Class<T> type) {
        Class<T> asyncType = type;
        AsyncResponseProvider mapper = null;
        while (mapper == null && asyncType != null) {
            mapper = this.getAsyncResponseProviders().get(asyncType);
            if (mapper != null) continue;
            asyncType = asyncType.getSuperclass();
        }
        return mapper;
    }

    public <T> AsyncClientResponseProvider<T> getAsyncClientResponseProvider(Class<T> type) {
        Class<T> asyncType = type;
        AsyncClientResponseProvider mapper = null;
        while (mapper == null && asyncType != null) {
            mapper = this.getAsyncClientResponseProviders().get(asyncType);
            if (mapper != null) continue;
            asyncType = asyncType.getSuperclass();
        }
        return mapper;
    }

    public <T> AsyncStreamProvider<T> getAsyncStreamProvider(Class<T> type) {
        Class<T> asyncType = type;
        AsyncStreamProvider mapper = null;
        while (mapper == null && asyncType != null) {
            mapper = this.getAsyncStreamProviders().get(asyncType);
            if (mapper != null) continue;
            asyncType = asyncType.getSuperclass();
        }
        return mapper;
    }

    public MediaType getConcreteMediaTypeFromMessageBodyWriters(Class type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        List<SortedKey<MessageBodyWriter>> writers = this.getServerMessageBodyWriters().getPossible(mediaType, type);
        for (SortedKey<MessageBodyWriter> writer : writers) {
            Produces produces;
            MessageBodyWriter mbw;
            Class writerType;
            if (!((MessageBodyWriter)writer.obj).isWriteable(type, genericType, annotations, mediaType) || (writerType = Types.getTemplateParameterOfInterface((mbw = (MessageBodyWriter)writer.obj).getClass(), MessageBodyWriter.class)) == null || writerType.equals(Object.class) || !writerType.isAssignableFrom(type) || (produces = mbw.getClass().getAnnotation(Produces.class)) == null) continue;
            for (String produce : produces.value()) {
                MediaType mt = MediaType.valueOf((String)produce);
                if (mt.isWildcardType() || mt.isWildcardSubtype()) continue;
                return mt;
            }
        }
        return null;
    }

    public Map<MessageBodyWriter<?>, Class<?>> getPossibleMessageBodyWritersMap(Class type, Type genericType, Annotation[] annotations, MediaType accept) {
        HashMap map = new HashMap();
        List<SortedKey<MessageBodyWriter>> writers = this.getServerMessageBodyWriters().getPossible(accept, type);
        for (SortedKey<MessageBodyWriter> writer : writers) {
            Class writerType;
            if (!((MessageBodyWriter)writer.obj).isWriteable(type, genericType, annotations, accept)) continue;
            Class<?> mbwc = ((MessageBodyWriter)writer.obj).getClass();
            if (!mbwc.isInterface() && mbwc.getSuperclass() != null && !mbwc.getSuperclass().equals(Object.class) && mbwc.isSynthetic()) {
                mbwc = mbwc.getSuperclass();
            }
            if ((writerType = Types.getTemplateParameterOfInterface(mbwc, MessageBodyWriter.class)) == null || !writerType.isAssignableFrom(type)) continue;
            map.put((MessageBodyWriter<?>)writer.obj, writerType);
        }
        return map;
    }

    public <T> MessageBodyWriter<T> getServerMessageBodyWriter(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        MediaTypeMap<SortedKey<MessageBodyWriter>> availableWriters = this.getServerMessageBodyWriters();
        return this.resolveMessageBodyWriter(type, genericType, annotations, mediaType, availableWriters);
    }

    public <T> MessageBodyWriter<T> getMessageBodyWriter(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        MediaTypeMap<SortedKey<MessageBodyWriter>> availableWriters = this.getServerMessageBodyWriters();
        MessageBodyWriter<T> writer = this.resolveMessageBodyWriter(type, genericType, annotations, mediaType, availableWriters);
        if (writer != null) {
            LogMessages.LOGGER.debugf("MessageBodyWriter: %s", writer.getClass().getName());
        }
        return writer;
    }

    public <T> MessageBodyWriter<T> getClientMessageBodyWriter(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        MediaTypeMap<SortedKey<MessageBodyWriter>> availableWriters = this.getClientMessageBodyWriters();
        return this.resolveMessageBodyWriter(type, genericType, annotations, mediaType, availableWriters);
    }

    protected <T> MessageBodyWriter<T> resolveMessageBodyWriter(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType, MediaTypeMap<SortedKey<MessageBodyWriter>> availableWriters) {
        List<SortedKey<MessageBodyWriter>> writers = availableWriters.getPossible(mediaType, type);
        for (SortedKey<MessageBodyWriter> writer : writers) {
            if (!((MessageBodyWriter)writer.obj).isWriteable(type, genericType, annotations, mediaType)) continue;
            LogMessages.LOGGER.debugf("MessageBodyWriter: %s", writer.getClass().getName());
            return (MessageBodyWriter)writer.obj;
        }
        return null;
    }

    public <T> T createEndpoint(Application applicationConfig, Class<T> endpointType) throws IllegalArgumentException, UnsupportedOperationException {
        if (applicationConfig == null) {
            throw new IllegalArgumentException(Messages.MESSAGES.applicationParamNull());
        }
        throw new UnsupportedOperationException();
    }

    public <T> ContextResolver<T> getContextResolver(Class<T> contextType, MediaType mediaType) {
        final List<ContextResolver> resolvers = this.getContextResolvers(contextType, mediaType);
        if (resolvers == null) {
            return null;
        }
        if (resolvers.size() == 1) {
            return resolvers.get(0);
        }
        return new ContextResolver<T>(){

            public T getContext(Class type) {
                for (ContextResolver resolver : resolvers) {
                    Object rtn = resolver.getContext(type);
                    if (rtn == null) continue;
                    return rtn;
                }
                return null;
            }
        };
    }

    public <T> T createProviderInstance(Class<? extends T> clazz) {
        ConstructorInjector constructorInjector = this.createConstructorInjector(clazz);
        Object provider = constructorInjector.construct();
        return (T)provider;
    }

    public <T> ConstructorInjector createConstructorInjector(Class<? extends T> clazz) {
        Constructor constructor = PickConstructor.pickSingletonConstructor(clazz);
        if (constructor == null) {
            throw new IllegalArgumentException(Messages.MESSAGES.unableToFindPublicConstructorForProvider(clazz.getName()));
        }
        return this.getInjectorFactory().createConstructor(constructor, this);
    }

    public <T> T injectedInstance(Class<? extends T> clazz) {
        Constructor constructor = PickConstructor.pickSingletonConstructor(clazz);
        Object obj = null;
        ConstructorInjector constructorInjector = this.getInjectorFactory().createConstructor(constructor, this);
        obj = constructorInjector.construct();
        PropertyInjector propertyInjector = this.getInjectorFactory().createPropertyInjector(clazz, this);
        propertyInjector.inject(obj);
        return (T)obj;
    }

    public void registerSingletonResource(SingletonResource resource) {
        this.singletonResourceFactories.put(resource.getScannableClass(), resource);
    }

    private <T> boolean isSingletonResource(Class<T> resourceClass) {
        return this.singletonResourceFactories.containsKey(resourceClass);
    }

    public <T> T injectedInstance(Class<? extends T> clazz, HttpRequest request, HttpResponse response) {
        Object obj = null;
        if (this.isSingletonResource(clazz)) {
            SingletonResource factory = this.singletonResourceFactories.get(clazz);
            obj = CompletableFuture.completedFuture(factory.createResource(request, response, this)).toCompletableFuture().getNow(null);
        } else {
            Constructor constructor = PickConstructor.pickSingletonConstructor(clazz);
            if (constructor == null) {
                throw new IllegalArgumentException(Messages.MESSAGES.unableToFindPublicConstructorForClass(clazz.getName()));
            }
            ConstructorInjector constructorInjector = this.getInjectorFactory().createConstructor(constructor, this);
            obj = constructorInjector.construct(request, response);
        }
        PropertyInjector propertyInjector = this.getInjectorFactory().createPropertyInjector(clazz, this);
        propertyInjector.inject(request, response, obj);
        return (T)obj;
    }

    public void injectProperties(Class declaring, Object obj) {
        this.getInjectorFactory().createPropertyInjector(declaring, this).inject(obj);
    }

    public void injectProperties(Object obj) {
        this.getInjectorFactory().createPropertyInjector(obj.getClass(), this).inject(obj);
    }

    public void injectProperties(Object obj, HttpRequest request, HttpResponse response) {
        this.getInjectorFactory().createPropertyInjector(obj.getClass(), this).inject(request, response, obj);
    }

    public Map<String, Object> getMutableProperties() {
        return this.properties;
    }

    public Map<String, Object> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public ResteasyProviderFactory setProperties(Map<String, ?> properties) {
        ConcurrentHashMap<String, Object> newProp = new ConcurrentHashMap<String, Object>();
        newProp.putAll(properties);
        this.properties = newProp;
        return this;
    }

    public ResteasyProviderFactory property(String name, Object value) {
        if (value == null) {
            this.properties.remove(name);
        } else {
            this.properties.put(name, value);
        }
        return this;
    }

    public Collection<Feature> getEnabledFeatures() {
        if (this.initialized) {
            return this.enabledFeatures;
        }
        HashSet<Feature> set = new HashSet<Feature>();
        if (this.parent != null) {
            set.addAll(this.parent.getEnabledFeatures());
        }
        set.addAll(this.enabledFeatures);
        return set;
    }

    public Set<Class<?>> getFeatureClasses() {
        if (this.featureClasses == null && this.parent != null) {
            return this.parent.getFeatureClasses();
        }
        HashSet set = new HashSet();
        if (this.parent != null) {
            set.addAll(this.parent.getFeatureClasses());
        }
        set.addAll(this.featureClasses);
        return set;
    }

    public Set<Object> getFeatureInstances() {
        if (this.featureInstances == null && this.parent != null) {
            return this.parent.getFeatureInstances();
        }
        HashSet<Object> set = new HashSet<Object>();
        if (this.parent != null) {
            set.addAll(this.parent.getFeatureInstances());
        }
        set.addAll(this.featureInstances);
        return set;
    }

    public ResteasyProviderFactory register(Class<?> providerClass) {
        this.registerProvider(providerClass);
        return this;
    }

    public ResteasyProviderFactory register(Object provider) {
        this.registerProviderInstance(provider);
        return this;
    }

    public ResteasyProviderFactory register(Class<?> componentClass, int priority) {
        this.registerProvider(componentClass, priority, false, null);
        return this;
    }

    public ResteasyProviderFactory register(Class<?> componentClass, Class<?> ... contracts) {
        if (contracts == null || contracts.length == 0) {
            LogMessages.LOGGER.attemptingToRegisterEmptyContracts(componentClass.getName());
            return this;
        }
        HashMap cons = new HashMap();
        for (Class<?> contract : contracts) {
            if (!contract.isAssignableFrom(componentClass)) {
                LogMessages.LOGGER.attemptingToRegisterUnassignableContract(componentClass.getName());
                return this;
            }
            cons.put(contract, 5000);
        }
        this.registerProvider(componentClass, null, false, cons);
        return this;
    }

    public ResteasyProviderFactory register(Object component, int priority) {
        this.registerProviderInstance(component, null, priority, false);
        return this;
    }

    public ResteasyProviderFactory register(Object component, Class<?> ... contracts) {
        if (contracts == null || contracts.length == 0) {
            LogMessages.LOGGER.attemptingToRegisterEmptyContracts(component.getClass().getName());
            return this;
        }
        HashMap cons = new HashMap();
        for (Class<?> contract : contracts) {
            if (!contract.isAssignableFrom(component.getClass())) {
                LogMessages.LOGGER.attemptingToRegisterUnassignableContract(component.getClass().getName());
                return this;
            }
            cons.put(contract, 5000);
        }
        this.registerProviderInstance(component, cons, null, false);
        return this;
    }

    public ResteasyProviderFactory register(Class<?> componentClass, Map<Class<?>, Integer> contracts) {
        for (Class<?> contract : contracts.keySet()) {
            if (contract.isAssignableFrom(componentClass)) continue;
            LogMessages.LOGGER.attemptingToRegisterUnassignableContract(componentClass.getName());
            return this;
        }
        this.registerProvider(componentClass, null, false, contracts);
        return this;
    }

    public ResteasyProviderFactory register(Object component, Map<Class<?>, Integer> contracts) {
        for (Class<?> contract : contracts.keySet()) {
            if (contract.isAssignableFrom(component.getClass())) continue;
            LogMessages.LOGGER.attemptingToRegisterUnassignableContract(component.getClass().getName());
            return this;
        }
        this.registerProviderInstance(component, contracts, null, false);
        return this;
    }

    public Configuration getConfiguration() {
        return this;
    }

    public RuntimeType getRuntimeType() {
        return RuntimeType.SERVER;
    }

    public Collection<String> getPropertyNames() {
        return this.getProperties().keySet();
    }

    public boolean isEnabled(Feature feature) {
        return this.getEnabledFeatures().contains(feature);
    }

    public boolean isEnabled(Class<? extends Feature> featureClass) {
        Collection<Feature> enabled = this.getEnabledFeatures();
        if (enabled == null) {
            return false;
        }
        for (Feature feature : enabled) {
            if (!featureClass.equals(feature.getClass())) continue;
            return true;
        }
        return false;
    }

    public boolean isRegistered(Object component) {
        return this.getProviderInstances().contains(component);
    }

    public boolean isRegistered(Class<?> componentClass) {
        return this.getClassContracts().containsKey(componentClass);
    }

    public Map<Class<?>, Integer> getContracts(Class<?> componentClass) {
        if (this.classContracts == null && this.parent == null) {
            return Collections.emptyMap();
        }
        if (this.classContracts == null) {
            return this.parent.getContracts(componentClass);
        }
        Map<Class<?>, Integer> classIntegerMap = this.classContracts.get(componentClass);
        if (classIntegerMap == null) {
            return Collections.emptyMap();
        }
        return classIntegerMap;
    }

    public Set<Class<?>> getClasses() {
        Set<Class<?>> providerClasses = this.getProviderClasses();
        return providerClasses == null || providerClasses.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(providerClasses);
    }

    public Set<Object> getInstances() {
        Set<Object> providerInstances = this.getProviderInstances();
        return providerInstances == null || providerInstances.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(providerInstances);
    }

    public Link.Builder createLinkBuilder() {
        return new LinkBuilderImpl();
    }

    public <I extends RxInvoker> RxInvokerProvider<I> getRxInvokerProvider(Class<I> clazz) {
        for (Map.Entry<Class<?>, Map<Class<?>, Integer>> entry : this.classContracts.entrySet()) {
            RxInvokerProvider rip;
            if (!entry.getValue().containsKey(RxInvokerProvider.class) || !(rip = (RxInvokerProvider)this.createProviderInstance(entry.getKey())).isProviderFor(clazz)) continue;
            return rip;
        }
        return null;
    }

    protected void addResourceClassProcessor(Class<ResourceClassProcessor> processorClass, int priority) {
        ResourceClassProcessor processor = this.createProviderInstance(processorClass);
        this.addResourceClassProcessor(processor, priority);
    }

    protected void addResourceClassProcessor(ResourceClassProcessor processor, int priority) {
        this.resourceBuilder.registerResourceClassProcessor(processor, priority);
    }

    public ResourceBuilder getResourceBuilder() {
        return this.resourceBuilder;
    }

    public RxInvokerProvider<?> getRxInvokerProviderFromReactiveClass(Class<?> clazz) {
        Class<? extends RxInvokerProvider<?>> rxInvokerProviderClass = this.reactiveClasses.get(clazz);
        if (rxInvokerProviderClass != null) {
            return this.createProviderInstance(rxInvokerProviderClass);
        }
        return null;
    }

    public boolean isReactive(Class<?> clazz) {
        return this.reactiveClasses.keySet().contains(clazz);
    }

    public void initializeClientProviders(ResteasyProviderFactory factory) {
        this.clientRequestFilterRegistry = factory == null ? new ClientRequestFilterRegistry(this) : factory.getClientRequestFilterRegistry().clone(this);
        this.clientRequestFilters = factory == null ? new JaxrsInterceptorRegistry<ClientRequestFilter>(this, ClientRequestFilter.class) : factory.getClientRequestFilters().clone(this);
        this.clientResponseFilters = factory == null ? new ClientResponseFilterRegistry(this) : factory.getClientResponseFilters().clone(this);
    }

    public StatisticsController getStatisticsController() {
        return this.statisticsController;
    }

    protected boolean isOnServer() {
        return ResteasyProviderFactory.searchContextData(Dispatcher.class) != null;
    }

    static {
        registerBuiltinByDefault = true;
        RD_LOCK = new Object();
    }

    public static interface CloseableContext
    extends AutoCloseable {
        @Override
        public void close();
    }

    protected static class ExtSortedKey<T>
    extends SortedKey<T> {
        protected ExtSortedKey(Class<?> intf, T reader, Class<?> readerClass, int priority, boolean isBuiltin) {
            super(intf, reader, readerClass, priority, isBuiltin);
        }

        protected ExtSortedKey(Class<?> intf, T reader, Class<?> readerClass, boolean isBuiltin) {
            super(intf, reader, readerClass, isBuiltin);
        }

        protected ExtSortedKey(Class<?> intf, T reader, Class<?> readerClass) {
            super(intf, reader, readerClass);
        }

        @Override
        public int compareTo(SortedKey<T> tMessageBodyKey) {
            int c = super.compareTo(tMessageBodyKey);
            if (c != 0) {
                return c;
            }
            if (this.obj == tMessageBodyKey.obj) {
                return 0;
            }
            return -1;
        }
    }

    protected static class SortedKey<T>
    implements Comparable<SortedKey<T>>,
    MediaTypeMap.Typed {
        public Class<?> readerClass;
        public T obj;
        public boolean isBuiltin = false;
        public Class<?> template = null;
        public int priority = 5000;

        protected SortedKey(Class<?> intf, T reader, Class<?> readerClass, int priority, boolean isBuiltin) {
            this(intf, reader, readerClass);
            this.priority = priority;
            this.isBuiltin = isBuiltin;
        }

        protected SortedKey(Class<?> intf, T reader, Class<?> readerClass, boolean isBuiltin) {
            this(intf, reader, readerClass);
            this.isBuiltin = isBuiltin;
        }

        protected SortedKey(Class<?> intf, T reader, Class<?> readerClass) {
            this.readerClass = readerClass;
            this.obj = reader;
            this.template = Types.getTemplateParameterOfInterface(readerClass, intf);
            if (this.template == null) {
                this.template = Object.class;
            }
        }

        @Override
        public int compareTo(SortedKey<T> tMessageBodyKey) {
            if (this == tMessageBodyKey) {
                return 0;
            }
            if (this.isBuiltin == tMessageBodyKey.isBuiltin) {
                if (this.priority < tMessageBodyKey.priority) {
                    return -1;
                }
                if (this.priority == tMessageBodyKey.priority) {
                    return 0;
                }
                if (this.priority > tMessageBodyKey.priority) {
                    return 1;
                }
            }
            if (this.isBuiltin) {
                return 1;
            }
            return -1;
        }

        @Override
        public Class<?> getType() {
            return this.template;
        }

        public T getObj() {
            return this.obj;
        }
    }
}

