/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.io.IOException;
import java.lang.reflect.Array;
import org.infinispan.protostream.impl.WireFormat;
import org.wildfly.clustering.marshalling.protostream.Field;
import org.wildfly.clustering.marshalling.protostream.FieldMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.marshalling.protostream.ScalarClass;
import org.wildfly.clustering.marshalling.protostream.ScalarFieldMarshaller;
import org.wildfly.clustering.marshalling.protostream.ScalarMarshaller;

public enum ClassField implements Field<Class<?>>
{
    ANY(ScalarClass.ANY),
    ID(ScalarClass.ID),
    NAME(ScalarClass.NAME),
    FIELD(ScalarClass.FIELD),
    ARRAY(new FieldMarshaller<Class<?>>(){

        @Override
        public Class<?> readFrom(ProtoStreamReader reader) throws IOException {
            int dimensions = reader.readUInt32();
            Class componentClass = Object.class;
            boolean reading = true;
            while (reading) {
                int tag = reader.readTag();
                int index = WireFormat.getTagFieldNumber((int)tag);
                if (index == ANY.getIndex()) {
                    componentClass = (Class)ScalarClass.ANY.readFrom(reader);
                    continue;
                }
                reading = tag != 0 && reader.skipField(tag);
            }
            for (int i = 0; i < dimensions; ++i) {
                componentClass = Array.newInstance(componentClass, 0).getClass();
            }
            return componentClass;
        }

        @Override
        public void writeTo(ProtoStreamWriter writer, Class<?> targetClass) throws IOException {
            int dimensions = 0;
            Class<?> componentClass = targetClass;
            while (componentClass.isArray() && !componentClass.getComponentType().isPrimitive()) {
                componentClass = componentClass.getComponentType();
                ++dimensions;
            }
            writer.writeUInt32NoTag(dimensions);
            if (componentClass != Object.class) {
                writer.writeTag(ANY.getIndex(), ANY.getMarshaller().getWireType());
                ScalarClass.ANY.writeTo(writer, componentClass);
            }
        }

        @Override
        public Class<? extends Class<?>> getJavaClass() {
            return ScalarClass.ANY.getJavaClass();
        }

        @Override
        public int getWireType() {
            return 0;
        }
    });

    private final FieldMarshaller<Class<?>> marshaller;
    private static final ClassField[] FIELDS;

    private ClassField(ScalarMarshaller<Class<?>> value) {
        this(new ScalarFieldMarshaller(value));
    }

    private ClassField(FieldMarshaller<Class<?>> marshaller) {
        this.marshaller = marshaller;
    }

    @Override
    public int getIndex() {
        return this.ordinal() + 1;
    }

    @Override
    public FieldMarshaller<Class<?>> getMarshaller() {
        return this.marshaller;
    }

    static ClassField fromIndex(int index) {
        return index > 0 ? FIELDS[index - 1] : null;
    }

    static {
        FIELDS = ClassField.values();
    }
}

