/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.ActivateCallback;
import org.apache.activemq.artemis.core.server.ActiveMQLockAcquisitionTimeoutException;
import org.apache.activemq.artemis.core.server.ActiveMQScheduledComponent;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.impl.CleaningActivateCallback;
import org.apache.activemq.artemis.core.server.impl.FileBasedNodeManager;
import org.apache.activemq.artemis.utils.UUID;
import org.jboss.logging.Logger;

public class FileLockNodeManager
extends FileBasedNodeManager {
    private static final Logger logger = Logger.getLogger(FileLockNodeManager.class);
    private static final int STATE_LOCK_POS = 0;
    private static final int LIVE_LOCK_POS = 1;
    private static final int BACKUP_LOCK_POS = 2;
    private static final long LOCK_LENGTH = 1L;
    private static final byte LIVE = 76;
    private static final byte FAILINGBACK = 70;
    private static final byte PAUSED = 80;
    private static final byte NOT_STARTED = 78;
    private static final long LOCK_ACCESS_FAILURE_WAIT_TIME_NANOS = TimeUnit.SECONDS.toNanos(2L);
    private static final long LOCK_MONITOR_TIMEOUT_NANOS = TimeUnit.SECONDS.toNanos(2L);
    private volatile FileLock liveLock;
    private FileLock backupLock;
    private final FileChannel[] lockChannels = new FileChannel[3];
    private final long lockAcquisitionTimeoutNanos;
    protected boolean interrupted = false;
    private final ScheduledExecutorService scheduledPool;
    private MonitorLock monitorLock;

    public FileLockNodeManager(File directory, boolean replicatedBackup, ScheduledExecutorService scheduledPool) {
        super(replicatedBackup, directory);
        this.scheduledPool = scheduledPool;
        this.lockAcquisitionTimeoutNanos = -1L;
    }

    public FileLockNodeManager(File directory, boolean replicatedBackup) {
        super(replicatedBackup, directory);
        this.scheduledPool = null;
        this.lockAcquisitionTimeoutNanos = -1L;
    }

    public FileLockNodeManager(File directory, boolean replicatedBackup, long lockAcquisitionTimeout, ScheduledExecutorService scheduledPool) {
        super(replicatedBackup, directory);
        this.scheduledPool = scheduledPool;
        this.lockAcquisitionTimeoutNanos = lockAcquisitionTimeout == -1L ? -1L : TimeUnit.MILLISECONDS.toNanos(lockAcquisitionTimeout);
    }

    @Override
    public synchronized void start() throws Exception {
        if (this.isStarted()) {
            return;
        }
        if (!this.replicatedBackup) {
            this.setUpServerLockFile();
        }
        super.start();
    }

    @Override
    protected synchronized void setUpServerLockFile() throws IOException {
        super.setUpServerLockFile();
        this.lockChannels[0] = this.channel;
        for (int i = 1; i < 3; ++i) {
            if (this.lockChannels[i] != null && this.lockChannels[i].isOpen()) continue;
            File fileLock = this.newFile("serverlock." + i);
            if (!fileLock.exists()) {
                fileLock.createNewFile();
            }
            RandomAccessFile randomFileLock = new RandomAccessFile(fileLock, "rw");
            this.lockChannels[i] = randomFileLock.getChannel();
        }
    }

    @Override
    public synchronized void stop() throws Exception {
        for (FileChannel channel : this.lockChannels) {
            if (channel == null || !channel.isOpen()) continue;
            try {
                channel.close();
            }
            catch (Throwable e) {
                logger.warn((Object)e.getMessage(), e);
            }
        }
        super.stop();
    }

    @Override
    public boolean isAwaitingFailback() throws NodeManager.NodeManagerException {
        return this.getState() == 70;
    }

    @Override
    public boolean isBackupLive() throws NodeManager.NodeManagerException {
        try {
            FileLock liveAttemptLock = this.tryLock(1);
            if (liveAttemptLock == null) {
                return true;
            }
            liveAttemptLock.release();
            return false;
        }
        catch (IOException e) {
            throw new NodeManager.NodeManagerException(e);
        }
    }

    public boolean isLiveLocked() {
        return this.liveLock != null;
    }

    @Override
    public void interrupt() {
        this.interrupted = true;
    }

    @Override
    public final void releaseBackup() throws NodeManager.NodeManagerException {
        try {
            if (this.backupLock != null) {
                this.backupLock.release();
                this.backupLock = null;
            }
        }
        catch (IOException e) {
            throw new NodeManager.NodeManagerException(e);
        }
    }

    @Override
    public void awaitLiveNode() throws NodeManager.NodeManagerException, InterruptedException {
        try {
            byte state;
            logger.debug((Object)"awaiting live node...");
            while (true) {
                state = this.getState();
                while (state == 78 || state == 48) {
                    logger.debug((Object)("awaiting live node startup state='" + state + "'"));
                    Thread.sleep(2000L);
                    state = this.getState();
                }
                this.liveLock = this.lock(1);
                if (this.interrupted) {
                    this.interrupted = false;
                    throw new InterruptedException("Lock was interrupted");
                }
                state = this.getState();
                if (state == 80) {
                    this.liveLock.release();
                    logger.debug((Object)"awaiting live node restarting");
                    Thread.sleep(2000L);
                    continue;
                }
                if (state == 70) {
                    this.liveLock.release();
                    logger.debug((Object)"awaiting live node failing back");
                    Thread.sleep(2000L);
                    continue;
                }
                if (state == 76) break;
            }
            logger.debug((Object)("acquired live node lock state = " + (char)state));
        }
        catch (IOException | ActiveMQLockAcquisitionTimeoutException e) {
            throw new NodeManager.NodeManagerException((Throwable)e);
        }
    }

    @Override
    public void startBackup() throws NodeManager.NodeManagerException {
        assert (!this.replicatedBackup);
        ActiveMQServerLogger.LOGGER.waitingToBecomeBackup();
        try {
            this.backupLock = this.lock(2);
        }
        catch (ActiveMQLockAcquisitionTimeoutException e) {
            throw new NodeManager.NodeManagerException((Throwable)((Object)e));
        }
        ActiveMQServerLogger.LOGGER.gotBackupLock();
        if (this.getUUID() == null) {
            this.readNodeId();
        }
    }

    @Override
    public ActivateCallback startLiveNode() throws NodeManager.NodeManagerException {
        try {
            this.setFailingBack();
            String timeoutMessage = this.lockAcquisitionTimeoutNanos == -1L ? "indefinitely" : TimeUnit.NANOSECONDS.toMillis(this.lockAcquisitionTimeoutNanos) + " milliseconds";
            ActiveMQServerLogger.LOGGER.waitingToObtainLiveLock(timeoutMessage);
            this.liveLock = this.lock(1);
            ActiveMQServerLogger.LOGGER.obtainedLiveLock();
            return new CleaningActivateCallback(){

                @Override
                public void activationComplete() {
                    try {
                        FileLockNodeManager.this.setLive();
                        FileLockNodeManager.this.startLockMonitoring();
                    }
                    catch (Exception e) {
                        ActiveMQServerLogger.LOGGER.warn(e.getMessage(), e);
                        throw e;
                    }
                }
            };
        }
        catch (ActiveMQLockAcquisitionTimeoutException e) {
            throw new NodeManager.NodeManagerException((Throwable)((Object)e));
        }
    }

    @Override
    public void pauseLiveServer() throws NodeManager.NodeManagerException {
        this.stopLockMonitoring();
        this.setPaused();
        try {
            if (this.liveLock != null) {
                this.liveLock.release();
            }
        }
        catch (IOException e) {
            throw new NodeManager.NodeManagerException(e);
        }
    }

    @Override
    public void crashLiveServer() throws NodeManager.NodeManagerException {
        this.stopLockMonitoring();
        if (this.liveLock != null) {
            try {
                this.liveLock.release();
            }
            catch (IOException e) {
                throw new NodeManager.NodeManagerException(e);
            }
            finally {
                this.liveLock = null;
            }
        }
    }

    @Override
    public void awaitLiveStatus() throws NodeManager.NodeManagerException, InterruptedException {
        while (this.getState() != 76) {
            Thread.sleep(2000L);
        }
    }

    private void setLive() throws NodeManager.NodeManagerException {
        this.writeFileLockStatus((byte)76);
    }

    private void setFailingBack() throws NodeManager.NodeManagerException {
        this.writeFileLockStatus((byte)70);
    }

    private void setPaused() throws NodeManager.NodeManagerException {
        this.writeFileLockStatus((byte)80);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFileLockStatus(byte status) throws NodeManager.NodeManagerException {
        if (this.replicatedBackup && this.channel == null) {
            return;
        }
        logger.debug((Object)("writing status: " + status));
        ByteBuffer bb = ByteBuffer.allocateDirect(1);
        bb.put(status);
        bb.position(0);
        try {
            if (!this.channel.isOpen()) {
                this.setUpServerLockFile();
            }
            FileLock lock = null;
            try {
                lock = this.lock(0);
                this.channel.write(bb, 0L);
                this.channel.force(true);
            }
            finally {
                if (lock != null) {
                    lock.release();
                }
            }
        }
        catch (IOException | ActiveMQLockAcquisitionTimeoutException e) {
            throw new NodeManager.NodeManagerException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte getState() throws NodeManager.NodeManagerException {
        try {
            byte result;
            logger.debug((Object)"getting state...");
            ByteBuffer bb = ByteBuffer.allocateDirect(1);
            FileLock lock = null;
            try {
                lock = this.lock(0);
                int read = this.channel.read(bb, 0L);
                result = read <= 0 ? (byte)78 : (byte)bb.get(0);
            }
            finally {
                if (lock != null) {
                    lock.release();
                }
            }
            logger.debug((Object)("state: " + result));
            return result;
        }
        catch (IOException | ActiveMQLockAcquisitionTimeoutException e) {
            throw new NodeManager.NodeManagerException((Throwable)e);
        }
    }

    @Override
    public final SimpleString readNodeId() throws NodeManager.NodeManagerException {
        try {
            ByteBuffer id = ByteBuffer.allocateDirect(16);
            int read = this.channel.read(id, 3L);
            if (read != 16) {
                throw new IOException("live server did not write id to file");
            }
            byte[] bytes = new byte[16];
            id.position(0);
            id.get(bytes);
            this.setUUID(new UUID(1, bytes));
            return this.getNodeId();
        }
        catch (IOException e) {
            throw new NodeManager.NodeManagerException(e);
        }
    }

    protected FileLock tryLock(int lockPos) throws IOException {
        try {
            logger.debug((Object)("trying to lock position: " + lockPos));
            FileLock lock = this.lockChannels[lockPos].tryLock();
            if (lock != null) {
                logger.debug((Object)("locked position: " + lockPos));
            } else {
                logger.debug((Object)("failed to lock position: " + lockPos));
            }
            return lock;
        }
        catch (OverlappingFileLockException ex) {
            return null;
        }
    }

    protected FileLock lock(int lockPosition) throws ActiveMQLockAcquisitionTimeoutException {
        long start = System.nanoTime();
        boolean isRecurringFailure = false;
        while (!this.interrupted) {
            try {
                FileLock lock = this.tryLock(lockPosition);
                isRecurringFailure = false;
                if (lock == null) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        return null;
                    }
                    if (this.lockAcquisitionTimeoutNanos == -1L || System.nanoTime() - start <= this.lockAcquisitionTimeoutNanos) continue;
                    throw new ActiveMQLockAcquisitionTimeoutException("timed out waiting for lock");
                }
                return lock;
            }
            catch (IOException e) {
                logger.log(isRecurringFailure ? Logger.Level.DEBUG : Logger.Level.WARN, (Object)"Failure when accessing a lock file", (Throwable)e);
                isRecurringFailure = true;
                long waitTime = LOCK_ACCESS_FAILURE_WAIT_TIME_NANOS;
                if (this.lockAcquisitionTimeoutNanos != -1L) {
                    long remainingTime = this.lockAcquisitionTimeoutNanos - (System.nanoTime() - start);
                    if (remainingTime <= 0L) {
                        throw new ActiveMQLockAcquisitionTimeoutException("timed out waiting for lock");
                    }
                    waitTime = Math.min(waitTime, remainingTime);
                }
                try {
                    TimeUnit.NANOSECONDS.sleep(waitTime);
                }
                catch (InterruptedException interrupt) {
                    return null;
                }
            }
        }
        return null;
    }

    private synchronized void startLockMonitoring() {
        logger.debug((Object)"Starting the lock monitor");
        if (this.monitorLock == null) {
            this.monitorLock = new MonitorLock(this.scheduledPool, LOCK_MONITOR_TIMEOUT_NANOS, LOCK_MONITOR_TIMEOUT_NANOS, TimeUnit.NANOSECONDS, false);
            this.monitorLock.start();
        } else {
            logger.debug((Object)"Lock monitor was already started");
        }
    }

    private synchronized void stopLockMonitoring() {
        logger.debug((Object)"Stopping the lock monitor");
        if (this.monitorLock != null) {
            this.monitorLock.stop();
            this.monitorLock = null;
        } else {
            logger.debug((Object)"The lock monitor was already stopped");
        }
    }

    @Override
    protected synchronized void notifyLostLock() {
        if (this.liveLock != null) {
            super.notifyLostLock();
        }
    }

    private boolean isLiveLockLost() {
        FileLock lock = this.liveLock;
        return lock != null && !lock.isValid() || lock == null;
    }

    public class MonitorLock
    extends ActiveMQScheduledComponent {
        public MonitorLock(ScheduledExecutorService scheduledExecutorService, long initialDelay, long checkPeriod, TimeUnit timeUnit, boolean onDemand) {
            super(scheduledExecutorService, initialDelay, checkPeriod, timeUnit, onDemand);
        }

        public void run() {
            boolean lostLock = true;
            try {
                if (FileLockNodeManager.this.liveLock == null) {
                    logger.debug((Object)"Livelock is null");
                }
                if (!(lostLock = FileLockNodeManager.this.isLiveLockLost())) {
                    logger.debug((Object)"Server still has the lock, double check status is live");
                    byte state = FileLockNodeManager.this.getState();
                    if (state == 76) {
                        logger.debug((Object)"Status is set to live");
                    } else {
                        logger.debug((Object)"Status is not live");
                    }
                }
            }
            catch (Exception exception) {
                logger.error((Object)exception.getMessage(), (Throwable)exception);
                lostLock = true;
            }
            if (lostLock) {
                logger.warn((Object)"Lost the lock according to the monitor, notifying listeners");
                FileLockNodeManager.this.notifyLostLock();
            }
        }
    }
}

