/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.CreateSharedQueueMessage;
import org.apache.activemq.artemis.utils.BufferHelper;

public class CreateSharedQueueMessage_V2
extends CreateSharedQueueMessage {
    private RoutingType routingType;
    private Integer maxConsumers;
    private Boolean purgeOnNoConsumers;
    private Boolean exclusive;
    private Boolean groupRebalance;
    private Boolean groupRebalancePauseDispatch;
    private Integer groupBuckets;
    private SimpleString groupFirstKey;
    private Boolean lastValue;
    private SimpleString lastValueKey;
    private Boolean nonDestructive;
    private Integer consumersBeforeDispatch;
    private Long delayBeforeDispatch;
    private Boolean autoDelete;
    private Long autoDeleteDelay;
    private Long autoDeleteMessageCount;
    private Long ringSize;
    private Boolean enabled;

    public CreateSharedQueueMessage_V2(QueueConfiguration queueConfiguration, boolean requiresResponse) {
        this(queueConfiguration.getAddress(), queueConfiguration.getName(), queueConfiguration.getRoutingType(), queueConfiguration.getFilterString(), queueConfiguration.isDurable(), queueConfiguration.getMaxConsumers(), queueConfiguration.isPurgeOnNoConsumers(), queueConfiguration.isExclusive(), queueConfiguration.isGroupRebalance(), queueConfiguration.isGroupRebalancePauseDispatch(), queueConfiguration.getGroupBuckets(), queueConfiguration.getGroupFirstKey(), queueConfiguration.isLastValue(), queueConfiguration.getLastValueKey(), queueConfiguration.isNonDestructive(), queueConfiguration.getConsumersBeforeDispatch(), queueConfiguration.getDelayBeforeDispatch(), queueConfiguration.isAutoDelete(), queueConfiguration.getAutoDeleteDelay(), queueConfiguration.getAutoDeleteMessageCount(), queueConfiguration.getRingSize(), queueConfiguration.isEnabled(), requiresResponse);
    }

    public CreateSharedQueueMessage_V2(SimpleString address, SimpleString queueName, RoutingType routingType, SimpleString filterString, boolean durable, Integer maxConsumers, Boolean purgeOnNoConsumers, Boolean exclusive, Boolean groupRebalance, Boolean groupRebalancePauseDispatch, Integer groupBuckets, SimpleString groupFirstKey, Boolean lastValue, SimpleString lastValueKey, Boolean nonDestructive, Integer consumersBeforeDispatch, Long delayBeforeDispatch, Boolean autoDelete, Long autoDeleteDelay, Long autoDeleteMessageCount, Long ringSize, Boolean enabled, boolean requiresResponse) {
        this();
        this.address = address;
        this.queueName = queueName;
        this.filterString = filterString;
        this.durable = durable;
        this.routingType = routingType;
        this.maxConsumers = maxConsumers;
        this.purgeOnNoConsumers = purgeOnNoConsumers;
        this.exclusive = exclusive;
        this.groupRebalance = groupRebalance;
        this.groupRebalancePauseDispatch = groupRebalancePauseDispatch;
        this.groupBuckets = groupBuckets;
        this.groupFirstKey = groupFirstKey;
        this.lastValue = lastValue;
        this.lastValueKey = lastValueKey;
        this.nonDestructive = nonDestructive;
        this.consumersBeforeDispatch = consumersBeforeDispatch;
        this.delayBeforeDispatch = delayBeforeDispatch;
        this.autoDelete = autoDelete;
        this.autoDeleteDelay = autoDeleteDelay;
        this.autoDeleteMessageCount = autoDeleteMessageCount;
        this.ringSize = ringSize;
        this.enabled = enabled;
        this.requiresResponse = requiresResponse;
    }

    public CreateSharedQueueMessage_V2() {
        super((byte)-13);
    }

    public RoutingType getRoutingType() {
        return this.routingType;
    }

    public void setRoutingType(RoutingType routingType) {
        this.routingType = routingType;
    }

    public Integer getMaxConsumers() {
        return this.maxConsumers;
    }

    public void setMaxConsumers(Integer maxConsumers) {
        this.maxConsumers = maxConsumers;
    }

    public Boolean isPurgeOnNoConsumers() {
        return this.purgeOnNoConsumers;
    }

    public void setPurgeOnNoConsumers(Boolean purgeOnNoConsumers) {
        this.purgeOnNoConsumers = purgeOnNoConsumers;
    }

    public Boolean isExclusive() {
        return this.exclusive;
    }

    public void setExclusive(Boolean exclusive) {
        this.exclusive = exclusive;
    }

    public Boolean isLastValue() {
        return this.lastValue;
    }

    public void setLastValue(Boolean lastValue) {
        this.lastValue = lastValue;
    }

    public SimpleString getLastValueKey() {
        return this.lastValueKey;
    }

    public void setLastValueKey(SimpleString lastValueKey) {
        this.lastValueKey = lastValueKey;
    }

    public Boolean isNonDestructive() {
        return this.nonDestructive;
    }

    public void setNonDestructive(Boolean nonDestructive) {
        this.nonDestructive = nonDestructive;
    }

    public Integer getConsumersBeforeDispatch() {
        return this.consumersBeforeDispatch;
    }

    public void setConsumersBeforeDispatch(Integer consumersBeforeDispatch) {
        this.consumersBeforeDispatch = consumersBeforeDispatch;
    }

    public Long getDelayBeforeDispatch() {
        return this.delayBeforeDispatch;
    }

    public void setDelayBeforeDispatch(Long delayBeforeDispatch) {
        this.delayBeforeDispatch = delayBeforeDispatch;
    }

    public Boolean isGroupRebalance() {
        return this.groupRebalance;
    }

    public void setGroupRebalance(Boolean groupRebalance) {
        this.groupRebalance = groupRebalance;
    }

    public Boolean isGroupRebalancePauseDispatch() {
        return this.groupRebalancePauseDispatch;
    }

    public void setGroupRebalancePauseDispatch(Boolean groupRebalancePauseDispatch) {
        this.groupRebalancePauseDispatch = groupRebalancePauseDispatch;
    }

    public Integer getGroupBuckets() {
        return this.groupBuckets;
    }

    public void setGroupBuckets(Integer groupBuckets) {
        this.groupBuckets = groupBuckets;
    }

    public SimpleString getGroupFirstKey() {
        return this.groupFirstKey;
    }

    public void setGroupBuckets(SimpleString groupFirstKey) {
        this.groupFirstKey = groupFirstKey;
    }

    public Boolean isAutoDelete() {
        return this.autoDelete;
    }

    public void setAutoDelete(Boolean autoDelete) {
        this.autoDelete = autoDelete;
    }

    public Long getAutoDeleteDelay() {
        return this.autoDeleteDelay;
    }

    public void setAutoDeleteDelay(Long autoDeleteDelay) {
        this.autoDeleteDelay = autoDeleteDelay;
    }

    public Long getAutoDeleteMessageCount() {
        return this.autoDeleteMessageCount;
    }

    public void setAutoDeleteMessageCount(Long autoDeleteMessageCount) {
        this.autoDeleteMessageCount = autoDeleteMessageCount;
    }

    public Long getRingSize() {
        return this.ringSize;
    }

    public void setRingSize(Long ringSize) {
        this.ringSize = ringSize;
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public QueueConfiguration toQueueConfiguration() {
        return new QueueConfiguration(this.queueName).setAddress(this.address).setDurable(this.durable).setRoutingType(this.routingType).setExclusive(this.exclusive).setGroupRebalance(this.groupRebalance).setGroupRebalancePauseDispatch(this.groupRebalancePauseDispatch).setNonDestructive(this.nonDestructive).setLastValue(this.lastValue).setFilterString(this.filterString).setMaxConsumers(this.maxConsumers).setPurgeOnNoConsumers(this.purgeOnNoConsumers).setConsumersBeforeDispatch(this.consumersBeforeDispatch).setDelayBeforeDispatch(this.delayBeforeDispatch).setGroupBuckets(this.groupBuckets).setGroupFirstKey(this.groupFirstKey).setLastValueKey(this.lastValueKey).setAutoDelete(this.autoDelete).setAutoDeleteDelay(this.autoDeleteDelay).setAutoDeleteMessageCount(this.autoDeleteMessageCount).setRingSize(this.ringSize).setEnabled(this.enabled);
    }

    @Override
    public String toString() {
        StringBuffer buff = new StringBuffer(this.getParentString());
        buff.append(", address=" + this.address);
        buff.append(", queueName=" + this.queueName);
        buff.append(", filterString=" + this.filterString);
        buff.append(", durable=" + this.durable);
        buff.append(", routingType=" + (Object)((Object)this.routingType));
        buff.append(", maxConsumers=" + this.maxConsumers);
        buff.append(", purgeOnNoConsumers=" + this.purgeOnNoConsumers);
        buff.append(", exclusive=" + this.exclusive);
        buff.append(", groupRebalance=" + this.groupRebalance);
        buff.append(", groupRebalancePauseDispatch=" + this.groupRebalancePauseDispatch);
        buff.append(", groupBuckets=" + this.groupBuckets);
        buff.append(", groupFirstKey=" + this.groupFirstKey);
        buff.append(", lastValue=" + this.lastValue);
        buff.append(", lastValueKey=" + this.lastValueKey);
        buff.append(", nonDestructive=" + this.nonDestructive);
        buff.append(", consumersBeforeDispatch=" + this.consumersBeforeDispatch);
        buff.append(", delayBeforeDispatch=" + this.delayBeforeDispatch);
        buff.append(", autoDelete=" + this.autoDelete);
        buff.append(", autoDeleteDelay=" + this.autoDeleteDelay);
        buff.append(", autoDeleteMessageCount=" + this.autoDeleteMessageCount);
        buff.append(", ringSize=" + this.ringSize);
        buff.append(", enabled=" + this.enabled);
        buff.append(", requiresResponse=" + this.requiresResponse);
        buff.append("]");
        return buff.toString();
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        buffer.writeSimpleString(this.address);
        buffer.writeSimpleString(this.queueName);
        buffer.writeNullableSimpleString(this.filterString);
        buffer.writeBoolean(this.durable);
        buffer.writeByte(this.routingType == null ? (byte)-1 : this.routingType.getType());
        buffer.writeBoolean(this.requiresResponse);
        BufferHelper.writeNullableInteger(buffer, this.maxConsumers);
        BufferHelper.writeNullableBoolean(buffer, this.purgeOnNoConsumers);
        BufferHelper.writeNullableBoolean(buffer, this.exclusive);
        BufferHelper.writeNullableBoolean(buffer, this.lastValue);
        buffer.writeNullableSimpleString(this.lastValueKey);
        BufferHelper.writeNullableBoolean(buffer, this.nonDestructive);
        BufferHelper.writeNullableInteger(buffer, this.consumersBeforeDispatch);
        BufferHelper.writeNullableLong(buffer, this.delayBeforeDispatch);
        BufferHelper.writeNullableBoolean(buffer, this.groupRebalance);
        BufferHelper.writeNullableInteger(buffer, this.groupBuckets);
        BufferHelper.writeNullableBoolean(buffer, this.autoDelete);
        BufferHelper.writeNullableLong(buffer, this.autoDeleteDelay);
        BufferHelper.writeNullableLong(buffer, this.autoDeleteMessageCount);
        buffer.writeNullableSimpleString(this.groupFirstKey);
        BufferHelper.writeNullableLong(buffer, this.ringSize);
        BufferHelper.writeNullableBoolean(buffer, this.enabled);
        BufferHelper.writeNullableBoolean(buffer, this.groupRebalancePauseDispatch);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        this.address = buffer.readSimpleString();
        this.queueName = buffer.readSimpleString();
        this.filterString = buffer.readNullableSimpleString();
        this.durable = buffer.readBoolean();
        this.routingType = RoutingType.getType(buffer.readByte());
        this.requiresResponse = buffer.readBoolean();
        if (buffer.readableBytes() > 0) {
            this.maxConsumers = BufferHelper.readNullableInteger(buffer);
            this.purgeOnNoConsumers = BufferHelper.readNullableBoolean(buffer);
            this.exclusive = BufferHelper.readNullableBoolean(buffer);
            this.lastValue = BufferHelper.readNullableBoolean(buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.lastValueKey = buffer.readNullableSimpleString();
            this.nonDestructive = BufferHelper.readNullableBoolean(buffer);
            this.consumersBeforeDispatch = BufferHelper.readNullableInteger(buffer);
            this.delayBeforeDispatch = BufferHelper.readNullableLong(buffer);
            this.groupRebalance = BufferHelper.readNullableBoolean(buffer);
            this.groupBuckets = BufferHelper.readNullableInteger(buffer);
            this.autoDelete = BufferHelper.readNullableBoolean(buffer);
            this.autoDeleteDelay = BufferHelper.readNullableLong(buffer);
            this.autoDeleteMessageCount = BufferHelper.readNullableLong(buffer);
        }
        if (buffer.readableBytes() > 0) {
            this.groupFirstKey = buffer.readNullableSimpleString();
        }
        if (buffer.readableBytes() > 0) {
            this.ringSize = buffer.readNullableLong();
        }
        if (buffer.readableBytes() > 0) {
            this.enabled = buffer.readNullableBoolean();
        }
        if (buffer.readableBytes() > 0) {
            this.groupRebalancePauseDispatch = buffer.readNullableBoolean();
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
        result = 31 * result + (this.filterString == null ? 0 : this.filterString.hashCode());
        result = 31 * result + (this.queueName == null ? 0 : this.queueName.hashCode());
        result = 31 * result + (this.durable ? 1231 : 1237);
        result = 31 * result + this.routingType.getType();
        result = 31 * result + (this.requiresResponse ? 1231 : 1237);
        result = 31 * result + (this.maxConsumers == null ? 0 : this.maxConsumers.hashCode());
        result = 31 * result + (this.purgeOnNoConsumers == null ? 0 : (this.purgeOnNoConsumers != false ? 1231 : 1237));
        result = 31 * result + (this.exclusive == null ? 0 : (this.exclusive != false ? 1231 : 1237));
        result = 31 * result + (this.groupRebalance == null ? 0 : (this.groupRebalance != false ? 1231 : 1237));
        result = 31 * result + (this.groupRebalancePauseDispatch == null ? 0 : (this.groupRebalancePauseDispatch != false ? 1231 : 1237));
        result = 31 * result + (this.groupBuckets == null ? 0 : this.groupBuckets.hashCode());
        result = 31 * result + (this.groupFirstKey == null ? 0 : this.groupFirstKey.hashCode());
        result = 31 * result + (this.lastValue == null ? 0 : (this.lastValue != false ? 1231 : 1237));
        result = 31 * result + (this.lastValueKey == null ? 0 : this.lastValueKey.hashCode());
        result = 31 * result + (this.nonDestructive == null ? 0 : (this.nonDestructive != false ? 1231 : 1237));
        result = 31 * result + (this.consumersBeforeDispatch == null ? 0 : this.consumersBeforeDispatch.hashCode());
        result = 31 * result + (this.delayBeforeDispatch == null ? 0 : this.delayBeforeDispatch.hashCode());
        result = 31 * result + (this.autoDelete == null ? 0 : this.autoDelete.hashCode());
        result = 31 * result + (this.autoDeleteDelay == null ? 0 : this.autoDeleteDelay.hashCode());
        result = 31 * result + (this.autoDeleteMessageCount == null ? 0 : this.autoDeleteMessageCount.hashCode());
        result = 31 * result + (this.ringSize == null ? 0 : this.ringSize.hashCode());
        result = 31 * result + (this.enabled != false ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof CreateSharedQueueMessage_V2)) {
            return false;
        }
        CreateSharedQueueMessage_V2 other = (CreateSharedQueueMessage_V2)obj;
        if (this.address == null ? other.address != null : !this.address.equals(other.address)) {
            return false;
        }
        if (this.filterString == null ? other.filterString != null : !this.filterString.equals(other.filterString)) {
            return false;
        }
        if (this.queueName == null ? other.queueName != null : !this.queueName.equals(other.queueName)) {
            return false;
        }
        if (this.durable != other.durable) {
            return false;
        }
        if (this.routingType != other.routingType) {
            return false;
        }
        if (this.requiresResponse != other.requiresResponse) {
            return false;
        }
        if (this.maxConsumers == null ? other.maxConsumers != null : !this.maxConsumers.equals(other.maxConsumers)) {
            return false;
        }
        if (this.purgeOnNoConsumers == null ? other.purgeOnNoConsumers != null : !this.purgeOnNoConsumers.equals(other.purgeOnNoConsumers)) {
            return false;
        }
        if (this.exclusive == null ? other.exclusive != null : !this.exclusive.equals(other.exclusive)) {
            return false;
        }
        if (this.groupRebalance == null ? other.groupRebalance != null : !this.groupRebalance.equals(other.groupRebalance)) {
            return false;
        }
        if (this.groupRebalancePauseDispatch == null ? other.groupRebalancePauseDispatch != null : !this.groupRebalancePauseDispatch.equals(other.groupRebalancePauseDispatch)) {
            return false;
        }
        if (this.groupBuckets == null ? other.groupBuckets != null : !this.groupBuckets.equals(other.groupBuckets)) {
            return false;
        }
        if (this.groupFirstKey == null ? other.groupFirstKey != null : !this.groupFirstKey.equals(other.groupFirstKey)) {
            return false;
        }
        if (this.lastValue == null ? other.lastValue != null : !this.lastValue.equals(other.lastValue)) {
            return false;
        }
        if (this.lastValueKey == null ? other.lastValueKey != null : !this.lastValueKey.equals(other.lastValueKey)) {
            return false;
        }
        if (this.nonDestructive == null ? other.nonDestructive != null : !this.nonDestructive.equals(other.nonDestructive)) {
            return false;
        }
        if (this.consumersBeforeDispatch == null ? other.consumersBeforeDispatch != null : !this.consumersBeforeDispatch.equals(other.consumersBeforeDispatch)) {
            return false;
        }
        if (this.delayBeforeDispatch == null ? other.delayBeforeDispatch != null : !this.delayBeforeDispatch.equals(other.delayBeforeDispatch)) {
            return false;
        }
        if (this.autoDelete == null ? other.autoDelete != null : !this.autoDelete.equals(other.autoDelete)) {
            return false;
        }
        if (this.autoDeleteDelay == null ? other.autoDeleteDelay != null : !this.autoDeleteDelay.equals(other.autoDeleteDelay)) {
            return false;
        }
        if (this.autoDeleteMessageCount == null ? other.autoDeleteMessageCount != null : !this.autoDeleteMessageCount.equals(other.autoDeleteMessageCount)) {
            return false;
        }
        if (this.ringSize == null ? other.ringSize != null : !this.ringSize.equals(other.ringSize)) {
            return false;
        }
        return !(this.enabled == null ? other.enabled != null : !this.enabled.equals(other.enabled));
    }
}

