/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis.type.encoded;

import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.cxf.aegis.Context;
import org.apache.cxf.aegis.DatabindingException;
import org.apache.cxf.aegis.type.AegisType;
import org.apache.cxf.aegis.type.TypeMapping;
import org.apache.cxf.aegis.type.encoded.MarshalRegistry;
import org.apache.cxf.aegis.type.encoded.SoapEncodingUtil;
import org.apache.cxf.aegis.type.encoded.SoapRef;
import org.apache.cxf.aegis.type.encoded.SoapRefRegistry;
import org.apache.cxf.aegis.xml.MessageReader;
import org.apache.cxf.aegis.xml.MessageWriter;
import org.apache.ws.commons.schema.XmlSchema;

public class SoapRefType
extends AegisType {
    private final AegisType baseType;

    public SoapRefType(AegisType baseType) {
        if (baseType == null) {
            throw new NullPointerException("baseType is null");
        }
        this.baseType = baseType;
    }

    @Override
    public Object readObject(MessageReader reader, Context context) throws DatabindingException {
        SoapRef soapRef = new SoapRef();
        String ref = SoapEncodingUtil.readRef(reader);
        if (ref != null) {
            SoapRefRegistry.get(context).addRef(ref, soapRef);
            reader.readToEnd();
            return soapRef;
        }
        Object object = this.baseType.readObject(reader, context);
        soapRef.set(object);
        return soapRef;
    }

    @Override
    public void writeObject(Object object, MessageWriter writer, Context context) throws DatabindingException {
        String refId = MarshalRegistry.get(context).getInstanceId(object);
        SoapEncodingUtil.writeRef(writer, refId);
    }

    @Override
    public void writeSchema(XmlSchema schema) {
        this.baseType.writeSchema(schema);
    }

    @Override
    public TypeMapping getTypeMapping() {
        return this.baseType.getTypeMapping();
    }

    @Override
    public void setTypeMapping(TypeMapping typeMapping) {
        this.baseType.setTypeMapping(typeMapping);
    }

    @Override
    public Class<?> getTypeClass() {
        return this.baseType.getTypeClass();
    }

    public void setTypeClass(Class<?> typeClass) {
        this.baseType.setTypeClass(typeClass);
    }

    @Override
    public boolean isComplex() {
        return this.baseType.isComplex();
    }

    @Override
    public boolean isAbstract() {
        return this.baseType.isAbstract();
    }

    @Override
    public void setAbstract(boolean ab) {
        this.baseType.setAbstract(ab);
    }

    @Override
    public boolean isNillable() {
        return this.baseType.isNillable();
    }

    @Override
    public void setNillable(boolean nillable) {
        this.baseType.setNillable(nillable);
    }

    @Override
    public Set<AegisType> getDependencies() {
        return this.baseType.getDependencies();
    }

    @Override
    public QName getSchemaType() {
        return this.baseType.getSchemaType();
    }

    @Override
    public void setSchemaType(QName name) {
        this.baseType.setSchemaType(name);
    }

    @Override
    public boolean isWriteOuter() {
        return this.baseType.isWriteOuter();
    }

    @Override
    public void setWriteOuter(boolean writeOuter) {
        this.baseType.setWriteOuter(writeOuter);
    }
}

