/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.search.analyzer.spi.AnalyzerReference;
import org.hibernate.search.analyzer.spi.AnalyzerStrategy;
import org.hibernate.search.engine.impl.NormalizerRegistry;
import org.hibernate.search.util.impl.Closeables;

public class MutableNormalizerRegistry
implements NormalizerRegistry {
    private final AnalyzerStrategy strategy;
    private final Map<String, AnalyzerReference> referencesByName = new LinkedHashMap<String, AnalyzerReference>();
    private final Map<Class<?>, AnalyzerReference> referencesByLuceneClass = new LinkedHashMap();

    MutableNormalizerRegistry(AnalyzerStrategy strategy) {
        this(strategy, null);
    }

    MutableNormalizerRegistry(AnalyzerStrategy strategy, NormalizerRegistry registryState) {
        this.strategy = strategy;
        if (registryState != null) {
            this.referencesByName.putAll(registryState.getNamedNormalizerReferences());
            this.referencesByLuceneClass.putAll(registryState.getLuceneClassNormalizerReferences());
        }
    }

    @Override
    public Map<String, AnalyzerReference> getNamedNormalizerReferences() {
        return Collections.unmodifiableMap(this.referencesByName);
    }

    @Override
    public Map<Class<?>, AnalyzerReference> getLuceneClassNormalizerReferences() {
        return Collections.unmodifiableMap(this.referencesByLuceneClass);
    }

    @Override
    public AnalyzerReference getNamedNormalizerReference(String name) {
        return this.referencesByName.get(name);
    }

    public AnalyzerReference getOrCreateNamedNormalizerReference(String name) {
        AnalyzerReference reference = this.referencesByName.get(name);
        if (reference == null) {
            reference = this.strategy.createNamedNormalizerReference(name);
            this.referencesByName.put(name, reference);
        }
        return reference;
    }

    @Override
    public AnalyzerReference getLuceneClassNormalizerReference(Class<?> analyzerClazz) {
        return this.referencesByLuceneClass.get(analyzerClazz);
    }

    public AnalyzerReference getOrCreateLuceneClassNormalizerReference(Class<?> analyzerClazz) {
        AnalyzerReference reference = this.referencesByLuceneClass.get(analyzerClazz);
        if (reference == null) {
            reference = this.strategy.createLuceneClassNormalizerReference(analyzerClazz);
            this.referencesByLuceneClass.put(analyzerClazz, reference);
        }
        return reference;
    }

    @Override
    public void close() {
        Closeables.closeQuietly(this.getAllReferences());
    }

    public List<AnalyzerReference> getAllReferences() {
        ArrayList<AnalyzerReference> references = new ArrayList<AnalyzerReference>();
        references.addAll(this.referencesByName.values());
        references.addAll(this.referencesByLuceneClass.values());
        return references;
    }
}

