/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.security.eddsa;

import java.util.AbstractMap;
import org.apache.sshd.common.signature.AbstractSignature;
import org.apache.sshd.common.util.ValidateUtils;

public class SignatureEd25519
extends AbstractSignature {
    public SignatureEd25519() {
        super("NONEwithEdDSA");
    }

    @Override
    public boolean verify(byte[] sig) throws Exception {
        byte[] data = sig;
        AbstractMap.SimpleImmutableEntry<String, byte[]> encoding = this.extractEncodedSignature(data);
        if (encoding != null) {
            String keyType = (String)encoding.getKey();
            ValidateUtils.checkTrue("ssh-ed25519".equals(keyType), "Mismatched key type: %s", (Object)keyType);
            data = (byte[])encoding.getValue();
        }
        return this.doVerify(data);
    }
}

