/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jmx;

import java.io.ObjectInputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Supplier;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerDelegate;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import javax.management.loading.ClassLoaderRepository;
import org.jboss.as.controller.AccessAuditContext;
import org.jboss.as.controller.access.AuthorizationResult;
import org.jboss.as.controller.access.HostEffect;
import org.jboss.as.controller.access.JmxAction;
import org.jboss.as.controller.access.JmxTarget;
import org.jboss.as.controller.access.ServerGroupEffect;
import org.jboss.as.controller.access.management.JmxAuthorizer;
import org.jboss.as.controller.audit.AuditLogger;
import org.jboss.as.controller.audit.ManagedAuditLogger;
import org.jboss.as.jmx.AuthorizingMBeanServer;
import org.jboss.as.jmx.JmxEffect;
import org.jboss.as.jmx.MBeanServerAuditLogRecordFormatter;
import org.jboss.as.jmx.SecurityActions;
import org.jboss.as.jmx.logging.JmxLogger;
import org.jboss.as.server.jmx.MBeanServerPlugin;
import org.jboss.as.server.jmx.PluggableMBeanServer;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.manager.WildFlySecurityManager;

class PluggableMBeanServerImpl
implements PluggableMBeanServer {
    private static final Object[] NO_ARGS = new Object[0];
    private static final String[] EMPTY_SIG = new String[0];
    private final MBeanServerPlugin rootMBeanServer;
    private final MBeanServerDelegate rootMBeanServerDelegate;
    private volatile ManagedAuditLogger auditLogger;
    private final Set<MBeanServerPlugin> delegates = new CopyOnWriteArraySet<MBeanServerPlugin>();
    private volatile JmxAuthorizer authorizer;
    private volatile Supplier<SecurityIdentity> securityIdentitySupplier;
    private volatile JmxEffect jmxEffect;

    PluggableMBeanServerImpl(MBeanServer rootMBeanServer, MBeanServerDelegate rootMBeanServerDelegate) {
        this.rootMBeanServer = new TcclMBeanServer(rootMBeanServer);
        this.rootMBeanServerDelegate = rootMBeanServerDelegate;
    }

    void setAuditLogger(ManagedAuditLogger auditLoggerInfo) {
        this.auditLogger = auditLoggerInfo != null ? auditLoggerInfo : AuditLogger.NO_OP_LOGGER;
    }

    void setAuthorizer(JmxAuthorizer authorizer) {
        this.authorizer = authorizer;
    }

    void setSecurityIdentitySupplier(Supplier<SecurityIdentity> securityIdentitySupplier) {
        this.securityIdentitySupplier = securityIdentitySupplier;
    }

    void setNonFacadeMBeansSensitive(boolean sensitive) {
        this.authorizer.setNonFacadeMBeansSensitive(sensitive);
    }

    void setJmxEffect(JmxEffect effect) {
        this.jmxEffect = effect;
    }

    public void addPlugin(MBeanServerPlugin delegate) {
        this.delegates.add(delegate);
    }

    public void removePlugin(MBeanServerPlugin delegate) {
        this.delegates.remove(delegate);
    }

    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        Exception error = null;
        MBeanServerPlugin delegate = null;
        boolean readOnly = true;
        try {
            delegate = this.findDelegateForNewObject(name);
            this.authorizeMBeanOperation(delegate, name, "addNotificationListener", null, JmxAction.Impact.READ_ONLY);
            delegate.addNotificationListener(name, listener, filter, handback);
        }
        catch (Exception e) {
            error = e;
            if (e instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw this.makeRuntimeException(e);
        }
        finally {
            if (this.shouldAuditLog(delegate, true)) {
                new MBeanServerAuditLogRecordFormatter(this, error, true).addNotificationListener(name, listener, filter, handback);
            }
        }
    }

    public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        Exception error = null;
        MBeanServerPlugin delegate = null;
        boolean readOnly = true;
        try {
            delegate = this.findDelegateForNewObject(name);
            this.authorizeMBeanOperation(delegate, name, "addNotificationListener", null, JmxAction.Impact.READ_ONLY);
            delegate.addNotificationListener(name, listener, filter, handback);
        }
        catch (Exception e) {
            error = e;
            if (e instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw this.makeRuntimeException(e);
        }
        finally {
            if (this.shouldAuditLog(delegate, true)) {
                new MBeanServerAuditLogRecordFormatter(this, error, true).addNotificationListener(name, listener, filter, handback);
            }
        }
    }

    public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException {
        params = this.nullAsEmpty(params);
        signature = this.nullAsEmpty(signature);
        Exception error = null;
        MBeanServerPlugin delegate = null;
        boolean readOnly = false;
        try {
            delegate = this.findDelegateForNewObject(name);
            this.authorizeMBeanOperation(delegate, name, "createMBean", null, JmxAction.Impact.WRITE);
            ObjectInstance objectInstance = this.checkNotAReservedDomainRegistrationIfObjectNameWasChanged(name, delegate.createMBean(className, name, params, signature), delegate);
            return objectInstance;
        }
        catch (Exception e) {
            error = e;
            if (e instanceof ReflectionException) {
                throw (ReflectionException)e;
            }
            if (e instanceof InstanceAlreadyExistsException) {
                throw (InstanceAlreadyExistsException)e;
            }
            if (e instanceof MBeanException) {
                throw (MBeanException)e;
            }
            if (e instanceof NotCompliantMBeanException) {
                throw (NotCompliantMBeanException)e;
            }
            throw this.makeRuntimeException(e);
        }
        finally {
            if (this.shouldAuditLog(delegate, false)) {
                new MBeanServerAuditLogRecordFormatter(this, error, false).createMBean(className, name, params, signature);
            }
        }
    }

    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        params = this.nullAsEmpty(params);
        signature = this.nullAsEmpty(signature);
        Exception error = null;
        MBeanServerPlugin delegate = null;
        boolean readOnly = false;
        try {
            delegate = this.findDelegateForNewObject(name);
            this.authorizeMBeanOperation(delegate, name, "createMBean", null, JmxAction.Impact.WRITE);
            ObjectInstance objectInstance = this.checkNotAReservedDomainRegistrationIfObjectNameWasChanged(name, delegate.createMBean(className, name, loaderName, params, signature), delegate);
            return objectInstance;
        }
        catch (Exception e) {
            error = e;
            if (e instanceof ReflectionException) {
                throw (ReflectionException)e;
            }
            if (e instanceof InstanceAlreadyExistsException) {
                throw (InstanceAlreadyExistsException)e;
            }
            if (e instanceof MBeanException) {
                throw (MBeanException)e;
            }
            if (e instanceof NotCompliantMBeanException) {
                throw (NotCompliantMBeanException)e;
            }
            if (e instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e;
            }
            throw this.makeRuntimeException(e);
        }
        finally {
            if (this.shouldAuditLog(delegate, false)) {
                new MBeanServerAuditLogRecordFormatter(this, error, false).createMBean(className, name, params, signature);
            }
        }
    }

    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        Exception error = null;
        MBeanServerPlugin delegate = null;
        boolean readOnly = false;
        try {
            delegate = this.findDelegateForNewObject(name);
            this.authorizeMBeanOperation(delegate, name, "createMBean", null, JmxAction.Impact.WRITE);
            ObjectInstance objectInstance = this.checkNotAReservedDomainRegistrationIfObjectNameWasChanged(name, delegate.createMBean(className, name, loaderName), delegate);
            return objectInstance;
        }
        catch (Exception e) {
            error = e;
            if (e instanceof ReflectionException) {
                throw (ReflectionException)e;
            }
            if (e instanceof InstanceAlreadyExistsException) {
                throw (InstanceAlreadyExistsException)e;
            }
            if (e instanceof MBeanException) {
                throw (MBeanException)e;
            }
            if (e instanceof NotCompliantMBeanException) {
                throw (NotCompliantMBeanException)e;
            }
            if (e instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e;
            }
            throw this.makeRuntimeException(e);
        }
        finally {
            if (this.shouldAuditLog(delegate, false)) {
                new MBeanServerAuditLogRecordFormatter(this, error, false).createMBean(className, name, loaderName);
            }
        }
    }

    public ObjectInstance createMBean(String className, ObjectName name) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException {
        Exception error = null;
        MBeanServerPlugin delegate = null;
        boolean readOnly = false;
        try {
            delegate = this.findDelegateForNewObject(name);
            this.authorizeMBeanOperation(delegate, name, "createMBean", null, JmxAction.Impact.WRITE);
            ObjectInstance objectInstance = this.checkNotAReservedDomainRegistrationIfObjectNameWasChanged(name, delegate.createMBean(className, name), delegate);
            return objectInstance;
        }
        catch (Exception e) {
            error = e;
            if (e instanceof ReflectionException) {
                throw (ReflectionException)e;
            }
            if (e instanceof InstanceAlreadyExistsException) {
                throw (InstanceAlreadyExistsException)e;
            }
            if (e instanceof MBeanException) {
                throw (MBeanException)e;
            }
            if (e instanceof NotCompliantMBeanException) {
                throw (NotCompliantMBeanException)e;
            }
            throw this.makeRuntimeException(e);
        }
        finally {
            if (this.shouldAuditLog(delegate, false)) {
                new MBeanServerAuditLogRecordFormatter(this, error, false).createMBean(className, name);
            }
        }
    }

    @Deprecated
    public ObjectInputStream deserialize(ObjectName name, byte[] data) throws OperationsException {
        Exception error = null;
        MBeanServerPlugin delegate = null;
        boolean readOnly = true;
        try {
            delegate = this.findDelegate(name);
            this.authorizeClassloadingOperation(delegate, name, "deserialize");
            ObjectInputStream objectInputStream = delegate.deserialize(name, data);
            return objectInputStream;
        }
        catch (Exception e) {
            error = e;
            if (e instanceof OperationsException) {
                throw (OperationsException)e;
            }
            throw this.makeRuntimeException(e);
        }
        finally {
            if (this.shouldAuditLog(delegate, true)) {
                new MBeanServerAuditLogRecordFormatter(this, error, true).deserialize(name, data);
            }
        }
    }

    @Deprecated
    public ObjectInputStream deserialize(String className, byte[] data) throws OperationsException, ReflectionException {
        Exception error = null;
        MBeanServerPlugin delegate = this.rootMBeanServer;
        boolean readOnly = true;
        try {
            this.authorizeClassloadingOperation(delegate, "deserialize");
            ObjectInputStream objectInputStream = delegate.deserialize(className, data);
            return objectInputStream;
        }
        catch (Exception e) {
            error = e;
            if (e instanceof OperationsException) {
                throw (OperationsException)e;
            }
            if (e instanceof ReflectionException) {
                throw (ReflectionException)e;
            }
            throw this.makeRuntimeException(e);
        }
        finally {
            if (this.shouldAuditLog(delegate, true)) {
                new MBeanServerAuditLogRecordFormatter(this, error, true).deserialize(className, data);
            }
        }
    }

    @Deprecated
    public ObjectInputStream deserialize(String className, ObjectName loaderName, byte[] data) throws OperationsException, ReflectionException {
        Exception error = null;
        MBeanServerPlugin delegate = this.rootMBeanServer;
        boolean readOnly = true;
        try {
            this.authorizeClassloadingOperation(delegate, loaderName, "deserialize");
            ObjectInputStream objectInputStream = delegate.deserialize(className, loaderName, data);
            return objectInputStream;
        }
        catch (Exception e) {
            error = e;
            if (e instanceof OperationsException) {
                throw (OperationsException)e;
            }
            if (e instanceof ReflectionException) {
                throw (ReflectionException)e;
            }
            throw this.makeRuntimeException(e);
        }
        finally {
            if (this.shouldAuditLog(delegate, true)) {
                new MBeanServerAuditLogRecordFormatter(this, error, true).deserialize(className, loaderName, data);
            }
        }
    }

    public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        Exception error = null;
        MBeanServerPlugin delegate = null;
        boolean readOnly = true;
        try {
            delegate = this.findDelegate(name);
            this.authorizeMBeanOperation(delegate, name, "getAttribute", attribute, JmxAction.Impact.READ_ONLY);
            Object object = delegate.getAttribute(name, attribute);
            return object;
        }
        catch (Exception e) {
            error = e;
            if (e instanceof MBeanException) {
                throw (MBeanException)e;
            }
            if (e instanceof AttributeNotFoundException) {
                throw (AttributeNotFoundException)e;
            }
            if (e instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e;
            }
            if (e instanceof ReflectionException) {
                throw (ReflectionException)e;
            }
            throw this.makeRuntimeException(e);
        }
        finally {
            if (this.shouldAuditLog(delegate, true)) {
                new MBeanServerAuditLogRecordFormatter(this, error, true).getAttribute(name, attribute);
            }
        }
    }

    public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException {
        Exception error = null;
        MBeanServerPlugin delegate = null;
        boolean readOnly = true;
        try {
            delegate = this.findDelegate(name);
            if (delegate.shouldAuthorize()) {
                for (String attribute : attributes) {
                    this.authorizeMBeanOperation(delegate, name, "getAttribute", attribute, JmxAction.Impact.READ_ONLY);
                }
            }
            AttributeList attributeList = delegate.getAttributes(name, attributes);
            return attributeList;
        }
        catch (Exception exception) {
            error = exception;
            if (exception instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)exception;
            }
            if (exception instanceof ReflectionException) {
                throw (ReflectionException)exception;
            }
            throw this.makeRuntimeException(exception);
        }
        finally {
            if (this.shouldAuditLog(delegate, true)) {
                new MBeanServerAuditLogRecordFormatter(this, error, true).getAttributes(name, attributes);
            }
        }
    }

    public ClassLoader getClassLoader(ObjectName loaderName) throws InstanceNotFoundException {
        Exception error = null;
        MBeanServerPlugin delegate = null;
        boolean readOnly = true;
        try {
            delegate = this.findDelegate(loaderName);
            this.authorizeClassloadingOperation(delegate, loaderName, "getClassLoader");
            ClassLoader classLoader = delegate.getClassLoader(loaderName);
            return classLoader;
        }
        catch (Exception e) {
            error = e;
            if (e instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e;
            }
            throw this.makeRuntimeException(e);
        }
        finally {
            if (this.shouldAuditLog(delegate, true)) {
                new MBeanServerAuditLogRecordFormatter(this, error, true).getClassLoader(loaderName);
            }
        }
    }

    public ClassLoader getClassLoaderFor(ObjectName mbeanName) throws InstanceNotFoundException {
        Exception error = null;
        MBeanServerPlugin delegate = null;
        boolean readOnly = true;
        try {
            delegate = this.findDelegateForNewObject(mbeanName);
            this.authorizeClassloadingOperation(delegate, mbeanName, "getClassLoaderFor");
            ClassLoader classLoader = delegate.getClassLoaderFor(mbeanName);
            return classLoader;
        }
        catch (Exception e) {
            error = e;
            if (e instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e;
            }
            throw this.makeRuntimeException(e);
        }
        finally {
            if (this.shouldAuditLog(delegate, true)) {
                new MBeanServerAuditLogRecordFormatter(this, error, true).getClassLoaderFor(mbeanName);
            }
        }
    }

    public ClassLoaderRepository getClassLoaderRepository() {
        Exception error = null;
        MBeanServerPlugin delegate = this.rootMBeanServer;
        boolean readOnly = true;
        try {
            this.authorizeClassloadingOperation(delegate, "getClassLoaderRepository");
            ClassLoaderRepository classLoaderRepository = delegate.getClassLoaderRepository();
            return classLoaderRepository;
        }
        catch (Exception e) {
            error = e;
            throw this.makeRuntimeException(e);
        }
        finally {
            if (this.shouldAuditLog(delegate, true)) {
                new MBeanServerAuditLogRecordFormatter(this, error, true).getClassLoaderRepository();
            }
        }
    }

    public String getDefaultDomain() {
        Exception error = null;
        MBeanServerPlugin delegate = this.rootMBeanServer;
        boolean readOnly = true;
        try {
            String string = delegate.getDefaultDomain();
            return string;
        }
        catch (Exception e) {
            error = e;
            throw this.makeRuntimeException(e);
        }
        finally {
            if (this.shouldAuditLog(delegate, true)) {
                new MBeanServerAuditLogRecordFormatter(this, error, true).getDefaultDomain();
            }
        }
    }

    public String[] getDomains() {
        Exception error = null;
        boolean readOnly = true;
        try {
            ArrayList<String> result = new ArrayList<String>();
            if (this.delegates.size() > 0) {
                for (MBeanServerPlugin delegate : this.delegates) {
                    String[] domains = delegate.getDomains();
                    if (domains.length <= 0) continue;
                    result.addAll(Arrays.asList(domains));
                }
            }
            result.addAll(Arrays.asList(this.rootMBeanServer.getDomains()));
            String[] stringArray = result.toArray(new String[result.size()]);
            return stringArray;
        }
        catch (Exception e) {
            error = e;
            throw this.makeRuntimeException(e);
        }
        finally {
            new MBeanServerAuditLogRecordFormatter(this, error, true).getDomains();
        }
    }

    public Integer getMBeanCount() {
        Exception error = null;
        boolean readOnly = true;
        boolean shouldLog = false;
        try {
            int i = 0;
            if (this.delegates.size() > 0) {
                for (MBeanServerPlugin delegate : this.delegates) {
                    if (!this.authorizeMBeanOperation(delegate, ObjectName.WILDCARD, "getMBeanCount", null, JmxAction.Impact.READ_ONLY, false)) continue;
                    i += delegate.getMBeanCount().intValue();
                    if (!delegate.shouldAuditLog()) continue;
                    shouldLog = true;
                }
            }
            if (this.authorizeMBeanOperation(this.rootMBeanServer, ObjectName.WILDCARD, "getMBeanCount", null, JmxAction.Impact.READ_ONLY, false)) {
                i += this.rootMBeanServer.getMBeanCount().intValue();
                shouldLog = true;
            }
            Integer n = i;
            return n;
        }
        catch (Exception e) {
            error = e;
            throw this.makeRuntimeException(e);
        }
        finally {
            if (error != null || shouldLog) {
                new MBeanServerAuditLogRecordFormatter(this, error, true).getMBeanCount();
            }
        }
    }

    public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        return this.getMBeanInfo(name, true, false);
    }

    private MBeanInfo getMBeanInfo(ObjectName name, boolean logAndAuthorize, boolean nullIfNotFound) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        Exception error = null;
        MBeanServerPlugin delegate = null;
        boolean readOnly = true;
        try {
            delegate = this.findDelegate(name);
            if (logAndAuthorize) {
                this.authorizeMBeanOperation(delegate, name, "getMBeanInfo", null, JmxAction.Impact.READ_ONLY);
            }
            MBeanInfo mBeanInfo = delegate.getMBeanInfo(name);
            return mBeanInfo;
        }
        catch (Exception e) {
            if (nullIfNotFound) {
                MBeanInfo mBeanInfo = null;
                return mBeanInfo;
            }
            error = e;
            if (e instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e;
            }
            if (e instanceof IntrospectionException) {
                throw (IntrospectionException)e;
            }
            if (e instanceof ReflectionException) {
                throw (ReflectionException)e;
            }
            throw this.makeRuntimeException(e);
        }
        finally {
            if (logAndAuthorize && this.shouldAuditLog(delegate, true)) {
                new MBeanServerAuditLogRecordFormatter(this, error, true).getMBeanInfo(name);
            }
        }
    }

    public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException {
        Exception error = null;
        MBeanServerPlugin delegate = null;
        boolean readOnly = true;
        try {
            delegate = this.findDelegate(name);
            this.authorizeMBeanOperation(delegate, name, "getObjectInstance", null, JmxAction.Impact.READ_ONLY);
            ObjectInstance objectInstance = delegate.getObjectInstance(name);
            return objectInstance;
        }
        catch (Exception e) {
            error = e;
            if (e instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e;
            }
            throw this.makeRuntimeException(e);
        }
        finally {
            if (this.shouldAuditLog(delegate, true)) {
                new MBeanServerAuditLogRecordFormatter(this, error, true).getObjectInstance(name);
            }
        }
    }

    public Object instantiate(String className, Object[] params, String[] signature) throws ReflectionException, MBeanException {
        params = this.nullAsEmpty(params);
        signature = this.nullAsEmpty(signature);
        Exception error = null;
        MBeanServerPlugin delegate = this.rootMBeanServer;
        boolean readOnly = false;
        try {
            this.authorizeClassloadingOperation(delegate, "instantiate");
            Object object = delegate.instantiate(className, params, signature);
            return object;
        }
        catch (Exception e) {
            error = e;
            if (e instanceof ReflectionException) {
                throw (ReflectionException)e;
            }
            if (e instanceof MBeanException) {
                throw (MBeanException)e;
            }
            throw this.makeRuntimeException(e);
        }
        finally {
            if (this.shouldAuditLog(delegate, false)) {
                new MBeanServerAuditLogRecordFormatter(this, error, false).instantiate(className, params, signature);
            }
        }
    }

    public Object instantiate(String className, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, MBeanException, InstanceNotFoundException {
        params = this.nullAsEmpty(params);
        signature = this.nullAsEmpty(signature);
        Exception error = null;
        MBeanServerPlugin delegate = this.rootMBeanServer;
        boolean readOnly = false;
        try {
            this.authorizeClassloadingOperation(delegate, loaderName, "instantiate");
            Object object = delegate.instantiate(className, loaderName, params, signature);
            return object;
        }
        catch (Exception e) {
            error = e;
            if (e instanceof ReflectionException) {
                throw (ReflectionException)e;
            }
            if (e instanceof MBeanException) {
                throw (MBeanException)e;
            }
            if (e instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e;
            }
            throw this.makeRuntimeException(e);
        }
        finally {
            if (this.shouldAuditLog(delegate, false)) {
                new MBeanServerAuditLogRecordFormatter(this, error, false).instantiate(className, loaderName, params, signature);
            }
        }
    }

    public Object instantiate(String className, ObjectName loaderName) throws ReflectionException, MBeanException, InstanceNotFoundException {
        Exception error = null;
        MBeanServerPlugin delegate = this.rootMBeanServer;
        boolean readOnly = false;
        try {
            this.authorizeClassloadingOperation(delegate, "instantiate");
            Object object = delegate.instantiate(className, loaderName);
            return object;
        }
        catch (Exception e) {
            error = e;
            if (e instanceof ReflectionException) {
                throw (ReflectionException)e;
            }
            if (e instanceof MBeanException) {
                throw (MBeanException)e;
            }
            if (e instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e;
            }
            throw this.makeRuntimeException(e);
        }
        finally {
            if (this.shouldAuditLog(delegate, false)) {
                new MBeanServerAuditLogRecordFormatter(this, error, false).instantiate(className, loaderName);
            }
        }
    }

    public Object instantiate(String className) throws ReflectionException, MBeanException {
        Exception error = null;
        MBeanServerPlugin delegate = this.rootMBeanServer;
        boolean readOnly = false;
        try {
            this.authorizeClassloadingOperation(delegate, "instantiate");
            Object object = delegate.instantiate(className);
            return object;
        }
        catch (Exception e) {
            error = e;
            if (e instanceof ReflectionException) {
                throw (ReflectionException)e;
            }
            if (e instanceof MBeanException) {
                throw (MBeanException)e;
            }
            throw this.makeRuntimeException(e);
        }
        finally {
            if (this.shouldAuditLog(delegate, false)) {
                new MBeanServerAuditLogRecordFormatter(this, error, false).instantiate(className);
            }
        }
    }

    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException {
        params = this.nullAsEmpty(params);
        signature = this.nullAsEmpty(signature);
        Exception error = null;
        MBeanServerPlugin delegate = this.findDelegate(name);
        boolean readOnly = false;
        try {
            readOnly = this.isOperationReadOnly(name, operationName, signature);
            delegate = this.findDelegate(name);
            this.authorizeMBeanOperation(delegate, name, "invoke", null, readOnly ? JmxAction.Impact.READ_ONLY : JmxAction.Impact.WRITE);
            Object object = delegate.invoke(name, operationName, params, signature);
            return object;
        }
        catch (Exception e) {
            error = e;
            if (e instanceof ReflectionException) {
                throw (ReflectionException)e;
            }
            if (e instanceof MBeanException) {
                throw (MBeanException)e;
            }
            if (e instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e;
            }
            throw this.makeRuntimeException(e);
        }
        finally {
            if (this.shouldAuditLog(delegate, readOnly)) {
                new MBeanServerAuditLogRecordFormatter(this, error, readOnly).invoke(name, operationName, params, signature);
            }
        }
    }

    public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException {
        Exception error = null;
        MBeanServerPlugin delegate = null;
        boolean readOnly = true;
        try {
            delegate = this.findDelegateForNewObject(name);
            this.authorizeMBeanOperation(delegate, name, "isInstanceOf", null, JmxAction.Impact.READ_ONLY);
            boolean bl = delegate.isInstanceOf(name, className);
            return bl;
        }
        catch (Exception e) {
            error = e;
            if (e instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e;
            }
            throw this.makeRuntimeException(e);
        }
        finally {
            if (this.shouldAuditLog(delegate, true)) {
                new MBeanServerAuditLogRecordFormatter(this, error, true).isInstanceOf(name, className);
            }
        }
    }

    public boolean isRegistered(ObjectName name) {
        Exception error = null;
        Boolean shouldAuditLog = null;
        boolean readOnly = true;
        try {
            if (this.delegates.size() > 0) {
                for (MBeanServerPlugin delegate : this.delegates) {
                    if (!delegate.accepts(name) || !delegate.isRegistered(name)) continue;
                    this.authorizeMBeanOperation(delegate, name, "isRegistered", null, JmxAction.Impact.READ_ONLY);
                    if (delegate.shouldAuditLog()) {
                        shouldAuditLog = true;
                    }
                    boolean bl = true;
                    return bl;
                }
            }
            shouldAuditLog = true;
            this.authorizeMBeanOperation(this.rootMBeanServer, name, "isRegistered", null, JmxAction.Impact.READ_ONLY);
            boolean bl = this.rootMBeanServer.isRegistered(name);
            return bl;
        }
        catch (Exception e) {
            error = e;
            throw this.makeRuntimeException(e);
        }
        finally {
            if (shouldAuditLog == null || shouldAuditLog.booleanValue()) {
                new MBeanServerAuditLogRecordFormatter(this, error, true).isRegistered(name);
            }
        }
    }

    public Set<ObjectInstance> queryMBeans(ObjectName name, QueryExp query) {
        Exception error = null;
        boolean readOnly = true;
        boolean shouldAuditLog = false;
        try {
            HashSet result = new HashSet();
            if (this.delegates.size() > 0) {
                for (MBeanServerPlugin delegate : this.delegates) {
                    if (name != null && (name.getDomain() == null || !delegate.accepts(name)) || !this.authorizeMBeanOperation(delegate, name, "queryMBeans", null, JmxAction.Impact.READ_ONLY, false)) continue;
                    result.addAll(delegate.queryMBeans(name, query));
                    if (!delegate.shouldAuditLog()) continue;
                    shouldAuditLog = true;
                }
            }
            if (this.authorizeMBeanOperation(this.rootMBeanServer, name, "queryMBeans", null, JmxAction.Impact.READ_ONLY, false)) {
                result.addAll(this.rootMBeanServer.queryMBeans(name, query));
                shouldAuditLog = true;
            }
            HashSet hashSet = result;
            return hashSet;
        }
        catch (Exception e) {
            error = e;
            throw this.makeRuntimeException(e);
        }
        finally {
            if (error != null || shouldAuditLog) {
                new MBeanServerAuditLogRecordFormatter(this, error, true).queryMBeans(name, query);
            }
        }
    }

    public Set<ObjectName> queryNames(ObjectName name, QueryExp query) {
        Exception error = null;
        boolean readOnly = true;
        boolean shouldAuditLog = false;
        try {
            HashSet result = new HashSet();
            if (this.delegates.size() > 0) {
                for (MBeanServerPlugin delegate : this.delegates) {
                    if (name != null && (name.getDomain() == null || !delegate.accepts(name)) || !this.authorizeMBeanOperation(delegate, name, "queryMBeans", null, JmxAction.Impact.READ_ONLY, false)) continue;
                    result.addAll(delegate.queryNames(name, query));
                    if (!delegate.shouldAuditLog()) continue;
                    shouldAuditLog = true;
                }
            }
            if (this.authorizeMBeanOperation(this.rootMBeanServer, name, "queryMBeans", null, JmxAction.Impact.READ_ONLY, false)) {
                result.addAll(this.rootMBeanServer.queryNames(name, query));
                shouldAuditLog = true;
            }
            HashSet hashSet = result;
            return hashSet;
        }
        catch (Exception e) {
            error = e;
            throw this.makeRuntimeException(e);
        }
        finally {
            if (error != null || shouldAuditLog) {
                new MBeanServerAuditLogRecordFormatter(this, error, true).queryNames(name, query);
            }
        }
    }

    public ObjectInstance registerMBean(Object object, ObjectName name) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        Exception error = null;
        MBeanServerPlugin delegate = null;
        boolean readOnly = false;
        try {
            delegate = this.findDelegateForNewObject(name);
            this.authorizeMBeanOperation(delegate, name, "registerMBean", null, JmxAction.Impact.WRITE);
            ObjectInstance objectInstance = this.checkNotAReservedDomainRegistrationIfObjectNameWasChanged(name, delegate.registerMBean(object, name), delegate);
            return objectInstance;
        }
        catch (Exception e) {
            error = e;
            if (e instanceof InstanceAlreadyExistsException) {
                throw (InstanceAlreadyExistsException)e;
            }
            if (e instanceof MBeanRegistrationException) {
                throw (MBeanRegistrationException)e;
            }
            if (e instanceof NotCompliantMBeanException) {
                throw (NotCompliantMBeanException)e;
            }
            throw this.makeRuntimeException(e);
        }
        finally {
            if (this.shouldAuditLog(delegate, false)) {
                new MBeanServerAuditLogRecordFormatter(this, error, false).registerMBean(object, name);
            }
        }
    }

    private ObjectInstance checkNotAReservedDomainRegistrationIfObjectNameWasChanged(ObjectName name, ObjectInstance createdInstance, MBeanServerPlugin usedDelegate) throws RuntimeOperationsException {
        ObjectName registeredName = createdInstance.getObjectName();
        if (registeredName.equals(name) || usedDelegate != this.rootMBeanServer) {
            return createdInstance;
        }
        MBeanServerPlugin shouldHaveUsedDelegate = null;
        for (MBeanServerPlugin delegate : this.delegates) {
            if (!delegate.accepts(registeredName)) continue;
            shouldHaveUsedDelegate = delegate;
        }
        if (shouldHaveUsedDelegate != null) {
            try {
                usedDelegate.unregisterMBean(registeredName);
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
            }
            catch (MBeanRegistrationException e) {
                JmxLogger.ROOT_LOGGER.errorUnregisteringMBeanWithBadCalculatedName(e, registeredName);
            }
            catch (RuntimeException e) {
                JmxLogger.ROOT_LOGGER.errorUnregisteringMBeanWithBadCalculatedName(e, registeredName);
            }
            throw JmxLogger.ROOT_LOGGER.badDomainInCalclulatedObjectNameException(registeredName);
        }
        return createdInstance;
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        Exception error = null;
        MBeanServerPlugin delegate = null;
        boolean readOnly = true;
        try {
            delegate = this.findDelegateForNewObject(name);
            this.authorizeMBeanOperation(delegate, name, "removeNotificationListener", null, JmxAction.Impact.READ_ONLY);
            delegate.removeNotificationListener(name, listener, filter, handback);
        }
        catch (Exception e) {
            error = e;
            if (e instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e;
            }
            if (e instanceof ListenerNotFoundException) {
                throw (ListenerNotFoundException)e;
            }
            throw this.makeRuntimeException(e);
        }
        finally {
            if (this.shouldAuditLog(delegate, true)) {
                new MBeanServerAuditLogRecordFormatter(this, error, true).removeNotificationListener(name, listener, filter, handback);
            }
        }
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException {
        Exception error = null;
        MBeanServerPlugin delegate = null;
        boolean readOnly = true;
        try {
            delegate = this.findDelegateForNewObject(name);
            this.authorizeMBeanOperation(delegate, name, "removeNotificationListener", null, JmxAction.Impact.READ_ONLY);
            delegate.removeNotificationListener(name, listener);
        }
        catch (Exception e) {
            error = e;
            if (e instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e;
            }
            if (e instanceof ListenerNotFoundException) {
                throw (ListenerNotFoundException)e;
            }
            throw this.makeRuntimeException(e);
        }
        finally {
            if (this.shouldAuditLog(delegate, true)) {
                new MBeanServerAuditLogRecordFormatter(this, error, true).removeNotificationListener(name, listener);
            }
        }
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        Exception error = null;
        MBeanServerPlugin delegate = null;
        boolean readOnly = true;
        try {
            delegate = this.findDelegateForNewObject(name);
            this.authorizeMBeanOperation(delegate, name, "removeNotificationListener", null, JmxAction.Impact.READ_ONLY);
            delegate.removeNotificationListener(name, listener, filter, handback);
        }
        catch (Exception e) {
            error = e;
            if (e instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e;
            }
            if (e instanceof ListenerNotFoundException) {
                throw (ListenerNotFoundException)e;
            }
            throw this.makeRuntimeException(e);
        }
        finally {
            if (this.shouldAuditLog(delegate, true)) {
                new MBeanServerAuditLogRecordFormatter(this, error, true).removeNotificationListener(name, listener, filter, handback);
            }
        }
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException {
        Exception error = null;
        MBeanServerPlugin delegate = null;
        boolean readOnly = true;
        try {
            delegate = this.findDelegateForNewObject(name);
            this.authorizeMBeanOperation(delegate, name, "removeNotificationListener", null, JmxAction.Impact.READ_ONLY);
            delegate.removeNotificationListener(name, listener);
        }
        catch (Exception e) {
            error = e;
            if (e instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e;
            }
            if (e instanceof ListenerNotFoundException) {
                throw (ListenerNotFoundException)e;
            }
            throw this.makeRuntimeException(e);
        }
        finally {
            if (this.shouldAuditLog(delegate, true)) {
                new MBeanServerAuditLogRecordFormatter(this, error, true).removeNotificationListener(name, listener);
            }
        }
    }

    public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        Exception error = null;
        MBeanServerPlugin delegate = null;
        boolean readOnly = false;
        try {
            delegate = this.findDelegate(name);
            this.authorizeMBeanOperation(delegate, name, "setAttribute", attribute.getName(), JmxAction.Impact.WRITE);
            delegate.setAttribute(name, attribute);
        }
        catch (Exception e) {
            error = e;
            if (e instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e;
            }
            if (e instanceof AttributeNotFoundException) {
                throw (AttributeNotFoundException)e;
            }
            if (e instanceof InvalidAttributeValueException) {
                throw (InvalidAttributeValueException)e;
            }
            if (e instanceof MBeanException) {
                throw (MBeanException)e;
            }
            if (e instanceof ReflectionException) {
                throw (ReflectionException)e;
            }
            throw this.makeRuntimeException(e);
        }
        finally {
            if (this.shouldAuditLog(delegate, false)) {
                new MBeanServerAuditLogRecordFormatter(this, error, false).setAttribute(name, attribute);
            }
        }
    }

    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException {
        Exception error = null;
        MBeanServerPlugin delegate = null;
        boolean readOnly = false;
        try {
            delegate = this.findDelegate(name);
            for (Attribute attribute : attributes.asList()) {
                this.authorizeMBeanOperation(delegate, name, "setAttribute", attribute.getName(), JmxAction.Impact.WRITE);
            }
            AttributeList attributeList = delegate.setAttributes(name, attributes);
            return attributeList;
        }
        catch (Exception e) {
            error = e;
            if (e instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e;
            }
            if (e instanceof ReflectionException) {
                throw (ReflectionException)e;
            }
            throw this.makeRuntimeException(e);
        }
        finally {
            if (this.shouldAuditLog(delegate, false)) {
                new MBeanServerAuditLogRecordFormatter(this, error, false).setAttributes(name, attributes);
            }
        }
    }

    public void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException {
        Exception error = null;
        MBeanServerPlugin delegate = null;
        boolean readOnly = false;
        try {
            delegate = this.findDelegate(name);
            this.authorizeMBeanOperation(delegate, name, "unregisterMBean", null, JmxAction.Impact.WRITE);
            delegate.unregisterMBean(name);
        }
        catch (Exception e) {
            error = e;
            if (e instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)e;
            }
            if (e instanceof MBeanRegistrationException) {
                throw (MBeanRegistrationException)e;
            }
            throw this.makeRuntimeException(e);
        }
        finally {
            if (this.shouldAuditLog(delegate, false)) {
                new MBeanServerAuditLogRecordFormatter(this, error, false).unregisterMBean(name);
            }
        }
    }

    private MBeanServerPlugin findDelegate(ObjectName name) throws InstanceNotFoundException {
        if (name == null) {
            throw JmxLogger.ROOT_LOGGER.objectNameCantBeNull();
        }
        if (this.delegates.size() > 0) {
            for (MBeanServerPlugin delegate : this.delegates) {
                if (!delegate.accepts(name) || !delegate.isRegistered(name)) continue;
                return delegate;
            }
        }
        if (this.rootMBeanServer.isRegistered(name)) {
            return this.rootMBeanServer;
        }
        throw new InstanceNotFoundException(name.toString());
    }

    private MBeanServerPlugin findDelegateForNewObject(ObjectName name) {
        if (name == null) {
            return this.rootMBeanServer;
        }
        if (this.delegates.size() > 0) {
            for (MBeanServerPlugin delegate : this.delegates) {
                if (!delegate.accepts(name)) continue;
                return delegate;
            }
        }
        return this.rootMBeanServer;
    }

    private boolean shouldAuditLog(MBeanServerPlugin delegate, boolean readOnly) {
        if (this.auditLogger != null) {
            if (delegate == null) {
                return true;
            }
            return delegate.shouldAuditLog();
        }
        return false;
    }

    private RuntimeException makeRuntimeException(Exception e) {
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new RuntimeException(e);
    }

    private boolean isOperationReadOnly(ObjectName name, String operationName, String[] signature) {
        MBeanInfo info;
        try {
            info = this.getMBeanInfo(name, false, true);
        }
        catch (Exception e) {
            return false;
        }
        if (info == null) {
            return false;
        }
        for (MBeanOperationInfo op : info.getOperations()) {
            MBeanParameterInfo[] params;
            if (!op.getName().equals(operationName) || (params = op.getSignature()).length != signature.length) continue;
            boolean same = true;
            for (int i = 0; i < params.length; ++i) {
                if (params[i].getType().equals(signature[i])) continue;
                same = false;
                break;
            }
            if (!same) continue;
            return op.getImpact() == 0;
        }
        return false;
    }

    void log(boolean readOnly, Throwable error, String methodName, String[] methodSignature, Object ... methodParams) {
        String userId;
        String string = userId = this.securityIdentitySupplier != null ? this.securityIdentitySupplier.get().getPrincipal().getName() : null;
        if (WildFlySecurityManager.isChecking()) {
            AccessController.doPrivileged(new LogAction(userId, this.auditLogger, readOnly, error, methodName, methodSignature, methodParams));
        } else {
            LogAction.doLog(userId, this.auditLogger, readOnly, error, methodName, methodSignature, methodParams);
        }
    }

    private void authorizeMBeanOperation(MBeanServerPlugin delegate, ObjectName name, String methodName, String attributeName, JmxAction.Impact impact) throws MBeanException {
        this.authorizeMBeanOperation(delegate, name, methodName, attributeName, impact, true);
    }

    private boolean authorizeMBeanOperation(MBeanServerPlugin delegate, ObjectName name, String methodName, String attributeName, JmxAction.Impact impact, boolean exception) throws MBeanException {
        if (this.authorizer != null && delegate.shouldAuthorize()) {
            JmxTarget target = new JmxTarget(methodName, name, this.isNonFacadeMBeansSensitive(), (HostEffect)this.jmxEffect, (ServerGroupEffect)this.jmxEffect);
            JmxAction action = new JmxAction(methodName, impact, attributeName);
            SecurityIdentity securityIdentity = this.securityIdentitySupplier != null ? this.securityIdentitySupplier.get() : null;
            AuthorizationResult authorizationResult = this.authorizer.authorizeJmxOperation(SecurityActions.createCaller(securityIdentity), null, action, target);
            if (authorizationResult.getDecision() != AuthorizationResult.Decision.PERMIT) {
                if (exception) {
                    throw JmxLogger.ROOT_LOGGER.unauthorized();
                }
                return false;
            }
        }
        return true;
    }

    private void authorizeClassloadingOperation(MBeanServerPlugin delegate, String methodName) throws MBeanException {
        this.authorizeClassloadingOperation(delegate, ObjectName.WILDCARD, methodName);
    }

    private void authorizeClassloadingOperation(MBeanServerPlugin delegate, ObjectName objectName, String methodName) throws MBeanException {
        if (this.authorizer != null && delegate.shouldAuthorize()) {
            JmxTarget target = new JmxTarget(methodName, objectName, this.isNonFacadeMBeansSensitive(), (HostEffect)this.jmxEffect, (ServerGroupEffect)this.jmxEffect);
            JmxAction action = new JmxAction(methodName, JmxAction.Impact.CLASSLOADING);
            SecurityIdentity securityIdentity = this.securityIdentitySupplier != null ? this.securityIdentitySupplier.get() : null;
            AuthorizationResult authorizationResult = this.authorizer.authorizeJmxOperation(SecurityActions.createCaller(securityIdentity), null, action, target);
            if (authorizationResult.getDecision() != AuthorizationResult.Decision.PERMIT) {
                throw JmxLogger.ROOT_LOGGER.unauthorized();
            }
        }
    }

    private String[] nullAsEmpty(String[] array) {
        if (array == null) {
            return EMPTY_SIG;
        }
        return array;
    }

    private Object[] nullAsEmpty(Object[] array) {
        if (array == null) {
            return NO_ARGS;
        }
        return array;
    }

    private boolean isNonFacadeMBeansSensitive() {
        return this.authorizer == null ? false : this.authorizer.isNonFacadeMBeansSensitive();
    }

    MBeanServerDelegate getMBeanServerDelegate() {
        return this.rootMBeanServerDelegate;
    }

    private class TcclMBeanServer
    implements MBeanServerPlugin {
        private final MBeanServer delegate;
        private final Map<NotificationListener, NotificationListener> listeners = new HashMap<NotificationListener, NotificationListener>();

        public TcclMBeanServer(MBeanServer delegate) {
            this.delegate = delegate;
        }

        public boolean accepts(ObjectName objectName) {
            return true;
        }

        public boolean shouldAuditLog() {
            return true;
        }

        public boolean shouldAuthorize() {
            return AuthorizingMBeanServer.isAuthorizing();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addNotificationListener(ObjectName name, final NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
            ClassLoader old = this.pushClassLoader(name);
            try {
                NotificationListener notificationListener = new NotificationListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void handleNotification(Notification notification, Object handback) {
                        ClassLoader previous = null;
                        try {
                            previous = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
                            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)listener.getClass().getClassLoader());
                            listener.handleNotification(notification, handback);
                        }
                        finally {
                            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)previous);
                        }
                    }
                };
                this.listeners.put(listener, notificationListener);
                this.delegate.addNotificationListener(name, notificationListener, filter, handback);
            }
            finally {
                this.resetClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
            ClassLoader old = this.pushClassLoader(name);
            try {
                this.delegate.addNotificationListener(name, listener, filter, handback);
            }
            finally {
                this.resetClassLoader(old);
            }
        }

        public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException {
            return this.delegate.createMBean(className, name, params, signature);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
            ClassLoader old = this.pushClassLoaderByName(loaderName);
            try {
                ObjectInstance objectInstance = this.delegate.createMBean(className, name, loaderName, params, signature);
                return objectInstance;
            }
            finally {
                this.resetClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
            ClassLoader old = this.pushClassLoaderByName(loaderName);
            try {
                ObjectInstance objectInstance = this.delegate.createMBean(className, name, loaderName);
                return objectInstance;
            }
            finally {
                this.resetClassLoader(old);
            }
        }

        public ObjectInstance createMBean(String className, ObjectName name) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException {
            return this.delegate.createMBean(className, name);
        }

        @Deprecated
        public ObjectInputStream deserialize(ObjectName name, byte[] data) throws OperationsException {
            return this.delegate.deserialize(name, data);
        }

        @Deprecated
        public ObjectInputStream deserialize(String className, byte[] data) throws OperationsException, ReflectionException {
            return this.delegate.deserialize(className, data);
        }

        @Deprecated
        public ObjectInputStream deserialize(String className, ObjectName loaderName, byte[] data) throws OperationsException, ReflectionException {
            return this.delegate.deserialize(className, loaderName, data);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
            ClassLoader old = this.pushClassLoader(name);
            try {
                Object object = this.delegate.getAttribute(name, attribute);
                return object;
            }
            finally {
                this.resetClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException {
            ClassLoader old = this.pushClassLoader(name);
            try {
                AttributeList attributeList = this.delegate.getAttributes(name, attributes);
                return attributeList;
            }
            finally {
                this.resetClassLoader(old);
            }
        }

        public ClassLoader getClassLoader(ObjectName loaderName) throws InstanceNotFoundException {
            return this.delegate.getClassLoader(loaderName);
        }

        public ClassLoader getClassLoaderFor(ObjectName mbeanName) throws InstanceNotFoundException {
            return this.delegate.getClassLoaderFor(mbeanName);
        }

        public ClassLoaderRepository getClassLoaderRepository() {
            return this.delegate.getClassLoaderRepository();
        }

        public String getDefaultDomain() {
            return this.delegate.getDefaultDomain();
        }

        public String[] getDomains() {
            return this.delegate.getDomains();
        }

        public Integer getMBeanCount() {
            return this.delegate.getMBeanCount();
        }

        public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
            return this.delegate.getMBeanInfo(name);
        }

        public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException {
            return this.delegate.getObjectInstance(name);
        }

        public Object instantiate(String className, Object[] params, String[] signature) throws ReflectionException, MBeanException {
            return this.delegate.instantiate(className, params, signature);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object instantiate(String className, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, MBeanException, InstanceNotFoundException {
            ClassLoader old = this.pushClassLoaderByName(loaderName);
            try {
                Object object = this.delegate.instantiate(className, loaderName, params, signature);
                return object;
            }
            finally {
                this.resetClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object instantiate(String className, ObjectName loaderName) throws ReflectionException, MBeanException, InstanceNotFoundException {
            ClassLoader old = this.pushClassLoaderByName(loaderName);
            try {
                Object object = this.delegate.instantiate(className, loaderName);
                return object;
            }
            finally {
                this.resetClassLoader(old);
            }
        }

        public Object instantiate(String className) throws ReflectionException, MBeanException {
            return this.delegate.instantiate(className);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException {
            ClassLoader old = this.pushClassLoader(name);
            try {
                Object object = this.delegate.invoke(name, operationName, params, signature);
                return object;
            }
            finally {
                this.resetClassLoader(old);
            }
        }

        public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException {
            return this.delegate.isInstanceOf(name, className);
        }

        public boolean isRegistered(ObjectName name) {
            return this.delegate.isRegistered(name);
        }

        public Set<ObjectInstance> queryMBeans(ObjectName name, QueryExp query) {
            return this.delegate.queryMBeans(name, query);
        }

        public Set<ObjectName> queryNames(ObjectName name, QueryExp query) {
            return this.delegate.queryNames(name, query);
        }

        public ObjectInstance registerMBean(Object object, ObjectName name) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
            return this.delegate.registerMBean(object, name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
            ClassLoader old = this.pushClassLoader(name);
            try {
                if (this.listeners.containsKey(listener)) {
                    this.delegate.removeNotificationListener(name, this.listeners.get(listener), filter, handback);
                    this.listeners.remove(listener);
                } else {
                    this.delegate.removeNotificationListener(name, listener, filter, handback);
                }
            }
            finally {
                this.resetClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException {
            ClassLoader old = this.pushClassLoader(name);
            try {
                if (this.listeners.containsKey(listener)) {
                    this.delegate.removeNotificationListener(name, this.listeners.get(listener));
                    this.listeners.remove(listener);
                } else {
                    this.delegate.removeNotificationListener(name, listener);
                }
            }
            finally {
                this.resetClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
            ClassLoader old = this.pushClassLoader(name);
            try {
                this.delegate.removeNotificationListener(name, listener, filter, handback);
            }
            finally {
                this.resetClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException {
            ClassLoader old = this.pushClassLoader(name);
            try {
                this.delegate.removeNotificationListener(name, listener);
            }
            finally {
                this.resetClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
            ClassLoader old = this.pushClassLoader(name);
            try {
                this.delegate.setAttribute(name, attribute);
            }
            finally {
                this.resetClassLoader(old);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException {
            ClassLoader old = this.pushClassLoader(name);
            try {
                AttributeList attributeList = this.delegate.setAttributes(name, attributes);
                return attributeList;
            }
            finally {
                this.resetClassLoader(old);
            }
        }

        public void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException {
            this.delegate.unregisterMBean(name);
        }

        private ClassLoader pushClassLoader(final ObjectName name) throws InstanceNotFoundException {
            ClassLoader mbeanCl;
            try {
                mbeanCl = AccessController.doPrivileged(new PrivilegedExceptionAction<ClassLoader>(){

                    @Override
                    public ClassLoader run() throws InstanceNotFoundException {
                        return TcclMBeanServer.this.delegate.getClassLoaderFor(name);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                try {
                    throw e.getCause();
                }
                catch (RuntimeException r) {
                    throw r;
                }
                catch (InstanceNotFoundException ie) {
                    throw ie;
                }
                catch (Error error) {
                    throw error;
                }
                catch (Throwable throwable) {
                    throw new UndeclaredThrowableException(throwable);
                }
            }
            return WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)mbeanCl);
        }

        private ClassLoader pushClassLoaderByName(final ObjectName loaderName) throws InstanceNotFoundException {
            ClassLoader mbeanCl;
            try {
                mbeanCl = AccessController.doPrivileged(new PrivilegedExceptionAction<ClassLoader>(){

                    @Override
                    public ClassLoader run() throws Exception {
                        return TcclMBeanServer.this.delegate.getClassLoader(loaderName);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                try {
                    throw e.getCause();
                }
                catch (RuntimeException r) {
                    throw r;
                }
                catch (InstanceNotFoundException ie) {
                    throw ie;
                }
                catch (Error error) {
                    throw error;
                }
                catch (Throwable throwable) {
                    throw new UndeclaredThrowableException(throwable);
                }
            }
            return WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)mbeanCl);
        }

        private void resetClassLoader(ClassLoader cl) {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)cl);
        }
    }

    static final class LogAction
    implements PrivilegedAction<Void> {
        final String userId;
        final ManagedAuditLogger auditLogger;
        final boolean readOnly;
        final Throwable error;
        final String methodName;
        final String[] methodSignature;
        final Object[] methodParams;

        public LogAction(String userId, ManagedAuditLogger auditLogger, boolean readOnly, Throwable error, String methodName, String[] methodSignature, Object[] methodParams) {
            this.userId = userId;
            this.auditLogger = auditLogger;
            this.readOnly = readOnly;
            this.error = error;
            this.methodName = methodName;
            this.methodSignature = methodSignature;
            this.methodParams = methodParams;
        }

        @Override
        public Void run() {
            LogAction.doLog(this.userId, this.auditLogger, this.readOnly, this.error, this.methodName, this.methodSignature, this.methodParams);
            return null;
        }

        static void doLog(String userId, ManagedAuditLogger auditLogger, boolean readOnly, Throwable error, String methodName, String[] methodSignature, Object ... methodParams) {
            if (auditLogger != null) {
                AccessAuditContext auditContext = SecurityActions.currentAccessAuditContext();
                auditLogger.logJmxMethodAccess(readOnly, userId, auditContext == null ? null : auditContext.getDomainUuid(), auditContext == null ? null : auditContext.getAccessMechanism(), auditContext == null ? null : auditContext.getRemoteAddress(), methodName, methodSignature, methodParams, error);
            }
        }
    }
}

