/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.soteria.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Set;
import java.util.function.BiFunction;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InjectionPoint;
import org.glassfish.soteria.cdi.CdiProducer;
import org.glassfish.soteria.cdi.DefaultAnnotationLiteral;

public class CdiDecorator<T>
extends CdiProducer<T>
implements Decorator<T> {
    private Class<T> decorator;
    private Type delegateType;
    private Set<Type> decoratedTypes;
    private BeanManager beanManager;
    private InjectionPoint decoratorInjectionPoint;
    private Set<InjectionPoint> injectionPoints;
    private BiFunction<CreationalContext<T>, Object, T> create;

    @Override
    public T create(CreationalContext<T> creationalContext) {
        return this.create.apply(creationalContext, this.beanManager.getInjectableReference(this.decoratorInjectionPoint, creationalContext));
    }

    @Override
    public Set<InjectionPoint> getInjectionPoints() {
        return this.injectionPoints;
    }

    public Type getDelegateType() {
        return this.delegateType;
    }

    public Set<Type> getDecoratedTypes() {
        return this.decoratedTypes;
    }

    public Set<Annotation> getDelegateQualifiers() {
        return Collections.emptySet();
    }

    public CdiDecorator<T> decorator(Class<T> decorator) {
        this.decorator = decorator;
        this.beanClassAndType(decorator);
        return this;
    }

    public CdiDecorator<T> delegateAndDecoratedType(Type type) {
        this.delegateType = type;
        this.decoratedTypes = CdiDecorator.asSet(type);
        return this;
    }

    public CdiProducer<T> create(BeanManager beanManager, BiFunction<CreationalContext<T>, Object, T> create) {
        this.decoratorInjectionPoint = new DecoratorInjectionPoint(this.getDelegateType(), (AnnotatedField)beanManager.createAnnotatedType(this.decorator).getFields().iterator().next(), this);
        this.injectionPoints = Collections.singleton(this.decoratorInjectionPoint);
        this.beanManager = beanManager;
        this.create = create;
        return this;
    }

    private static class DecoratorInjectionPoint
    implements InjectionPoint {
        private final Set<Annotation> qualifiers = Collections.singleton(new DefaultAnnotationLiteral());
        private final Type type;
        private final AnnotatedField<?> annotatedField;
        private final Bean<?> bean;

        public DecoratorInjectionPoint(Type type, AnnotatedField<?> annotatedField, Bean<?> bean) {
            this.type = type;
            this.annotatedField = annotatedField;
            this.bean = bean;
        }

        public Type getType() {
            return this.type;
        }

        public Set<Annotation> getQualifiers() {
            return this.qualifiers;
        }

        public Bean<?> getBean() {
            return this.bean;
        }

        public Member getMember() {
            return this.annotatedField.getJavaMember();
        }

        public Annotated getAnnotated() {
            return this.annotatedField;
        }

        public boolean isDelegate() {
            return true;
        }

        public boolean isTransient() {
            return false;
        }
    }
}

