/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.security;

import io.undertow.predicate.Predicate;
import io.undertow.predicate.Predicates;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.PredicateHandler;
import io.undertow.servlet.handlers.ServletChain;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.servlet.predicate.DispatcherTypePredicate;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import javax.servlet.ServletRequest;
import org.jboss.metadata.javaee.jboss.RunAsIdentityMetaData;
import org.jboss.security.RunAs;
import org.jboss.security.RunAsIdentity;
import org.jboss.security.SecurityContext;
import org.wildfly.extension.undertow.logging.UndertowLogger;
import org.wildfly.extension.undertow.security.SecurityActions;
import org.wildfly.extension.undertow.security.UndertowSecurityAttachments;

public class SecurityContextAssociationHandler
implements HttpHandler {
    private final Map<String, RunAsIdentityMetaData> runAsIdentityMetaDataMap;
    private final HttpHandler next;
    private static final PrivilegedAction<ServletRequestContext> CURRENT_CONTEXT = new PrivilegedAction<ServletRequestContext>(){

        @Override
        public ServletRequestContext run() {
            return ServletRequestContext.current();
        }
    };

    public SecurityContextAssociationHandler(Map<String, RunAsIdentityMetaData> runAsIdentityMetaDataMap, HttpHandler next) {
        this.runAsIdentityMetaDataMap = runAsIdentityMetaDataMap;
        this.next = next;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        SecurityContext sc = (SecurityContext)exchange.getAttachment(UndertowSecurityAttachments.SECURITY_CONTEXT_ATTACHMENT);
        RunAsIdentityMetaData identity = null;
        RunAs old = null;
        try {
            ServletChain servlet = ((ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY)).getCurrentServlet();
            identity = this.runAsIdentityMetaDataMap.get(servlet.getManagedServlet().getServletInfo().getName());
            RunAsIdentity runAsIdentity = null;
            if (identity != null) {
                UndertowLogger.ROOT_LOGGER.tracef("%s, runAs: %s", servlet.getManagedServlet().getServletInfo().getName(), identity);
                runAsIdentity = new RunAsIdentity(identity.getRoleName(), identity.getPrincipalName(), identity.getRunAsRoles());
            }
            old = SecurityActions.setRunAsIdentity(runAsIdentity, sc);
            this.next.handleRequest(exchange);
            if (identity == null) return;
        }
        catch (Throwable throwable) {
            if (identity == null) throw throwable;
            SecurityActions.setRunAsIdentity(old, sc);
            throw throwable;
        }
        SecurityActions.setRunAsIdentity(old, sc);
    }

    public static HandlerWrapper wrapper(final Map<String, RunAsIdentityMetaData> runAsIdentityMetaDataMap) {
        return new HandlerWrapper(){

            public HttpHandler wrap(HttpHandler handler) {
                return new PredicateHandler(Predicates.or((Predicate[])new Predicate[]{DispatcherTypePredicate.REQUEST, DispatcherTypePredicate.ASYNC}), (HttpHandler)new SecurityContextAssociationHandler(runAsIdentityMetaDataMap, handler), handler);
            }
        };
    }

    public static ServletRequest getActiveRequest() {
        ServletRequestContext current = System.getSecurityManager() == null ? ServletRequestContext.current() : AccessController.doPrivileged(CURRENT_CONTEXT);
        if (current == null) {
            return null;
        }
        return current.getServletRequest();
    }
}

