/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.cache.session.fine;

import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import org.infinispan.protostream.impl.WireFormat;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.marshalling.protostream.util.UUIDBuilder;
import org.wildfly.clustering.marshalling.protostream.util.UUIDMarshaller;
import org.wildfly.clustering.web.cache.session.fine.SessionAttributeMapEntry;

public enum SessionAttributeMapEntryMarshaller implements ProtoStreamMarshaller<Map.Entry<String, UUID>>
{
    INSTANCE;

    private static final int ATTRIBUTE_NAME_INDEX = 1;
    private static final int ATTRIBUTE_ID_INDEX = 2;

    public Map.Entry<String, UUID> readFrom(ProtoStreamReader reader) throws IOException {
        String attributeName = null;
        UUIDBuilder attributeIdBuilder = UUIDMarshaller.INSTANCE.getBuilder();
        boolean reading = true;
        while (reading) {
            int tag = reader.readTag();
            int index = WireFormat.getTagFieldNumber((int)tag);
            if (index == 1) {
                attributeName = reader.readString();
                continue;
            }
            if (index >= 2 && index < 2 + UUIDMarshaller.INSTANCE.getFields()) {
                attributeIdBuilder = UUIDMarshaller.INSTANCE.readField(reader, index - 2, attributeIdBuilder);
                continue;
            }
            reading = tag != 0 && reader.skipField(tag);
        }
        return new SessionAttributeMapEntry(attributeName, (UUID)attributeIdBuilder.build());
    }

    public void writeTo(ProtoStreamWriter writer, Map.Entry<String, UUID> entry) throws IOException {
        writer.writeString(1, entry.getKey());
        UUIDMarshaller.INSTANCE.writeFields(writer, 2, entry.getValue());
    }

    public Class<? extends SessionAttributeMapEntry> getJavaClass() {
        return SessionAttributeMapEntry.class;
    }
}

